/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public class DriverProxy {
    public static final int MSG_BUFFER_CAPACITY = 1024;
    private final UnsafeBuffer buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)1024, (int)128));
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveMessageFlyweight removeMessage = new RemoveMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer toDriverCommandBuffer) {
        this.toDriverCommandBuffer = toDriverCommandBuffer;
        this.publicationMessage.wrap((MutableDirectBuffer)this.buffer, 0);
        this.subscriptionMessage.wrap((MutableDirectBuffer)this.buffer, 0);
        this.correlatedMessage.wrap((MutableDirectBuffer)this.buffer, 0);
        this.removeMessage.wrap((MutableDirectBuffer)this.buffer, 0);
        long clientId = toDriverCommandBuffer.nextCorrelationId();
        this.correlatedMessage.clientId(clientId);
    }

    public long timeOfLastDriverKeepalive() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.publicationMessage.correlationId(correlationId);
        this.publicationMessage.streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(1, (DirectBuffer)this.buffer, 0, this.publicationMessage.length())) {
            throw new IllegalStateException("Could not write add publication command");
        }
        return correlationId;
    }

    public long removePublication(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(2, (DirectBuffer)this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new IllegalStateException("Could not write remove publication command");
        }
        return correlationId;
    }

    public long addSubscription(String channel, int streamId) {
        long registrationId = -1L;
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.subscriptionMessage.correlationId(correlationId);
        this.subscriptionMessage.registrationCorrelationId(-1L).streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(4, (DirectBuffer)this.buffer, 0, this.subscriptionMessage.length())) {
            throw new IllegalStateException("Could not write add subscription command");
        }
        return correlationId;
    }

    public long removeSubscription(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(5, (DirectBuffer)this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new IllegalStateException("Could not write remove subscription message");
        }
        return correlationId;
    }

    public void sendClientKeepalive() {
        this.correlatedMessage.correlationId(0L);
        if (!this.toDriverCommandBuffer.write(6, (DirectBuffer)this.buffer, 0, 16)) {
            throw new IllegalStateException("Could not send client keepalive command");
        }
    }
}

