/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BufferBuilder {
    static final int MAX_CAPACITY = 0x7FFFFFF7;
    static final int INIT_MIN_CAPACITY = 4096;
    private final boolean isDirect;
    private int limit = 0;
    private final UnsafeBuffer buffer;

    public BufferBuilder() {
        this(0, false);
    }

    public BufferBuilder(int initialCapacity) {
        this(initialCapacity, false);
    }

    public BufferBuilder(int initialCapacity, boolean isDirect) {
        if (initialCapacity < 0 || initialCapacity > 0x7FFFFFF7) {
            throw new IllegalArgumentException("initialCapacity outside range 0 - 2147483639: initialCapacity=" + initialCapacity);
        }
        this.isDirect = isDirect;
        if (isDirect) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(initialCapacity);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer = new UnsafeBuffer(byteBuffer);
        } else {
            this.buffer = new UnsafeBuffer(new byte[initialCapacity]);
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        if (limit < 0 || limit >= this.buffer.capacity()) {
            throw new IllegalArgumentException("limit outside range: capacity=" + this.buffer.capacity() + " limit=" + limit);
        }
        this.limit = limit;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public BufferBuilder reset() {
        this.limit = 0;
        return this;
    }

    public BufferBuilder compact() {
        this.resize(Math.max(4096, this.limit));
        return this;
    }

    public BufferBuilder append(DirectBuffer srcBuffer, int srcOffset, int length) {
        this.ensureCapacity(length);
        this.buffer.putBytes(this.limit, srcBuffer, srcOffset, length);
        this.limit += length;
        return this;
    }

    private void ensureCapacity(int additionalLength) {
        long requiredCapacity = (long)this.limit + (long)additionalLength;
        int capacity = this.buffer.capacity();
        if (requiredCapacity > (long)capacity) {
            if (requiredCapacity > 0x7FFFFFF7L) {
                throw new IllegalStateException("insufficient capacity: maxCapacity=2147483639 limit=" + this.limit + " additionalLength=" + additionalLength);
            }
            this.resize(BufferBuilder.findSuitableCapacity(capacity, requiredCapacity));
        }
    }

    private void resize(int newCapacity) {
        if (this.isDirect) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(newCapacity);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer.getBytes(0, byteBuffer, 0, this.limit);
            this.buffer.wrap(byteBuffer);
        } else {
            this.buffer.wrap(Arrays.copyOf(this.buffer.byteArray(), newCapacity));
        }
    }

    static int findSuitableCapacity(int capacity, long requiredCapacity) {
        long newCapacity = Math.max(capacity, 4096);
        while (newCapacity < requiredCapacity) {
            if ((newCapacity += newCapacity >> 1) <= 0x7FFFFFF7L) continue;
            newCapacity = 0x7FFFFFF7L;
        }
        return (int)newCapacity;
    }
}

