/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.MutableDirectBuffer;

public class CorrelatedMessageFlyweight {
    public static final int LENGTH = 16;
    private static final int CLIENT_ID_FIELD_OFFSET = 0;
    static final int CORRELATION_ID_FIELD_OFFSET = 8;
    MutableDirectBuffer buffer;
    int offset;

    public final CorrelatedMessageFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public long clientId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public CorrelatedMessageFlyweight clientId(long clientId) {
        this.buffer.putLong(this.offset + 0, clientId);
        return this;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8);
    }

    public CorrelatedMessageFlyweight correlationId(long correlationId) {
        this.buffer.putLong(this.offset + 8, correlationId);
        return this;
    }

    public void validateLength(int msgTypeId, int length) {
        if (length < 16) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
    }
}

