/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;

public class CounterMessageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int COUNTER_TYPE_ID_FIELD_OFFSET = 16;
    private static final int KEY_LENGTH_OFFSET = 20;
    static final int KEY_BUFFER_OFFSET = 24;
    private static final int MINIMUM_LENGTH = 24;

    public int typeId() {
        return this.buffer.getInt(this.offset + 16);
    }

    public CounterMessageFlyweight typeId(long typeId) {
        this.buffer.putLong(this.offset + 16, typeId);
        return this;
    }

    public int keyBufferOffset() {
        return 24;
    }

    public int keyBufferLength() {
        return this.buffer.getInt(this.offset + 20);
    }

    public CounterMessageFlyweight keyBuffer(DirectBuffer keyBuffer, int keyOffset, int keyLength) {
        this.buffer.putInt(this.offset + 20, keyLength);
        if (null != keyBuffer && keyLength > 0) {
            this.buffer.putBytes(this.offset + 24, keyBuffer, keyOffset, keyLength);
        }
        return this;
    }

    public int labelBufferOffset() {
        return this.labelOffset() + 4;
    }

    public int labelBufferLength() {
        return this.buffer.getInt(this.offset + this.labelOffset());
    }

    public CounterMessageFlyweight labelBuffer(DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        this.buffer.putInt(this.offset + this.labelOffset(), labelLength);
        if (null != labelBuffer && labelLength > 0) {
            this.buffer.putBytes(this.offset + this.labelBufferOffset(), labelBuffer, labelOffset, labelLength);
        }
        return this;
    }

    public CounterMessageFlyweight label(String label) {
        this.buffer.putStringAscii(this.labelOffset(), label);
        return this;
    }

    public int length() {
        int labelOffset = this.labelOffset();
        return labelOffset + 4 + this.labelBufferLength();
    }

    @Override
    public void validateLength(int msgTypeId, int length) {
        if (length < 24) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
        int labelOffset = this.labelOffset();
        if (length - labelOffset < 4) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short for key: length=" + length);
        }
        if (length < this.length()) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short for label: length=" + length);
        }
    }

    private int labelOffset() {
        return 24 + BitUtil.align((int)this.keyBufferLength(), (int)4);
    }
}

