/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverProxy;
import io.aeron.ExclusivePublication;
import io.aeron.LogBuffersFactory;
import io.aeron.MappedLogBuffersFactory;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.CountersReader;

public class Aeron
implements AutoCloseable {
    public static final int NULL_VALUE = -1;
    private static final AtomicIntegerFieldUpdater<Aeron> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Aeron.class, "isClosed");
    private volatile int isClosed;
    private final long clientId;
    private final ClientConductor conductor;
    private final RingBuffer commandBuffer;
    private final AgentInvoker conductorInvoker;
    private final AgentRunner conductorRunner;
    private final Context ctx;

    Aeron(Context ctx) {
        try {
            ctx.conclude();
            this.ctx = ctx;
            this.clientId = ctx.clientId();
            this.commandBuffer = ctx.toDriverBuffer();
            this.conductor = new ClientConductor(ctx, this);
            if (ctx.useConductorAgentInvoker()) {
                this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), null, (Agent)this.conductor);
                this.conductorRunner = null;
            } else {
                this.conductorInvoker = null;
                this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), null, (Agent)this.conductor);
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static Aeron connect() {
        return Aeron.connect(new Context());
    }

    public static Aeron connect(Context ctx) {
        try {
            Aeron aeron = new Aeron(ctx);
            if (ctx.useConductorAgentInvoker()) {
                aeron.conductorInvoker.start();
            } else {
                AgentRunner.startOnThread((AgentRunner)aeron.conductorRunner, (ThreadFactory)ctx.threadFactory());
            }
            return aeron;
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ctx.close();
            throw ex;
        }
    }

    public void printCounters(PrintStream out) {
        CountersReader counters = this.countersReader();
        counters.forEach((value, id, label) -> out.format("%3d: %,20d - %s%n", id, value, label));
    }

    public boolean isClosed() {
        return 1 == this.isClosed;
    }

    public Context context() {
        return this.ctx;
    }

    public long clientId() {
        return this.clientId;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.conductorInvoker;
    }

    public boolean isCommandActive(long correlationId) {
        return this.conductor.isCommandActive(correlationId);
    }

    public boolean hasActiveCommands() {
        return this.conductor.hasActiveCommands();
    }

    @Override
    public void close() {
        if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            ErrorHandler errorHandler = this.ctx.errorHandler();
            if (null != this.conductorRunner) {
                CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.conductorRunner);
            } else {
                CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.conductorInvoker);
            }
        }
    }

    public ConcurrentPublication addPublication(String channel, int streamId) {
        return this.conductor.addPublication(channel, streamId);
    }

    public ExclusivePublication addExclusivePublication(String channel, int streamId) {
        return this.conductor.addExclusivePublication(channel, streamId);
    }

    public Subscription addSubscription(String channel, int streamId) {
        return this.conductor.addSubscription(channel, streamId);
    }

    public Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        return this.conductor.addSubscription(channel, streamId, availableImageHandler, unavailableImageHandler);
    }

    public long nextCorrelationId() {
        if (1 == this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.commandBuffer.nextCorrelationId();
    }

    public CountersReader countersReader() {
        if (1 == this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.conductor.countersReader();
    }

    public Counter addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return this.conductor.addCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
    }

    public Counter addCounter(int typeId, String label) {
        return this.conductor.addCounter(typeId, label);
    }

    public long addAvailableCounterHandler(AvailableCounterHandler handler) {
        return this.conductor.addAvailableCounterHandler(handler);
    }

    public boolean removeAvailableCounterHandler(long registrationId) {
        return this.conductor.removeAvailableCounterHandler(registrationId);
    }

    @Deprecated
    public boolean removeAvailableCounterHandler(AvailableCounterHandler handler) {
        return this.conductor.removeAvailableCounterHandler(handler);
    }

    public long addUnavailableCounterHandler(UnavailableCounterHandler handler) {
        return this.conductor.addUnavailableCounterHandler(handler);
    }

    public boolean removeUnavailableCounterHandler(long registrationId) {
        return this.conductor.removeUnavailableCounterHandler(registrationId);
    }

    @Deprecated
    public boolean removeUnavailableCounterHandler(UnavailableCounterHandler handler) {
        return this.conductor.removeUnavailableCounterHandler(handler);
    }

    public long addCloseHandler(Runnable handler) {
        return this.conductor.addCloseHandler(handler);
    }

    public boolean removeCloseHandler(long registrationId) {
        return this.conductor.removeCloseHandler(registrationId);
    }

    @Deprecated
    public boolean removeCloseHandler(Runnable handler) {
        return this.conductor.removeCloseHandler(handler);
    }

    void internalClose() {
        this.isClosed = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MappedByteBuffer waitForFileMapping(File file, EpochClock clock, long deadlineMs) {
        try {
            long fileSize;
            Throwable throwable;
            FileChannel fileChannel;
            while (true) {
                block19: {
                    fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                    throwable = null;
                    fileSize = fileChannel.size();
                    if (fileSize >= (long)CncFileDescriptor.META_DATA_LENGTH) break;
                    if (clock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file is created but not populated");
                    }
                    fileChannel.close();
                    Aeron.sleep(16L);
                    if (fileChannel == null) continue;
                    if (throwable == null) break block19;
                    try {
                        fileChannel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                fileChannel.close();
            }
            try {
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
                return mappedByteBuffer;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (fileChannel != null) {
                    if (throwable != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileChannel.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new AeronException("cannot open CnC file", ex);
        }
    }

    static void sleep(long durationMs) {
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    public static class Context
    extends CommonContext {
        private long clientId;
        private boolean useConductorAgentInvoker = false;
        private boolean preTouchMappedMemory = Configuration.preTouchMappedMemory();
        private AgentInvoker driverAgentInvoker;
        private Lock clientLock;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private IdleStrategy idleStrategy;
        private IdleStrategy awaitingIdleStrategy;
        private CopyBroadcastReceiver toClientBuffer;
        private RingBuffer toDriverBuffer;
        private DriverProxy driverProxy;
        private MappedByteBuffer cncByteBuffer;
        private AtomicBuffer cncMetaDataBuffer;
        private LogBuffersFactory logBuffersFactory;
        private ErrorHandler errorHandler;
        private ErrorHandler subscriberErrorHandler;
        private AvailableImageHandler availableImageHandler;
        private UnavailableImageHandler unavailableImageHandler;
        private AvailableCounterHandler availableCounterHandler;
        private UnavailableCounterHandler unavailableCounterHandler;
        private Runnable closeHandler;
        private long keepAliveIntervalNs = Configuration.KEEPALIVE_INTERVAL_NS;
        private long interServiceTimeoutNs = 0L;
        private long resourceLingerDurationNs = Configuration.resourceLingerDurationNs();
        private long closeLingerDurationNs = Configuration.closeLingerDurationNs();
        private ThreadFactory threadFactory = Thread::new;

        @Override
        public Context clone() {
            return (Context)super.clone();
        }

        @Override
        public Context conclude() {
            super.conclude();
            if (null == this.clientLock) {
                this.clientLock = new ReentrantLock();
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new SleepingMillisIdleStrategy(16L);
            }
            if (null == this.awaitingIdleStrategy) {
                this.awaitingIdleStrategy = new SleepingMillisIdleStrategy(1L);
            }
            if (this.cncFile() != null) {
                this.connectToDriver();
            }
            this.interServiceTimeoutNs = CncFileDescriptor.clientLivenessTimeoutNs((DirectBuffer)this.cncMetaDataBuffer);
            if (this.interServiceTimeoutNs <= this.keepAliveIntervalNs) {
                throw new ConfigurationException("interServiceTimeoutNs=" + this.interServiceTimeoutNs + " <= keepAliveIntervalNs=" + this.keepAliveIntervalNs);
            }
            if (null == this.toDriverBuffer) {
                this.toDriverBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (null == this.toClientBuffer) {
                this.toClientBuffer = new CopyBroadcastReceiver(new BroadcastReceiver((AtomicBuffer)CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer)));
            }
            if (this.countersMetaDataBuffer() == null) {
                this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (this.countersValuesBuffer() == null) {
                this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
            }
            if (null == this.logBuffersFactory) {
                this.logBuffersFactory = new MappedLogBuffersFactory();
            }
            if (null == this.errorHandler) {
                this.errorHandler = Configuration.DEFAULT_ERROR_HANDLER;
            }
            if (null == this.subscriberErrorHandler) {
                this.subscriberErrorHandler = this.errorHandler;
            }
            if (null == this.driverProxy) {
                this.clientId = this.toDriverBuffer.nextCorrelationId();
                this.driverProxy = new DriverProxy(this.toDriverBuffer, this.clientId);
            }
            return this;
        }

        public long clientId() {
            return this.clientId;
        }

        public Context useConductorAgentInvoker(boolean useConductorAgentInvoker) {
            this.useConductorAgentInvoker = useConductorAgentInvoker;
            return this;
        }

        public boolean useConductorAgentInvoker() {
            return this.useConductorAgentInvoker;
        }

        public Context preTouchMappedMemory(boolean preTouchMappedMemory) {
            this.preTouchMappedMemory = preTouchMappedMemory;
            return this;
        }

        public boolean preTouchMappedMemory() {
            return this.preTouchMappedMemory;
        }

        public Context driverAgentInvoker(AgentInvoker driverAgentInvoker) {
            this.driverAgentInvoker = driverAgentInvoker;
            return this;
        }

        public AgentInvoker driverAgentInvoker() {
            return this.driverAgentInvoker;
        }

        public Context clientLock(Lock lock) {
            this.clientLock = lock;
            return this;
        }

        public Lock clientLock() {
            return this.clientLock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context awaitingIdleStrategy(IdleStrategy idleStrategy) {
            this.awaitingIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy awaitingIdleStrategy() {
            return this.awaitingIdleStrategy;
        }

        Context toClientBuffer(CopyBroadcastReceiver toClientBuffer) {
            this.toClientBuffer = toClientBuffer;
            return this;
        }

        public CopyBroadcastReceiver toClientBuffer() {
            return this.toClientBuffer;
        }

        public RingBuffer toDriverBuffer() {
            return this.toDriverBuffer;
        }

        Context driverProxy(DriverProxy driverProxy) {
            this.driverProxy = driverProxy;
            return this;
        }

        public DriverProxy driverProxy() {
            return this.driverProxy;
        }

        Context logBuffersFactory(LogBuffersFactory logBuffersFactory) {
            this.logBuffersFactory = logBuffersFactory;
            return this;
        }

        public LogBuffersFactory logBuffersFactory() {
            return this.logBuffersFactory;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context subscriberErrorHandler(ErrorHandler errorHandler) {
            this.subscriberErrorHandler = errorHandler;
            return this;
        }

        public ErrorHandler subscriberErrorHandler() {
            return this.subscriberErrorHandler;
        }

        public Context availableImageHandler(AvailableImageHandler handler) {
            this.availableImageHandler = handler;
            return this;
        }

        public AvailableImageHandler availableImageHandler() {
            return this.availableImageHandler;
        }

        public Context unavailableImageHandler(UnavailableImageHandler handler) {
            this.unavailableImageHandler = handler;
            return this;
        }

        public UnavailableImageHandler unavailableImageHandler() {
            return this.unavailableImageHandler;
        }

        public Context availableCounterHandler(AvailableCounterHandler handler) {
            this.availableCounterHandler = handler;
            return this;
        }

        public AvailableCounterHandler availableCounterHandler() {
            return this.availableCounterHandler;
        }

        public Context unavailableCounterHandler(UnavailableCounterHandler handler) {
            this.unavailableCounterHandler = handler;
            return this;
        }

        public UnavailableCounterHandler unavailableCounterHandler() {
            return this.unavailableCounterHandler;
        }

        public Context closeHandler(Runnable handler) {
            this.closeHandler = handler;
            return this;
        }

        public Runnable closeHandler() {
            return this.closeHandler;
        }

        public Context keepAliveIntervalNs(long value) {
            this.keepAliveIntervalNs = value;
            return this;
        }

        public long keepAliveIntervalNs() {
            return this.keepAliveIntervalNs;
        }

        @Override
        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        Context interServiceTimeoutNs(long interServiceTimeout) {
            this.interServiceTimeoutNs = interServiceTimeout;
            return this;
        }

        public long interServiceTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.interServiceTimeoutNs, TimeUnit.NANOSECONDS);
        }

        public Context resourceLingerDurationNs(long resourceLingerDurationNs) {
            this.resourceLingerDurationNs = resourceLingerDurationNs;
            return this;
        }

        public long resourceLingerDurationNs() {
            return this.resourceLingerDurationNs;
        }

        public Context closeLingerDurationNs(long closeLingerDurationNs) {
            this.closeLingerDurationNs = closeLingerDurationNs;
            return this;
        }

        public long closeLingerDurationNs() {
            return this.closeLingerDurationNs;
        }

        @Override
        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        @Override
        public void close() {
            IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
            this.cncByteBuffer = null;
            super.close();
        }

        private void connectToDriver() {
            long deadlineMs = this.epochClock.time() + this.driverTimeoutMs();
            File cncFile = this.cncFile();
            while (null == this.toDriverBuffer) {
                int cncVersion;
                while (!cncFile.exists() || cncFile.length() <= 0L) {
                    if (this.epochClock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file not created: " + cncFile.getAbsolutePath());
                    }
                    Aeron.sleep(16L);
                }
                this.cncByteBuffer = Aeron.waitForFileMapping(cncFile, this.epochClock, deadlineMs);
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
                while (0 == (cncVersion = this.cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
                    if (this.epochClock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file is created but not initialised");
                    }
                    Aeron.sleep(1L);
                }
                CncFileDescriptor.checkVersion(cncVersion);
                if (SemanticVersion.minor((int)cncVersion) < SemanticVersion.minor((int)CncFileDescriptor.CNC_VERSION)) {
                    throw new AeronException("driverVersion=" + SemanticVersion.toString((int)cncVersion) + " insufficient for clientVersion=" + SemanticVersion.toString((int)CncFileDescriptor.CNC_VERSION));
                }
                if (!CncFileDescriptor.isCncFileLengthSufficient((DirectBuffer)this.cncMetaDataBuffer, this.cncByteBuffer.capacity())) {
                    IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Aeron.sleep(1L);
                    continue;
                }
                ManyToOneRingBuffer ringBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                while (0L == ringBuffer.consumerHeartbeatTime()) {
                    if (this.epochClock.time() > deadlineMs) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    Aeron.sleep(1L);
                }
                long timeMs = this.epochClock.time();
                if (ringBuffer.consumerHeartbeatTime() < timeMs - this.driverTimeoutMs()) {
                    if (timeMs > deadlineMs) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Aeron.sleep(100L);
                    continue;
                }
                this.toDriverBuffer = ringBuffer;
            }
        }
    }

    public static class Configuration {
        static final long IDLE_SLEEP_MS = 16L;
        static final long AWAITING_IDLE_SLEEP_MS = 1L;
        static final long IDLE_SLEEP_NS = TimeUnit.MILLISECONDS.toNanos(16L);
        static final long KEEPALIVE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        public static final String RESOURCE_LINGER_DURATION_PROP_NAME = "aeron.client.resource.linger.duration";
        public static final long RESOURCE_LINGER_DURATION_DEFAULT_NS = TimeUnit.SECONDS.toNanos(3L);
        public static final String CLOSE_LINGER_DURATION_PROP_NAME = "aeron.client.close.linger.duration";
        public static final long CLOSE_LINGER_DURATION_DEFAULT_NS = 0L;
        public static final String PRE_TOUCH_MAPPED_MEMORY_PROP_NAME = "aeron.pre.touch.mapped.memory";
        public static final boolean PRE_TOUCH_MAPPED_MEMORY_DEFAULT = false;
        public static final ErrorHandler DEFAULT_ERROR_HANDLER = throwable -> {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(System.currentTimeMillis() + " Exception:");
                throwable.printStackTrace(System.err);
            }
            if (throwable instanceof DriverTimeoutException) {
                System.err.printf("%n***%n*** timeout for the Media Driver - is it currently running? exiting%n***%n", new Object[0]);
                System.exit(-1);
            }
        };

        public static long resourceLingerDurationNs() {
            return SystemUtil.getDurationInNanos((String)RESOURCE_LINGER_DURATION_PROP_NAME, (long)RESOURCE_LINGER_DURATION_DEFAULT_NS);
        }

        public static long closeLingerDurationNs() {
            return SystemUtil.getDurationInNanos((String)CLOSE_LINGER_DURATION_PROP_NAME, (long)0L);
        }

        public static boolean preTouchMappedMemory() {
            String value = System.getProperty(PRE_TOUCH_MAPPED_MEMORY_PROP_NAME);
            if (null != value) {
                return Boolean.parseBoolean(value);
            }
            return false;
        }
    }
}

