/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.LogBuffers;
import io.aeron.Publication;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermAppender;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public final class ConcurrentPublication
extends Publication {
    private final TermAppender[] termAppenders = new TermAppender[3];

    ConcurrentPublication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, int channelStatusId, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        super(clientConductor, channel, streamId, sessionId, positionLimit, channelStatusId, logBuffers, originalRegistrationId, registrationId);
        UnsafeBuffer[] buffers = logBuffers.duplicateTermBuffers();
        for (int i = 0; i < 3; ++i) {
            this.termAppenders[i] = new TermAppender(buffers[i], this.logMetaDataBuffer, i);
        }
    }

    @Override
    public long availableWindow() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile() - this.position();
    }

    @Override
    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[LogBufferDescriptor.indexByTermCount(termCount)];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            int termId = LogBufferDescriptor.termId(rawTail);
            long position = LogBufferDescriptor.computeTermBeginPosition(termId, this.positionBitsToShift, this.initialTermId) + termOffset;
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            if (position < limit) {
                int resultingOffset;
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    resultingOffset = termAppender.appendUnfragmentedMessage(this.headerWriter, buffer, offset, length, reservedValueSupplier, termId);
                } else {
                    this.checkMaxMessageLength(length);
                    resultingOffset = termAppender.appendFragmentedMessage(this.headerWriter, buffer, offset, length, this.maxPayloadLength, reservedValueSupplier, termId);
                }
                newPosition = this.newPosition(termCount, (int)termOffset, termId, position, resultingOffset);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[LogBufferDescriptor.indexByTermCount(termCount)];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            int termId = LogBufferDescriptor.termId(rawTail);
            long position = LogBufferDescriptor.computeTermBeginPosition(termId, this.positionBitsToShift, this.initialTermId) + termOffset;
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            int length = ConcurrentPublication.validateAndComputeLength(lengthOne, lengthTwo);
            if (position < limit) {
                int resultingOffset;
                if (length <= this.maxPayloadLength) {
                    resultingOffset = termAppender.appendUnfragmentedMessage(this.headerWriter, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, reservedValueSupplier, termId);
                } else {
                    this.checkMaxMessageLength(length);
                    resultingOffset = termAppender.appendFragmentedMessage(this.headerWriter, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, this.maxPayloadLength, reservedValueSupplier, termId);
                }
                newPosition = this.newPosition(termCount, (int)termOffset, termId, position, resultingOffset);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBufferVector[] vectors, ReservedValueSupplier reservedValueSupplier) {
        int length = DirectBufferVector.validateAndComputeLength(vectors);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[LogBufferDescriptor.indexByTermCount(termCount)];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            int termId = LogBufferDescriptor.termId(rawTail);
            long position = LogBufferDescriptor.computeTermBeginPosition(termId, this.positionBitsToShift, this.initialTermId) + termOffset;
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            if (position < limit) {
                int resultingOffset;
                if (length <= this.maxPayloadLength) {
                    resultingOffset = termAppender.appendUnfragmentedMessage(this.headerWriter, vectors, length, reservedValueSupplier, termId);
                } else {
                    this.checkMaxMessageLength(length);
                    resultingOffset = termAppender.appendFragmentedMessage(this.headerWriter, vectors, length, this.maxPayloadLength, reservedValueSupplier, termId);
                }
                newPosition = this.newPosition(termCount, (int)termOffset, termId, position, resultingOffset);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long tryClaim(int length, BufferClaim bufferClaim) {
        this.checkPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[LogBufferDescriptor.indexByTermCount(termCount)];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            int termId = LogBufferDescriptor.termId(rawTail);
            long position = LogBufferDescriptor.computeTermBeginPosition(termId, this.positionBitsToShift, this.initialTermId) + termOffset;
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            if (position < limit) {
                int resultingOffset = termAppender.claim(this.headerWriter, length, bufferClaim, termId);
                newPosition = this.newPosition(termCount, (int)termOffset, termId, position, resultingOffset);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    private long newPosition(int termCount, int termOffset, int termId, long position, int resultingOffset) {
        if (resultingOffset > 0) {
            return position - (long)termOffset + (long)resultingOffset;
        }
        if (position + (long)termOffset > this.maxPossiblePosition) {
            return -5L;
        }
        LogBufferDescriptor.rotateLog(this.logMetaDataBuffer, termCount, termId);
        return -3L;
    }
}

