/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.exceptions.AeronException;
import java.nio.ByteBuffer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.concurrent.UnsafeBuffer;

public class CncFileDescriptor {
    public static final String CNC_FILE = "cnc.dat";
    public static final int CNC_VERSION = SemanticVersion.compose((int)0, (int)2, (int)0);
    public static final int CNC_VERSION_FIELD_OFFSET = 0;
    public static final int TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET = CNC_VERSION_FIELD_OFFSET + 4;
    public static final int TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET = TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET = TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET = COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET + 4;
    public static final int CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET;
    public static final int ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET;
    public static final int START_TIMESTAMP_FIELD_OFFSET;
    public static final int PID_FIELD_OFFSET;
    public static final int META_DATA_LENGTH;
    public static final int END_OF_METADATA_OFFSET;

    public static int computeCncFileLength(int totalLengthOfBuffers, int alignment) {
        return BitUtil.align((int)(END_OF_METADATA_OFFSET + totalLengthOfBuffers), (int)alignment);
    }

    public static int cncVersionOffset(int baseOffset) {
        return baseOffset + CNC_VERSION_FIELD_OFFSET;
    }

    public static int toDriverBufferLengthOffset(int baseOffset) {
        return baseOffset + TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int toClientsBufferLengthOffset(int baseOffset) {
        return baseOffset + TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int countersMetaDataBufferLengthOffset(int baseOffset) {
        return baseOffset + COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int countersValuesBufferLengthOffset(int baseOffset) {
        return baseOffset + COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int clientLivenessTimeoutOffset(int baseOffset) {
        return baseOffset + CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET;
    }

    public static int errorLogBufferLengthOffset(int baseOffset) {
        return baseOffset + ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET;
    }

    public static int startTimestampOffset(int baseOffset) {
        return baseOffset + START_TIMESTAMP_FIELD_OFFSET;
    }

    public static int pidOffset(int baseOffset) {
        return baseOffset + PID_FIELD_OFFSET;
    }

    public static void fillMetaData(UnsafeBuffer cncMetaDataBuffer, int toDriverBufferLength, int toClientsBufferLength, int counterMetaDataBufferLength, int counterValuesBufferLength, long clientLivenessTimeoutNs, int errorLogBufferLength, long startTimestampMs, long pid) {
        cncMetaDataBuffer.putInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET, toDriverBufferLength);
        cncMetaDataBuffer.putInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET, toClientsBufferLength);
        cncMetaDataBuffer.putInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET, counterMetaDataBufferLength);
        cncMetaDataBuffer.putInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET, counterValuesBufferLength);
        cncMetaDataBuffer.putInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET, errorLogBufferLength);
        cncMetaDataBuffer.putLong(CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET, clientLivenessTimeoutNs);
        cncMetaDataBuffer.putLong(START_TIMESTAMP_FIELD_OFFSET, startTimestampMs);
        cncMetaDataBuffer.putLong(PID_FIELD_OFFSET, pid);
    }

    public static void signalCncReady(UnsafeBuffer cncMetaDataBuffer) {
        cncMetaDataBuffer.putIntVolatile(CncFileDescriptor.cncVersionOffset(0), CNC_VERSION);
    }

    public static UnsafeBuffer createMetaDataBuffer(ByteBuffer buffer) {
        return new UnsafeBuffer(buffer, 0, META_DATA_LENGTH);
    }

    public static UnsafeBuffer createToDriverBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        return new UnsafeBuffer(buffer, END_OF_METADATA_OFFSET, metaDataBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createToClientsBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = END_OF_METADATA_OFFSET + metaDataBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0));
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createCountersMetaDataBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = END_OF_METADATA_OFFSET + metaDataBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)) + metaDataBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0));
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(CncFileDescriptor.countersMetaDataBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createCountersValuesBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = END_OF_METADATA_OFFSET + metaDataBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)) + metaDataBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0)) + metaDataBuffer.getInt(CncFileDescriptor.countersMetaDataBufferLengthOffset(0));
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(CncFileDescriptor.countersValuesBufferLengthOffset(0)));
    }

    public static UnsafeBuffer createErrorLogBuffer(ByteBuffer buffer, DirectBuffer metaDataBuffer) {
        int offset = END_OF_METADATA_OFFSET + metaDataBuffer.getInt(CncFileDescriptor.toDriverBufferLengthOffset(0)) + metaDataBuffer.getInt(CncFileDescriptor.toClientsBufferLengthOffset(0)) + metaDataBuffer.getInt(CncFileDescriptor.countersMetaDataBufferLengthOffset(0)) + metaDataBuffer.getInt(CncFileDescriptor.countersValuesBufferLengthOffset(0));
        return new UnsafeBuffer(buffer, offset, metaDataBuffer.getInt(CncFileDescriptor.errorLogBufferLengthOffset(0)));
    }

    public static long clientLivenessTimeoutNs(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getLong(CncFileDescriptor.clientLivenessTimeoutOffset(0));
    }

    public static long startTimestampMs(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getLong(CncFileDescriptor.startTimestampOffset(0));
    }

    public static long pid(DirectBuffer metaDataBuffer) {
        return metaDataBuffer.getLong(CncFileDescriptor.pidOffset(0));
    }

    public static void checkVersion(int cncVersion) {
        if (SemanticVersion.major((int)CNC_VERSION) != SemanticVersion.major((int)cncVersion)) {
            throw new AeronException("CnC version not compatible: app=" + SemanticVersion.toString((int)CNC_VERSION) + " file=" + SemanticVersion.toString((int)cncVersion));
        }
    }

    public static boolean isCncFileLengthSufficient(DirectBuffer metaDataBuffer, int cncFileLength) {
        int metadataRequiredLength = END_OF_METADATA_OFFSET + metaDataBuffer.getInt(TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(TO_CLIENTS_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_METADATA_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET) + metaDataBuffer.getInt(ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET);
        return cncFileLength >= metadataRequiredLength;
    }

    static {
        ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET = COUNTERS_VALUES_BUFFER_LENGTH_FIELD_OFFSET + 4;
        CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET = ERROR_LOG_BUFFER_LENGTH_FIELD_OFFSET + 4;
        START_TIMESTAMP_FIELD_OFFSET = CLIENT_LIVENESS_TIMEOUT_FIELD_OFFSET + 8;
        PID_FIELD_OFFSET = START_TIMESTAMP_FIELD_OFFSET + 8;
        META_DATA_LENGTH = PID_FIELD_OFFSET + 8;
        END_OF_METADATA_OFFSET = BitUtil.align((int)META_DATA_LENGTH, (int)128);
    }
}

