/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.exceptions.ConfigurationException;
import org.agrona.concurrent.status.CountersReader;

public final class AeronCounters {
    public static final int DRIVER_SYSTEM_COUNTER_TYPE_ID = 0;
    public static final int DRIVER_PUBLISHER_LIMIT_TYPE_ID = 1;
    public static final int DRIVER_SENDER_POSITION_TYPE_ID = 2;
    public static final int DRIVER_RECEIVER_HWM_TYPE_ID = 3;
    public static final int DRIVER_SUBSCRIBER_POSITION_TYPE_ID = 4;
    public static final int DRIVER_RECEIVER_POS_TYPE_ID = 5;
    public static final int DRIVER_SEND_CHANNEL_STATUS_TYPE_ID = 6;
    public static final int DRIVER_RECEIVE_CHANNEL_STATUS_TYPE_ID = 7;
    public static final int DRIVER_SENDER_LIMIT_TYPE_ID = 9;
    public static final int DRIVER_PER_IMAGE_TYPE_ID = 10;
    public static final int DRIVER_HEARTBEAT_TYPE_ID = 11;
    public static final int DRIVER_PUBLISHER_POS_TYPE_ID = 12;
    public static final int DRIVER_SENDER_BPE_TYPE_ID = 13;
    public static final int NAME_RESOLVER_NEIGHBORS_COUNTER_TYPE_ID = 15;
    public static final int NAME_RESOLVER_CACHE_ENTRIES_COUNTER_TYPE_ID = 16;
    public static final int DRIVER_LOCAL_SOCKET_ADDRESS_STATUS_TYPE_ID = 14;
    public static final int FLOW_CONTROL_RECEIVERS_COUNTER_TYPE_ID = 17;
    public static final int MDC_DESTINATIONS_COUNTER_TYPE_ID = 18;
    public static final int ARCHIVE_RECORDING_POSITION_TYPE_ID = 100;
    public static final int ARCHIVE_ERROR_COUNT_TYPE_ID = 101;
    public static final int ARCHIVE_CONTROL_SESSIONS_TYPE_ID = 102;
    public static final int ARCHIVE_MAX_CYCLE_TIME_TYPE_ID = 103;
    public static final int ARCHIVE_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 104;
    public static final int CLUSTER_CONSENSUS_MODULE_STATE_TYPE_ID = 200;
    public static final int CLUSTER_NODE_ROLE_TYPE_ID = 201;
    public static final int CLUSTER_CONTROL_TOGGLE_TYPE_ID = 202;
    public static final int CLUSTER_COMMIT_POSITION_TYPE_ID = 203;
    public static final int CLUSTER_RECOVERY_STATE_TYPE_ID = 204;
    public static final int CLUSTER_SNAPSHOT_COUNTER_TYPE_ID = 205;
    public static final int CLUSTER_ELECTION_STATE_TYPE_ID = 207;
    public static final int CLUSTER_BACKUP_STATE_TYPE_ID = 208;
    public static final int CLUSTER_BACKUP_LIVE_LOG_POSITION_TYPE_ID = 209;
    public static final int CLUSTER_BACKUP_QUERY_DEADLINE_TYPE_ID = 210;
    public static final int CLUSTER_BACKUP_ERROR_COUNT_TYPE_ID = 211;
    public static final int CLUSTER_CONSENSUS_MODULE_ERROR_COUNT_TYPE_ID = 212;
    public static final int CLUSTER_CLIENT_TIMEOUT_COUNT_TYPE_ID = 213;
    public static final int CLUSTER_INVALID_REQUEST_COUNT_TYPE_ID = 214;
    public static final int CLUSTER_CLUSTERED_SERVICE_ERROR_COUNT_TYPE_ID = 215;
    public static final int CLUSTER_MAX_CYCLE_TIME_TYPE_ID = 216;
    public static final int CLUSTER_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 217;
    public static final int CLUSTER_CLUSTERED_SERVICE_MAX_CYCLE_TIME_TYPE_ID = 218;
    public static final int CLUSTER_CLUSTERED_SERVICE_CYCLE_TIME_THRESHOLD_EXCEEDED_TYPE_ID = 219;
    public static final int CLUSTER_STANDBY_STATE_TYPE_ID = 220;
    public static final int CLUSTER_STANDBY_ERROR_COUNT_TYPE_ID = 221;
    public static final int CLUSTER_STANDBY_HEARTBEAT_RESPONSE_COUNT_TYPE_ID = 222;

    private AeronCounters() {
    }

    public static void validateCounterTypeId(CountersReader countersReader, int counterId, int expectedCounterTypeId) {
        int counterTypeId = countersReader.getCounterTypeId(counterId);
        if (expectedCounterTypeId != counterTypeId) {
            throw new ConfigurationException("The type for counterId=" + counterId + ", typeId=" + counterTypeId + " does not match the expected=" + expectedCounterTypeId);
        }
    }

    public static void validateCounterTypeId(Aeron aeron, Counter counter, int expectedCounterTypeId) {
        AeronCounters.validateCounterTypeId(aeron.countersReader(), counter.id(), expectedCounterTypeId);
    }
}

