/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class FragmentAssembler
implements FragmentHandler {
    private final boolean isDirectByteBuffer;
    private final int initialBufferLength;
    private final FragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();

    public FragmentAssembler(FragmentHandler delegate) {
        this(delegate, 0, false);
    }

    public FragmentAssembler(FragmentHandler delegate, int initialBufferLength) {
        this(delegate, initialBufferLength, false);
    }

    public FragmentAssembler(FragmentHandler delegate, int initialBufferLength, boolean isDirectByteBuffer) {
        this.initialBufferLength = initialBufferLength;
        this.delegate = delegate;
        this.isDirectByteBuffer = isDirectByteBuffer;
    }

    public FragmentHandler delegate() {
        return this.delegate;
    }

    public boolean isDirectByteBuffer() {
        return this.isDirectByteBuffer;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            this.delegate.onFragment(buffer, offset, length, header);
        } else {
            this.handleFragment(buffer, offset, length, header, flags);
        }
    }

    private void handleFragment(DirectBuffer buffer, int offset, int length, Header header, byte flags) {
        if ((flags & 0xFFFFFF80) == -128) {
            BufferBuilder builder = this.getBufferBuilder(header.sessionId());
            builder.reset().append(buffer, offset, length).nextTermOffset(BitUtil.align((int)(offset + length + 32), (int)32));
        } else {
            BufferBuilder builder = (BufferBuilder)this.builderBySessionIdMap.get(header.sessionId());
            if (null != builder) {
                if (offset == builder.nextTermOffset()) {
                    builder.append(buffer, offset, length);
                    if ((flags & 0x40) == 64) {
                        this.delegate.onFragment((DirectBuffer)builder.buffer(), 0, builder.limit(), header);
                        builder.reset();
                    } else {
                        builder.nextTermOffset(BitUtil.align((int)(offset + length + 32), (int)32));
                    }
                } else {
                    builder.reset();
                }
            }
        }
    }

    public boolean freeSessionBuffer(int sessionId) {
        return null != this.builderBySessionIdMap.remove(sessionId);
    }

    public void clear() {
        this.builderBySessionIdMap.clear();
    }

    private BufferBuilder getBufferBuilder(int sessionId) {
        BufferBuilder bufferBuilder = (BufferBuilder)this.builderBySessionIdMap.get(sessionId);
        if (null == bufferBuilder) {
            bufferBuilder = new BufferBuilder(this.initialBufferLength, this.isDirectByteBuffer);
            this.builderBySessionIdMap.put(sessionId, (Object)bufferBuilder);
        }
        return bufferBuilder;
    }
}

