/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.HeaderWriter;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

class NativeBigEndianHeaderWriter
extends HeaderWriter {
    NativeBigEndianHeaderWriter(UnsafeBuffer defaultHeader) {
        super((long)defaultHeader.getInt(4) & 0xFFFFFFFFL, (long)defaultHeader.getInt(12) & 0xFFFFFFFFL, (long)defaultHeader.getInt(16) << 32);
    }

    @Override
    public void write(UnsafeBuffer termBuffer, int offset, int length, int termId) {
        termBuffer.putLongOrdered(offset + 0, (long)Integer.reverseBytes(-length) << 32 | this.versionFlagsType);
        UnsafeAccess.UNSAFE.storeFence();
        termBuffer.putLong(offset + 8, (long)Integer.reverseBytes(offset) << 32 | this.sessionId);
        termBuffer.putLong(offset + 16, this.streamId | (long)Integer.reverseBytes(termId) & 0xFFFFFFFFL);
    }
}

