/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.exceptions.AeronException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public final class Counter
extends AtomicCounter {
    private static final VarHandle IS_CLOSED_VH;
    private volatile boolean isClosed;
    private final long registrationId;
    private final ClientConductor clientConductor;

    Counter(long registrationId, ClientConductor clientConductor, AtomicBuffer buffer, int counterId) {
        super(buffer, counterId);
        this.registrationId = registrationId;
        this.clientConductor = clientConductor;
    }

    public Counter(CountersReader countersReader, long registrationId, int counterId) {
        super(countersReader.valuesBuffer(), counterId);
        if (countersReader.getCounterState(counterId) != 1) {
            throw new AeronException("Counter id is not allocated: " + counterId);
        }
        this.registrationId = registrationId;
        this.clientConductor = null;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public void close() {
        if (IS_CLOSED_VH.compareAndSet(this, false, true)) {
            super.close();
            if (null != this.clientConductor) {
                this.clientConductor.releaseCounter(this);
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void internalClose() {
        super.close();
        this.isClosed = true;
    }

    static {
        try {
            IS_CLOSED_VH = MethodHandles.lookup().findVarHandle(Counter.class, "isClosed", Boolean.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

