/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class ImageControlledFragmentAssembler
implements ControlledFragmentHandler {
    private final ControlledFragmentHandler delegate;
    private final BufferBuilder builder;

    public ImageControlledFragmentAssembler(ControlledFragmentHandler delegate) {
        this(delegate, 0, false);
    }

    public ImageControlledFragmentAssembler(ControlledFragmentHandler delegate, int initialBufferLength) {
        this(delegate, initialBufferLength, false);
    }

    public ImageControlledFragmentAssembler(ControlledFragmentHandler delegate, int initialBufferLength, boolean isDirectByteBuffer) {
        this.delegate = delegate;
        this.builder = new BufferBuilder(initialBufferLength, isDirectByteBuffer);
    }

    public ControlledFragmentHandler delegate() {
        return this.delegate;
    }

    BufferBuilder bufferBuilder() {
        return this.builder;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.delegate.onFragment(buffer, offset, length, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            this.builder.reset().captureHeader(header).append(buffer, offset, length).nextTermOffset(header.nextTermOffset());
        } else if (header.termOffset() == this.builder.nextTermOffset()) {
            int limit = this.builder.limit();
            this.builder.append(buffer, offset, length);
            if ((flags & 0x40) == 64) {
                action = this.delegate.onFragment((DirectBuffer)this.builder.buffer(), 0, this.builder.limit(), this.builder.completeHeader(header));
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    this.builder.limit(limit);
                } else {
                    this.builder.reset();
                }
            } else {
                this.builder.nextTermOffset(header.nextTermOffset());
            }
        } else {
            this.builder.reset();
        }
        return action;
    }
}

