/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ChannelUri;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;

public final class ChannelUriStringBuilder {
    public static final String TAG_PREFIX = "tag:";
    private final StringBuilder sb = new StringBuilder(64);
    private String prefix;
    private String media;
    private String endpoint;
    private String networkInterface;
    private String controlEndpoint;
    private String controlMode;
    private String tags;
    private String alias;
    private String cc;
    private String fc;
    private String mediaReceiveTimestampOffset;
    private String channelReceiveTimestampOffset;
    private String channelSendTimestampOffset;
    private String responseEndpoint;
    private Boolean reliable;
    private Boolean sparse;
    private Boolean eos;
    private Boolean tether;
    private Boolean group;
    private Boolean rejoin;
    private Boolean ssc;
    private Integer ttl;
    private Integer mtu;
    private Integer termLength;
    private Integer initialTermId;
    private Integer termId;
    private Integer termOffset;
    private Integer socketSndbufLength;
    private Integer socketRcvbufLength;
    private Integer receiverWindowLength;
    private Integer maxResend;
    private Integer streamId;
    private Integer publicationWindowLength;
    private Long sessionId;
    private Long groupTag;
    private Long linger;
    private Long responseCorrelationId;
    private Long nakDelay;
    private Long untetheredWindowLimitTimeoutNs;
    private Long untetheredLingerTimeoutNs;
    private Long untetheredRestingTimeoutNs;
    private boolean isSessionIdTagged;

    public ChannelUriStringBuilder() {
    }

    public ChannelUriStringBuilder(String initialUri) {
        this(ChannelUri.parse(initialUri));
    }

    public ChannelUriStringBuilder(ChannelUri channelUri) {
        this.isSessionIdTagged = false;
        this.prefix(channelUri);
        this.media(channelUri);
        this.endpoint(channelUri);
        this.networkInterface(channelUri);
        this.controlEndpoint(channelUri);
        this.controlMode(channelUri);
        this.tags(channelUri);
        this.alias(channelUri);
        this.congestionControl(channelUri);
        this.flowControl(channelUri);
        this.reliable(channelUri);
        this.ttl(channelUri);
        this.mtu(channelUri);
        this.termLength(channelUri);
        this.initialTermId(channelUri);
        this.termId(channelUri);
        this.termOffset(channelUri);
        this.sessionId(channelUri);
        this.group(channelUri);
        this.linger(channelUri);
        this.sparse(channelUri);
        this.eos(channelUri);
        this.tether(channelUri);
        this.groupTag(channelUri);
        this.rejoin(channelUri);
        this.spiesSimulateConnection(channelUri);
        this.socketRcvbufLength(channelUri);
        this.socketSndbufLength(channelUri);
        this.receiverWindowLength(channelUri);
        this.mediaReceiveTimestampOffset(channelUri);
        this.channelReceiveTimestampOffset(channelUri);
        this.channelSendTimestampOffset(channelUri);
        this.responseEndpoint(channelUri);
        this.responseCorrelationId(channelUri);
        this.nakDelay(channelUri);
        this.untetheredWindowLimitTimeout(channelUri);
        this.untetheredLingerTimeout(channelUri);
        this.untetheredRestingTimeout(channelUri);
        this.maxResend(channelUri);
        this.streamId(channelUri);
        this.publicationWindowLength(channelUri);
    }

    public ChannelUriStringBuilder clear() {
        this.prefix = null;
        this.media = null;
        this.endpoint = null;
        this.networkInterface = null;
        this.controlEndpoint = null;
        this.controlMode = null;
        this.tags = null;
        this.alias = null;
        this.cc = null;
        this.fc = null;
        this.reliable = null;
        this.ttl = null;
        this.mtu = null;
        this.termLength = null;
        this.initialTermId = null;
        this.termId = null;
        this.termOffset = null;
        this.sessionId = null;
        this.groupTag = null;
        this.linger = null;
        this.sparse = null;
        this.eos = null;
        this.tether = null;
        this.group = null;
        this.rejoin = null;
        this.isSessionIdTagged = false;
        this.socketRcvbufLength = null;
        this.socketSndbufLength = null;
        this.receiverWindowLength = null;
        this.mediaReceiveTimestampOffset = null;
        this.channelReceiveTimestampOffset = null;
        this.channelSendTimestampOffset = null;
        this.responseEndpoint = null;
        this.responseCorrelationId = null;
        this.maxResend = null;
        this.streamId = null;
        this.publicationWindowLength = null;
        return this;
    }

    public ChannelUriStringBuilder validate() {
        boolean anyNull;
        if (null == this.media) {
            throw new IllegalArgumentException("media type is mandatory");
        }
        if ("udp".equals(this.media) && null == this.endpoint && null == this.controlEndpoint) {
            throw new IllegalArgumentException("either 'endpoint' or 'control' must be specified for UDP.");
        }
        boolean anyNonNull = null != this.initialTermId || null != this.termId || null != this.termOffset;
        boolean bl = anyNull = null == this.initialTermId || null == this.termId || null == this.termOffset;
        if (anyNonNull) {
            if (anyNull) {
                throw new IllegalArgumentException("either all or none of the parameters ['initialTermId', 'termId', 'termOffset'] must be provided");
            }
            if (this.termId - this.initialTermId < 0) {
                throw new IllegalArgumentException("difference greater than 2^31 - 1: termId=" + this.termId + " - initialTermId=" + this.initialTermId);
            }
            if (null != this.termLength && this.termOffset > this.termLength) {
                throw new IllegalArgumentException("termOffset=" + this.termOffset + " > termLength=" + this.termLength);
            }
        }
        return this;
    }

    public ChannelUriStringBuilder prefix(String prefix) {
        if (null != prefix && !prefix.isEmpty() && !prefix.equals("aeron-spy")) {
            throw new IllegalArgumentException("invalid prefix: " + prefix);
        }
        this.prefix = prefix;
        return this;
    }

    public ChannelUriStringBuilder prefix(ChannelUri channelUri) {
        return this.prefix(channelUri.prefix());
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUriStringBuilder media(String media) {
        switch (media) {
            case "udp": 
            case "ipc": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid media: " + media);
            }
        }
        this.media = media;
        return this;
    }

    public ChannelUriStringBuilder media(ChannelUri channelUri) {
        return this.media(channelUri.media());
    }

    public String media() {
        return this.media;
    }

    public ChannelUriStringBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ChannelUriStringBuilder endpoint(ChannelUri channelUri) {
        return this.endpoint(channelUri.get("endpoint"));
    }

    public String endpoint() {
        return this.endpoint;
    }

    public ChannelUriStringBuilder networkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    public ChannelUriStringBuilder networkInterface(ChannelUri channelUri) {
        return this.networkInterface(channelUri.get("interface"));
    }

    public String networkInterface() {
        return this.networkInterface;
    }

    public ChannelUriStringBuilder controlEndpoint(String controlEndpoint) {
        this.controlEndpoint = controlEndpoint;
        return this;
    }

    public ChannelUriStringBuilder controlEndpoint(ChannelUri channelUri) {
        return this.controlEndpoint(channelUri.get("control"));
    }

    public String controlEndpoint() {
        return this.controlEndpoint;
    }

    public ChannelUriStringBuilder controlMode(String controlMode) {
        if (!(null == controlMode || controlMode.equals("manual") || controlMode.equals("dynamic") || controlMode.equals("response"))) {
            throw new IllegalArgumentException("invalid control mode: " + controlMode);
        }
        this.controlMode = controlMode;
        return this;
    }

    public ChannelUriStringBuilder controlMode(ChannelUri channelUri) {
        return this.controlMode(channelUri.get("control-mode"));
    }

    public String controlMode() {
        return this.controlMode;
    }

    public ChannelUriStringBuilder reliable(Boolean isReliable) {
        this.reliable = isReliable;
        return this;
    }

    public ChannelUriStringBuilder reliable(ChannelUri channelUri) {
        String reliableValue = channelUri.get("reliable");
        if (null == reliableValue) {
            this.reliable = null;
            return this;
        }
        return this.reliable(Boolean.valueOf(reliableValue));
    }

    public Boolean reliable() {
        return this.reliable;
    }

    public ChannelUriStringBuilder ttl(Integer ttl) {
        if (null != ttl && (ttl < 0 || ttl > 255)) {
            throw new IllegalArgumentException("TTL not in range 0-255: " + ttl);
        }
        this.ttl = ttl;
        return this;
    }

    public ChannelUriStringBuilder ttl(ChannelUri channelUri) {
        String ttlValue = channelUri.get("ttl");
        if (null == ttlValue) {
            this.ttl = null;
            return this;
        }
        try {
            return this.ttl(Integer.valueOf(ttlValue));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'ttl' must be a value integer", ex);
        }
    }

    public Integer ttl() {
        return this.ttl;
    }

    public ChannelUriStringBuilder mtu(Integer mtu) {
        if (null != mtu) {
            if (mtu < 32 || mtu > 65504) {
                throw new IllegalArgumentException("MTU not in range 32-65504: " + mtu);
            }
            if ((mtu & 0x1F) != 0) {
                throw new IllegalArgumentException("MTU not a multiple of FRAME_ALIGNMENT: mtu=" + mtu);
            }
        }
        this.mtu = mtu;
        return this;
    }

    public ChannelUriStringBuilder mtu(ChannelUri channelUri) {
        String mtuValue = channelUri.get("mtu");
        if (null == mtuValue) {
            this.mtu = null;
            return this;
        }
        long value = SystemUtil.parseSize((String)"mtu", (String)mtuValue);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("mtu " + value + " > 2147483647");
        }
        return this.mtu((int)value);
    }

    public Integer mtu() {
        return this.mtu;
    }

    public ChannelUriStringBuilder termLength(Integer termLength) {
        if (null != termLength) {
            LogBufferDescriptor.checkTermLength(termLength);
        }
        this.termLength = termLength;
        return this;
    }

    public ChannelUriStringBuilder termLength(ChannelUri channelUri) {
        String termLengthValue = channelUri.get("term-length");
        if (null == termLengthValue) {
            this.termLength = null;
            return this;
        }
        long value = SystemUtil.parseSize((String)"term-length", (String)termLengthValue);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("term length more than max length of 1073741824: value=" + value);
        }
        return this.termLength((int)value);
    }

    public Integer termLength() {
        return this.termLength;
    }

    public ChannelUriStringBuilder initialTermId(Integer initialTermId) {
        this.initialTermId = initialTermId;
        return this;
    }

    public ChannelUriStringBuilder initialTermId(ChannelUri channelUri) {
        String initialTermIdValue = channelUri.get("init-term-id");
        if (null == initialTermIdValue) {
            this.initialTermId = null;
            return this;
        }
        try {
            return this.initialTermId(Integer.valueOf(initialTermIdValue));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'initial-term-id' must be a valid integer", ex);
        }
    }

    public Integer initialTermId() {
        return this.initialTermId;
    }

    public ChannelUriStringBuilder termId(Integer termId) {
        this.termId = termId;
        return this;
    }

    public ChannelUriStringBuilder termId(ChannelUri channelUri) {
        String termIdValue = channelUri.get("term-id");
        if (null == termIdValue) {
            this.termId = null;
            return this;
        }
        try {
            return this.termId(Integer.valueOf(termIdValue));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'term-id' must be a valid integer", ex);
        }
    }

    public Integer termId() {
        return this.termId;
    }

    public ChannelUriStringBuilder termOffset(Integer termOffset) {
        if (null != termOffset) {
            if (termOffset < 0 || termOffset > 0x40000000) {
                throw new IllegalArgumentException("term offset not in range 0-1g: " + termOffset);
            }
            if (0 != (termOffset & 0x1F)) {
                throw new IllegalArgumentException("term offset not multiple of FRAME_ALIGNMENT: " + termOffset);
            }
        }
        this.termOffset = termOffset;
        return this;
    }

    public ChannelUriStringBuilder termOffset(ChannelUri channelUri) {
        String termOffsetValue = channelUri.get("term-offset");
        if (null == termOffsetValue) {
            this.termOffset = null;
            return this;
        }
        try {
            return this.termOffset(Integer.valueOf(termOffsetValue));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'term-offset' must be a valid integer", ex);
        }
    }

    public Integer termOffset() {
        return this.termOffset;
    }

    public ChannelUriStringBuilder sessionId(Integer sessionId) {
        this.sessionId = null != sessionId ? Long.valueOf(sessionId.longValue()) : null;
        return this;
    }

    public ChannelUriStringBuilder sessionId(String sessionIdStr) {
        if (null != sessionIdStr) {
            if (ChannelUri.isTagged(sessionIdStr)) {
                this.taggedSessionId(ChannelUri.getTag(sessionIdStr));
            } else {
                this.isSessionIdTagged(false);
                try {
                    this.sessionId(Integer.valueOf(sessionIdStr));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("'session-id' must be a valid integer", ex);
                }
            }
        } else {
            this.sessionId((Integer)null);
        }
        return this;
    }

    public ChannelUriStringBuilder taggedSessionId(Long sessionId) {
        this.isSessionIdTagged(true);
        this.sessionId = sessionId;
        return this;
    }

    public ChannelUriStringBuilder sessionId(ChannelUri channelUri) {
        return this.sessionId(channelUri.get("session-id"));
    }

    @Deprecated
    public Integer sessionId() {
        return null != this.sessionId ? Integer.valueOf(this.sessionId.intValue()) : null;
    }

    public ChannelUriStringBuilder linger(Long lingerNs) {
        if (null != lingerNs && lingerNs < 0L) {
            throw new IllegalArgumentException("linger value cannot be negative: " + lingerNs);
        }
        this.linger = lingerNs;
        return this;
    }

    public ChannelUriStringBuilder linger(ChannelUri channelUri) {
        String lingerValue = channelUri.get("linger");
        if (null == lingerValue) {
            this.linger = null;
            return this;
        }
        return this.linger(SystemUtil.parseDuration((String)"linger", (String)lingerValue));
    }

    public Long linger() {
        return this.linger;
    }

    public ChannelUriStringBuilder sparse(Boolean isSparse) {
        this.sparse = isSparse;
        return this;
    }

    public ChannelUriStringBuilder sparse(ChannelUri channelUri) {
        String sparseValue = channelUri.get("sparse");
        if (null == sparseValue) {
            this.sparse = null;
            return this;
        }
        return this.sparse(Boolean.valueOf(sparseValue));
    }

    public Boolean sparse() {
        return this.sparse;
    }

    public ChannelUriStringBuilder eos(Boolean eos) {
        this.eos = eos;
        return this;
    }

    public ChannelUriStringBuilder eos(ChannelUri channelUri) {
        String eosValue = channelUri.get("eos");
        if (null == eosValue) {
            this.eos = null;
            return this;
        }
        return this.eos(Boolean.valueOf(eosValue));
    }

    public Boolean eos() {
        return this.eos;
    }

    public ChannelUriStringBuilder tether(Boolean tether) {
        this.tether = tether;
        return this;
    }

    public ChannelUriStringBuilder tether(ChannelUri channelUri) {
        String tetherValue = channelUri.get("tether");
        if (null == tetherValue) {
            this.tether = null;
            return this;
        }
        return this.tether(Boolean.valueOf(tetherValue));
    }

    public Boolean tether() {
        return this.tether;
    }

    public ChannelUriStringBuilder group(Boolean group) {
        this.group = group;
        return this;
    }

    public ChannelUriStringBuilder group(ChannelUri channelUri) {
        String groupValue = channelUri.get("group");
        if (null == groupValue) {
            this.group = null;
            return this;
        }
        return this.group(Boolean.valueOf(groupValue));
    }

    public Boolean group() {
        return this.group;
    }

    public ChannelUriStringBuilder tags(String tags) {
        this.tags = tags;
        return this;
    }

    public ChannelUriStringBuilder tags(ChannelUri channelUri) {
        return this.tags(channelUri.get("tags"));
    }

    public ChannelUriStringBuilder tags(Long channelTag, Long pubSubTag) {
        if (null == channelTag && null != pubSubTag) {
            throw new IllegalArgumentException("null == channelTag && null != pubSubTag");
        }
        if (null == channelTag) {
            return this.tags((String)null);
        }
        return this.tags(channelTag + (String)(null != pubSubTag ? "," + pubSubTag : ""));
    }

    public String tags() {
        return this.tags;
    }

    public ChannelUriStringBuilder isSessionIdTagged(boolean isSessionIdTagged) {
        this.isSessionIdTagged = isSessionIdTagged;
        return this;
    }

    public boolean isSessionIdTagged() {
        return this.isSessionIdTagged;
    }

    public ChannelUriStringBuilder alias(String alias) {
        this.alias = alias;
        return this;
    }

    public ChannelUriStringBuilder alias(ChannelUri channelUri) {
        return this.alias(channelUri.get("alias"));
    }

    public String alias() {
        return this.alias;
    }

    public ChannelUriStringBuilder congestionControl(String congestionControl) {
        this.cc = congestionControl;
        return this;
    }

    public ChannelUriStringBuilder congestionControl(ChannelUri channelUri) {
        return this.congestionControl(channelUri.get("cc"));
    }

    public String congestionControl() {
        return this.cc;
    }

    public ChannelUriStringBuilder flowControl(String flowControl) {
        this.fc = flowControl;
        return this;
    }

    public ChannelUriStringBuilder taggedFlowControl(Long groupTag, Integer minGroupSize, String timeout) {
        Object flowControlValue = "tagged";
        if (null != groupTag || null != minGroupSize) {
            flowControlValue = (String)flowControlValue + ",g:";
            if (null != groupTag) {
                flowControlValue = (String)flowControlValue + groupTag;
            }
            if (null != minGroupSize) {
                flowControlValue = (String)flowControlValue + "/" + minGroupSize;
            }
        }
        if (null != timeout) {
            flowControlValue = (String)flowControlValue + ",t:" + timeout;
        }
        return this.flowControl((String)flowControlValue);
    }

    public ChannelUriStringBuilder minFlowControl(Integer minGroupSize, String timeout) {
        Object flowControlValue = "min";
        if (null != minGroupSize) {
            flowControlValue = (String)flowControlValue + ",g:/" + minGroupSize;
        }
        if (null != timeout) {
            flowControlValue = (String)flowControlValue + ",t:" + timeout;
        }
        return this.flowControl((String)flowControlValue);
    }

    public ChannelUriStringBuilder flowControl(ChannelUri channelUri) {
        return this.flowControl(channelUri.get("fc"));
    }

    public String flowControl() {
        return this.fc;
    }

    public ChannelUriStringBuilder groupTag(Long groupTag) {
        this.groupTag = groupTag;
        return this;
    }

    public ChannelUriStringBuilder groupTag(ChannelUri channelUri) {
        String groupTagValue = channelUri.get("gtag");
        if (null == groupTagValue) {
            this.groupTag = null;
            return this;
        }
        try {
            return this.groupTag(Long.valueOf(groupTagValue));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'gtag' must be a valid long value", ex);
        }
    }

    public Long groupTag() {
        return this.groupTag;
    }

    public ChannelUriStringBuilder rejoin(Boolean rejoin) {
        this.rejoin = rejoin;
        return this;
    }

    public ChannelUriStringBuilder rejoin(ChannelUri channelUri) {
        String rejoinValue = channelUri.get("rejoin");
        if (null == rejoinValue) {
            this.rejoin = null;
            return this;
        }
        return this.rejoin(Boolean.valueOf(rejoinValue));
    }

    public Boolean rejoin() {
        return this.rejoin;
    }

    public ChannelUriStringBuilder spiesSimulateConnection(Boolean spiesSimulateConnection) {
        this.ssc = spiesSimulateConnection;
        return this;
    }

    public ChannelUriStringBuilder spiesSimulateConnection(ChannelUri channelUri) {
        String sscValue = channelUri.get("ssc");
        if (null == sscValue) {
            this.ssc = null;
            return this;
        }
        return this.spiesSimulateConnection(Boolean.valueOf(sscValue));
    }

    public Boolean spiesSimulateConnection() {
        return this.ssc;
    }

    public ChannelUriStringBuilder initialPosition(long position, int initialTermId, int termLength) {
        if (position < 0L) {
            throw new IllegalArgumentException("invalid position=" + position + " < 0");
        }
        if (0L != (position & 0x1FL)) {
            throw new IllegalArgumentException("invalid position=" + position + " does not have frame alignment=32");
        }
        int bitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        this.initialTermId = initialTermId;
        this.termId = LogBufferDescriptor.computeTermIdFromPosition(position, bitsToShift, initialTermId);
        this.termOffset = (int)(position & (long)(termLength - 1));
        this.termLength = termLength;
        return this;
    }

    public ChannelUriStringBuilder socketSndbufLength(Integer socketSndbufLength) {
        this.socketSndbufLength = socketSndbufLength;
        return this;
    }

    public ChannelUriStringBuilder socketSndbufLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("so-sndbuf");
        if (null == valueStr) {
            this.socketSndbufLength = null;
            return this;
        }
        long value = SystemUtil.parseSize((String)"so-sndbuf", (String)valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value exceeds maximum permitted: value=" + value);
        }
        return this.socketSndbufLength((int)value);
    }

    public Integer socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public ChannelUriStringBuilder socketRcvbufLength(Integer socketRcvbufLength) {
        this.socketRcvbufLength = socketRcvbufLength;
        return this;
    }

    public ChannelUriStringBuilder socketRcvbufLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("so-rcvbuf");
        if (null == valueStr) {
            this.socketRcvbufLength = null;
            return this;
        }
        long value = SystemUtil.parseSize((String)"so-rcvbuf", (String)valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value exceeds maximum permitted: value=" + value);
        }
        return this.socketRcvbufLength((int)value);
    }

    public Integer socketRcvbufLength() {
        return this.socketRcvbufLength;
    }

    public ChannelUriStringBuilder receiverWindowLength(Integer receiverWindowLength) {
        this.receiverWindowLength = receiverWindowLength;
        return this;
    }

    public ChannelUriStringBuilder receiverWindowLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("rcv-wnd");
        if (null == valueStr) {
            this.receiverWindowLength = null;
            return this;
        }
        long value = SystemUtil.parseSize((String)"rcv-wnd", (String)valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value exceeds maximum permitted: value=" + value);
        }
        return this.receiverWindowLength((int)value);
    }

    public Integer receiverWindowLength() {
        return this.receiverWindowLength;
    }

    public String mediaReceiveTimestampOffset() {
        return this.mediaReceiveTimestampOffset;
    }

    public ChannelUriStringBuilder mediaReceiveTimestampOffset(String timestampOffset) {
        if (null != timestampOffset && !"reserved".equals(timestampOffset)) {
            try {
                Integer.parseInt(timestampOffset);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("mediaReceiveTimestampOffset must be a number or the value 'reserved' found: " + timestampOffset);
            }
        }
        this.mediaReceiveTimestampOffset = timestampOffset;
        return this;
    }

    public ChannelUriStringBuilder mediaReceiveTimestampOffset(ChannelUri channelUri) {
        return this.mediaReceiveTimestampOffset(channelUri.get("media-rcv-ts-offset"));
    }

    public String channelReceiveTimestampOffset() {
        return this.channelReceiveTimestampOffset;
    }

    public ChannelUriStringBuilder channelReceiveTimestampOffset(String timestampOffset) {
        if (null != timestampOffset && !"reserved".equals(timestampOffset)) {
            try {
                Integer.parseInt(timestampOffset);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("channelReceiveTimestampOffset must be a number or the value 'reserved' found: " + timestampOffset);
            }
        }
        this.channelReceiveTimestampOffset = timestampOffset;
        return this;
    }

    public ChannelUriStringBuilder channelReceiveTimestampOffset(ChannelUri channelUri) {
        return this.channelReceiveTimestampOffset(channelUri.get("channel-rcv-ts-offset"));
    }

    public ChannelUriStringBuilder channelSendTimestampOffset(String timestampOffset) {
        if (null != timestampOffset && !"reserved".equals(timestampOffset)) {
            try {
                Integer.parseInt(timestampOffset);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("channelSendTimestampOffset must be a number or the value 'reserved' found: " + timestampOffset);
            }
        }
        this.channelSendTimestampOffset = timestampOffset;
        return this;
    }

    public ChannelUriStringBuilder channelSendTimestampOffset(ChannelUri channelUri) {
        return this.channelSendTimestampOffset(channelUri.get("channel-snd-ts-offset"));
    }

    public String channelSendTimestampOffset() {
        return this.channelSendTimestampOffset;
    }

    public ChannelUriStringBuilder responseEndpoint(String responseEndpoint) {
        this.responseEndpoint = responseEndpoint;
        return this;
    }

    public ChannelUriStringBuilder responseEndpoint(ChannelUri channelUri) {
        return this.responseEndpoint(channelUri.get("response-endpoint"));
    }

    public String responseEndpoint() {
        return this.responseEndpoint;
    }

    public ChannelUriStringBuilder responseCorrelationId(Long responseCorrelationId) {
        this.responseCorrelationId = responseCorrelationId;
        return this;
    }

    public ChannelUriStringBuilder responseCorrelationId(ChannelUri channelUri) {
        String responseCorrelationIdString = channelUri.get("response-correlation-id");
        if (null != responseCorrelationIdString) {
            try {
                this.responseCorrelationId(Long.valueOf(responseCorrelationIdString));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("'response-correlation-id' must be a valid long value", ex);
            }
        }
        return this;
    }

    public ChannelUriStringBuilder nakDelay(String nakDelay) {
        this.nakDelay = null != nakDelay ? Long.valueOf(SystemUtil.parseDuration((String)"nak-delay", (String)nakDelay)) : null;
        return this;
    }

    public ChannelUriStringBuilder nakDelay(ChannelUri channelUri) {
        return this.nakDelay(channelUri.get("nak-delay"));
    }

    public Long nakDelay() {
        return this.nakDelay;
    }

    public ChannelUriStringBuilder untetheredWindowLimitTimeout(String timeout) {
        this.untetheredWindowLimitTimeoutNs = null != timeout ? Long.valueOf(SystemUtil.parseDuration((String)"untethered-window-limit-timeout", (String)timeout)) : null;
        return this;
    }

    public ChannelUriStringBuilder untetheredWindowLimitTimeoutNs(Long timeout) {
        this.untetheredWindowLimitTimeoutNs = timeout;
        return this;
    }

    public ChannelUriStringBuilder untetheredWindowLimitTimeout(ChannelUri channelUri) {
        this.untetheredWindowLimitTimeout(channelUri.get("untethered-window-limit-timeout"));
        return this;
    }

    public Long untetheredWindowLimitTimeoutNs() {
        return this.untetheredWindowLimitTimeoutNs;
    }

    public ChannelUriStringBuilder untetheredLingerTimeout(String timeout) {
        this.untetheredLingerTimeoutNs = null != timeout ? Long.valueOf(SystemUtil.parseDuration((String)"untethered-linger-timeout", (String)timeout)) : null;
        return this;
    }

    public ChannelUriStringBuilder untetheredLingerTimeoutNs(Long timeout) {
        this.untetheredLingerTimeoutNs = timeout;
        return this;
    }

    public ChannelUriStringBuilder untetheredLingerTimeout(ChannelUri channelUri) {
        this.untetheredLingerTimeout(channelUri.get("untethered-linger-timeout"));
        return this;
    }

    public Long untetheredLingerTimeoutNs() {
        return this.untetheredLingerTimeoutNs;
    }

    public ChannelUriStringBuilder untetheredRestingTimeout(String timeout) {
        this.untetheredRestingTimeoutNs = null != timeout ? Long.valueOf(SystemUtil.parseDuration((String)"untethered-resting-timeout", (String)timeout)) : null;
        return this;
    }

    public ChannelUriStringBuilder untetheredRestingTimeoutNs(Long timeout) {
        this.untetheredRestingTimeoutNs = timeout;
        return this;
    }

    public ChannelUriStringBuilder untetheredRestingTimeout(ChannelUri channelUri) {
        this.untetheredRestingTimeout(channelUri.get("untethered-resting-timeout"));
        return this;
    }

    public Long untetheredRestingTimeoutNs() {
        return this.untetheredRestingTimeoutNs;
    }

    public ChannelUriStringBuilder maxResend(Integer maxResend) {
        this.maxResend = maxResend;
        return this;
    }

    public ChannelUriStringBuilder maxResend(ChannelUri channelUri) {
        String valueStr = channelUri.get("max-resend");
        if (null == valueStr) {
            this.maxResend = null;
            return this;
        }
        try {
            return this.maxResend(Integer.parseInt(valueStr));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("max-resend must be a number", ex);
        }
    }

    public Integer maxResend() {
        return this.maxResend;
    }

    public Integer streamId() {
        return this.streamId;
    }

    public ChannelUriStringBuilder streamId(Integer streamId) {
        this.streamId = streamId;
        return this;
    }

    public ChannelUriStringBuilder streamId(ChannelUri channelUri) {
        String valueStr = channelUri.get("stream-id");
        if (null == valueStr) {
            this.streamId = null;
            return this;
        }
        try {
            return this.streamId(Integer.parseInt(valueStr));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("stream-id must be a number", ex);
        }
    }

    public ChannelUriStringBuilder publicationWindowLength(Integer publicationWindowLength) {
        this.publicationWindowLength = publicationWindowLength;
        return this;
    }

    public ChannelUriStringBuilder publicationWindowLength(ChannelUri channelUri) {
        String valueStr = channelUri.get("pub-wnd");
        if (null == valueStr) {
            this.publicationWindowLength = null;
            return this;
        }
        long value = SystemUtil.parseSize((String)"pub-wnd", (String)valueStr);
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value exceeds maximum permitted: value=" + value);
        }
        return this.publicationWindowLength((int)value);
    }

    public Integer publicationWindowLength() {
        return this.publicationWindowLength;
    }

    public String build() {
        this.sb.setLength(0);
        if (null != this.prefix && !this.prefix.isEmpty()) {
            this.sb.append(this.prefix).append(':');
        }
        this.sb.append("aeron").append(':').append(this.media).append('?');
        ChannelUriStringBuilder.appendParameter(this.sb, "tags", this.tags);
        ChannelUriStringBuilder.appendParameter(this.sb, "endpoint", this.endpoint);
        ChannelUriStringBuilder.appendParameter(this.sb, "interface", this.networkInterface);
        ChannelUriStringBuilder.appendParameter(this.sb, "control", this.controlEndpoint);
        ChannelUriStringBuilder.appendParameter(this.sb, "control-mode", this.controlMode);
        ChannelUriStringBuilder.appendParameter(this.sb, "mtu", this.mtu);
        ChannelUriStringBuilder.appendParameter(this.sb, "term-length", this.termLength);
        ChannelUriStringBuilder.appendParameter(this.sb, "init-term-id", this.initialTermId);
        ChannelUriStringBuilder.appendParameter(this.sb, "term-id", this.termId);
        ChannelUriStringBuilder.appendParameter(this.sb, "term-offset", this.termOffset);
        if (null != this.sessionId) {
            ChannelUriStringBuilder.appendParameter(this.sb, "session-id", ChannelUriStringBuilder.prefixTag(this.isSessionIdTagged, this.sessionId));
        }
        ChannelUriStringBuilder.appendParameter(this.sb, "ttl", this.ttl);
        ChannelUriStringBuilder.appendParameter(this.sb, "reliable", this.reliable);
        ChannelUriStringBuilder.appendParameter(this.sb, "linger", this.linger);
        ChannelUriStringBuilder.appendParameter(this.sb, "alias", this.alias);
        ChannelUriStringBuilder.appendParameter(this.sb, "cc", this.cc);
        ChannelUriStringBuilder.appendParameter(this.sb, "fc", this.fc);
        ChannelUriStringBuilder.appendParameter(this.sb, "gtag", this.groupTag);
        ChannelUriStringBuilder.appendParameter(this.sb, "sparse", this.sparse);
        ChannelUriStringBuilder.appendParameter(this.sb, "eos", this.eos);
        ChannelUriStringBuilder.appendParameter(this.sb, "tether", this.tether);
        ChannelUriStringBuilder.appendParameter(this.sb, "group", this.group);
        ChannelUriStringBuilder.appendParameter(this.sb, "rejoin", this.rejoin);
        ChannelUriStringBuilder.appendParameter(this.sb, "ssc", this.ssc);
        ChannelUriStringBuilder.appendParameter(this.sb, "so-sndbuf", this.socketSndbufLength);
        ChannelUriStringBuilder.appendParameter(this.sb, "so-rcvbuf", this.socketRcvbufLength);
        ChannelUriStringBuilder.appendParameter(this.sb, "rcv-wnd", this.receiverWindowLength);
        ChannelUriStringBuilder.appendParameter(this.sb, "media-rcv-ts-offset", this.mediaReceiveTimestampOffset);
        ChannelUriStringBuilder.appendParameter(this.sb, "channel-rcv-ts-offset", this.channelReceiveTimestampOffset);
        ChannelUriStringBuilder.appendParameter(this.sb, "channel-snd-ts-offset", this.channelSendTimestampOffset);
        ChannelUriStringBuilder.appendParameter(this.sb, "response-endpoint", this.responseEndpoint);
        ChannelUriStringBuilder.appendParameter(this.sb, "response-correlation-id", this.responseCorrelationId);
        ChannelUriStringBuilder.appendParameter(this.sb, "nak-delay", this.nakDelay);
        ChannelUriStringBuilder.appendParameter(this.sb, "untethered-window-limit-timeout", this.untetheredWindowLimitTimeoutNs);
        ChannelUriStringBuilder.appendParameter(this.sb, "untethered-linger-timeout", this.untetheredLingerTimeoutNs);
        ChannelUriStringBuilder.appendParameter(this.sb, "untethered-resting-timeout", this.untetheredRestingTimeoutNs);
        ChannelUriStringBuilder.appendParameter(this.sb, "max-resend", this.maxResend);
        ChannelUriStringBuilder.appendParameter(this.sb, "stream-id", this.streamId);
        ChannelUriStringBuilder.appendParameter(this.sb, "pub-wnd", this.publicationWindowLength);
        char lastChar = this.sb.charAt(this.sb.length() - 1);
        if (lastChar == '|' || lastChar == '?') {
            this.sb.setLength(this.sb.length() - 1);
        }
        return this.sb.toString();
    }

    private static void appendParameter(StringBuilder sb, String paramName, Object paramValue) {
        if (null != paramValue) {
            sb.append(paramName).append('=').append(paramValue).append('|');
        }
    }

    public String toString() {
        return this.build();
    }

    private static String prefixTag(boolean isTagged, Long value) {
        return isTagged ? TAG_PREFIX + value : value.toString();
    }
}

