/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverEventsAdapter;
import io.aeron.DriverProxy;
import io.aeron.ErrorCode;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.LogBuffers;
import io.aeron.LogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.command.PublicationErrorFrameFlyweight;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ChannelEndpointException;
import io.aeron.exceptions.ClientTimeoutException;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.status.HeartbeatTimestamp;
import io.aeron.status.PublicationErrorFrame;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

final class ClientConductor
implements Agent {
    private static final long NO_CORRELATION_ID = -1L;
    private static final long EXPLICIT_CLOSE_LINGER_NS = TimeUnit.SECONDS.toNanos(1L);
    private final long idleSleepDurationNs;
    private final long keepAliveIntervalNs;
    private final long driverTimeoutMs;
    private final long driverTimeoutNs;
    private final long interServiceTimeoutNs;
    private long timeOfLastKeepAliveNs;
    private long timeOfLastServiceNs;
    private boolean isClosed;
    private boolean isInCallback;
    private boolean isTerminating;
    private RegistrationException driverException;
    private final Aeron.Context ctx;
    private final Aeron aeron;
    private final Lock clientLock;
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final IdleStrategy awaitingIdleStrategy;
    private final DriverEventsAdapter driverEventsAdapter;
    private final LogBuffersFactory logBuffersFactory;
    private final Long2ObjectHashMap<LogBuffers> logBuffersByIdMap = new Long2ObjectHashMap();
    private final ArrayList<LogBuffers> lingeringLogBuffers = new ArrayList();
    final Long2ObjectHashMap<Object> resourceByRegIdMap = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<RegistrationException> asyncExceptionByRegIdMap = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<String> stashedChannelByRegistrationId = new Long2ObjectHashMap();
    final LongHashSet asyncCommandIdSet = new LongHashSet();
    private final AvailableImageHandler defaultAvailableImageHandler;
    private final UnavailableImageHandler defaultUnavailableImageHandler;
    private final Long2ObjectHashMap<AvailableCounterHandler> availableCounterHandlerById = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<UnavailableCounterHandler> unavailableCounterHandlerById = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<Runnable> closeHandlerByIdMap = new Long2ObjectHashMap();
    private final DriverProxy driverProxy;
    private final AgentInvoker driverAgentInvoker;
    private final UnsafeBuffer counterValuesBuffer;
    private final CountersReader countersReader;
    private final PublicationErrorFrame publicationErrorFrame = new PublicationErrorFrame();
    private AtomicCounter heartbeatTimestamp;

    ClientConductor(Aeron.Context ctx, Aeron aeron) {
        long nowNs;
        this.ctx = ctx;
        this.aeron = aeron;
        this.clientLock = ctx.clientLock();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.awaitingIdleStrategy = ctx.awaitingIdleStrategy();
        this.driverProxy = ctx.driverProxy();
        this.logBuffersFactory = ctx.logBuffersFactory();
        this.idleSleepDurationNs = ctx.idleSleepDurationNs();
        this.keepAliveIntervalNs = ctx.keepAliveIntervalNs();
        this.driverTimeoutMs = ctx.driverTimeoutMs();
        this.driverTimeoutNs = TimeUnit.MILLISECONDS.toNanos(this.driverTimeoutMs);
        this.interServiceTimeoutNs = ctx.interServiceTimeoutNs();
        this.defaultAvailableImageHandler = ctx.availableImageHandler();
        this.defaultUnavailableImageHandler = ctx.unavailableImageHandler();
        this.driverEventsAdapter = new DriverEventsAdapter(ctx.clientId(), ctx.toClientBuffer(), this, this.asyncCommandIdSet);
        this.driverAgentInvoker = ctx.driverAgentInvoker();
        this.counterValuesBuffer = ctx.countersValuesBuffer();
        this.countersReader = new CountersReader((AtomicBuffer)ctx.countersMetaDataBuffer(), (AtomicBuffer)ctx.countersValuesBuffer(), StandardCharsets.US_ASCII);
        if (null != ctx.availableCounterHandler()) {
            this.availableCounterHandlerById.put(aeron.nextCorrelationId(), (Object)ctx.availableCounterHandler());
        }
        if (null != ctx.unavailableCounterHandler()) {
            this.unavailableCounterHandlerById.put(aeron.nextCorrelationId(), (Object)ctx.unavailableCounterHandler());
        }
        if (null != ctx.closeHandler()) {
            this.closeHandlerByIdMap.put(aeron.nextCorrelationId(), (Object)ctx.closeHandler());
        }
        this.timeOfLastKeepAliveNs = nowNs = this.nanoClock.nanoTime();
        this.timeOfLastServiceNs = nowNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        boolean isInterrupted = false;
        this.aeron.internalClose();
        this.clientLock.lock();
        try {
            boolean isTerminating = this.isTerminating;
            this.isTerminating = true;
            this.forceCloseResources();
            this.notifyCloseHandlers();
            try {
                if (isTerminating) {
                    Thread.sleep(16L);
                }
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.ctx.closeLingerDurationNs()));
            }
            catch (InterruptedException ignore) {
                isInterrupted = true;
            }
            for (LogBuffers lingeringLogBuffer : this.lingeringLogBuffers) {
                CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)lingeringLogBuffer);
            }
            this.driverProxy.clientClose();
            this.ctx.close();
            this.ctx.countersMetaDataBuffer().wrap(0L, 0);
            this.ctx.countersValuesBuffer().wrap(0L, 0);
        }
        finally {
            this.isClosed = true;
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
            this.clientLock.unlock();
        }
    }

    public int doWork() {
        int workCount = 0;
        if (this.clientLock.tryLock()) {
            try {
                if (this.isTerminating) {
                    throw new AgentTerminationException();
                }
                workCount = this.service(-1L);
            }
            finally {
                this.clientLock.unlock();
            }
        }
        return workCount;
    }

    public String roleName() {
        return "aeron-client-conductor";
    }

    boolean isClosed() {
        return this.isClosed;
    }

    boolean isTerminating() {
        return this.isTerminating;
    }

    void onError(long correlationId, int codeValue, ErrorCode errorCode, String message) {
        this.driverException = new RegistrationException(correlationId, codeValue, errorCode, message);
        Object resource = this.resourceByRegIdMap.get(correlationId);
        if (resource instanceof Subscription) {
            Subscription subscription = (Subscription)resource;
            subscription.internalClose(-1L);
            this.resourceByRegIdMap.remove(correlationId);
        }
    }

    void onAsyncError(long correlationId, int codeValue, ErrorCode errorCode, String message) {
        this.stashedChannelByRegistrationId.remove(correlationId);
        RegistrationException ex = new RegistrationException(correlationId, codeValue, errorCode, message);
        this.asyncExceptionByRegIdMap.put(correlationId, (Object)ex);
    }

    void onChannelEndpointError(long correlationId, String message) {
        int statusIndicatorId = (int)correlationId;
        for (Object resource : this.resourceByRegIdMap.values()) {
            if (resource instanceof Subscription) {
                if (((Subscription)resource).channelStatusId() != statusIndicatorId) continue;
                this.handleError(new ChannelEndpointException(statusIndicatorId, message));
                continue;
            }
            if (!(resource instanceof Publication) || ((Publication)resource).channelStatusId() != statusIndicatorId) continue;
            this.handleError(new ChannelEndpointException(statusIndicatorId, message));
        }
        if (this.asyncCommandIdSet.remove(correlationId)) {
            this.stashedChannelByRegistrationId.remove(correlationId);
            this.handleError(new RegistrationException(correlationId, ErrorCode.CHANNEL_ENDPOINT_ERROR.value(), ErrorCode.CHANNEL_ENDPOINT_ERROR, message));
        }
    }

    void onPublicationError(PublicationErrorFrameFlyweight errorFrameFlyweight) {
        for (Object resource : this.resourceByRegIdMap.values()) {
            Publication publication;
            if (!(resource instanceof Publication) || (publication = (Publication)resource).originalRegistrationId() != errorFrameFlyweight.registrationId()) continue;
            this.publicationErrorFrame.set(errorFrameFlyweight);
            this.ctx.publicationErrorFrameHandler().onPublicationError(this.publicationErrorFrame);
        }
    }

    void onNewPublication(long correlationId, long registrationId, int streamId, int sessionId, int publicationLimitId, int statusIndicatorId, String logFileName) {
        String stashedChannel = (String)this.stashedChannelByRegistrationId.remove(correlationId);
        ConcurrentPublication publication = new ConcurrentPublication(this, stashedChannel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), statusIndicatorId, this.logBuffers(registrationId, logFileName, stashedChannel), registrationId, correlationId);
        this.resourceByRegIdMap.put(correlationId, (Object)publication);
    }

    void onNewExclusivePublication(long correlationId, long registrationId, int streamId, int sessionId, int publicationLimitId, int statusIndicatorId, String logFileName) {
        if (correlationId != registrationId) {
            this.handleError(new IllegalStateException("correlationId=" + correlationId + " registrationId=" + registrationId));
        }
        String stashedChannel = (String)this.stashedChannelByRegistrationId.remove(correlationId);
        ExclusivePublication publication = new ExclusivePublication(this, stashedChannel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), statusIndicatorId, this.logBuffers(registrationId, logFileName, stashedChannel), registrationId, correlationId);
        this.resourceByRegIdMap.put(correlationId, (Object)publication);
    }

    void onNewSubscription(long correlationId, int statusIndicatorId) {
        Subscription subscription;
        Object resource = this.resourceByRegIdMap.get(correlationId);
        if (resource instanceof PendingSubscription) {
            subscription = ((PendingSubscription)resource).subscription;
            this.resourceByRegIdMap.put(correlationId, (Object)subscription);
        } else {
            subscription = (Subscription)resource;
        }
        subscription.channelStatusId(statusIndicatorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAvailableImage(long correlationId, int sessionId, long subscriptionRegistrationId, int subscriberPositionId, String logFileName, String sourceIdentity) {
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(subscriptionRegistrationId);
        if (null != subscription) {
            Image image = new Image(subscription, sessionId, (Position)new UnsafeBufferPosition(this.counterValuesBuffer, subscriberPositionId), this.logBuffers(correlationId, logFileName, subscription.channel()), this.ctx.subscriberErrorHandler(), sourceIdentity, correlationId);
            subscription.addImage(image);
            AvailableImageHandler handler = subscription.availableImageHandler();
            if (null != handler) {
                this.isInCallback = true;
                try {
                    handler.onAvailableImage(image);
                }
                catch (Exception ex) {
                    this.handleError(ex);
                }
                finally {
                    this.isInCallback = false;
                }
            }
        }
    }

    void onUnavailableImage(long correlationId, long subscriptionRegistrationId) {
        UnavailableImageHandler handler;
        Image image;
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(subscriptionRegistrationId);
        if (null != subscription && null != (image = subscription.removeImage(correlationId)) && null != (handler = subscription.unavailableImageHandler())) {
            this.notifyImageUnavailable(handler, image);
        }
    }

    void onNewCounter(long correlationId, int counterId) {
        this.resourceByRegIdMap.put(correlationId, (Object)new Counter(correlationId, this, (AtomicBuffer)this.counterValuesBuffer, counterId));
        this.onAvailableCounter(correlationId, counterId);
    }

    void onAvailableCounter(long registrationId, int counterId) {
        for (AvailableCounterHandler handler : this.availableCounterHandlerById.values()) {
            this.notifyCounterAvailable(registrationId, counterId, handler);
        }
    }

    void onUnavailableCounter(long registrationId, int counterId) {
        this.notifyUnavailableCounterHandlers(registrationId, counterId);
    }

    void onClientTimeout() {
        if (!this.isClosed) {
            this.terminateConductor();
            this.handleError(new ClientTimeoutException("client timeout from driver"));
        }
    }

    CountersReader countersReader() {
        return this.countersReader;
    }

    void handleError(Throwable ex) {
        if (!this.isClosed) {
            this.ctx.errorHandler().onError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentPublication addPublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.driverProxy.addPublication(channel, streamId);
            this.stashedChannelByRegistrationId.put(registrationId, (Object)channel);
            this.awaitResponse(registrationId);
            ConcurrentPublication concurrentPublication = (ConcurrentPublication)this.resourceByRegIdMap.get(registrationId);
            return concurrentPublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExclusivePublication addExclusivePublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.driverProxy.addExclusivePublication(channel, streamId);
            this.stashedChannelByRegistrationId.put(registrationId, (Object)channel);
            this.awaitResponse(registrationId);
            ExclusivePublication exclusivePublication = (ExclusivePublication)this.resourceByRegIdMap.get(registrationId);
            return exclusivePublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddPublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.driverProxy.addPublication(channel, streamId);
            this.stashedChannelByRegistrationId.put(registrationId, (Object)channel);
            this.asyncCommandIdSet.add(registrationId);
            long l = registrationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddExclusivePublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.driverProxy.addExclusivePublication(channel, streamId);
            this.stashedChannelByRegistrationId.put(registrationId, (Object)channel);
            this.asyncCommandIdSet.add(registrationId);
            long l = registrationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentPublication getPublication(long registrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (this.asyncCommandIdSet.contains(registrationId)) {
                this.service(-1L);
            }
            ConcurrentPublication concurrentPublication = this.resourceOrThrow(registrationId, ConcurrentPublication.class);
            return concurrentPublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExclusivePublication getExclusivePublication(long registrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (this.asyncCommandIdSet.contains(registrationId)) {
                this.service(-1L);
            }
            ExclusivePublication exclusivePublication = this.resourceOrThrow(registrationId, ExclusivePublication.class);
            return exclusivePublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    void removePublication(Publication publication) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                return;
            }
            if (!publication.isClosed()) {
                this.ensureNotReentrant();
                publication.internalClose();
                if (publication == this.resourceByRegIdMap.remove(publication.registrationId())) {
                    this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId(), EXPLICIT_CLOSE_LINGER_NS);
                    this.asyncCommandIdSet.add(this.driverProxy.removePublication(publication.registrationId(), publication.revokeOnClose));
                }
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePublication(long publicationRegistrationId) {
        this.clientLock.lock();
        try {
            if (-1L == publicationRegistrationId || this.isTerminating || this.isClosed) {
                return;
            }
            this.ensureNotReentrant();
            Object resource = this.resourceByRegIdMap.get(publicationRegistrationId);
            if (null != resource && !(resource instanceof Publication)) {
                throw new AeronException("registration id is not a Publication: " + resource.getClass().getSimpleName());
            }
            Publication publication = (Publication)resource;
            boolean revokeOnClose = false;
            if (null != publication) {
                this.resourceByRegIdMap.remove(publicationRegistrationId);
                publication.internalClose();
                this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId(), EXPLICIT_CLOSE_LINGER_NS);
                revokeOnClose = publication.revokeOnClose;
            }
            if (this.asyncCommandIdSet.remove(publicationRegistrationId) || null != publication) {
                this.asyncCommandIdSet.add(this.driverProxy.removePublication(publicationRegistrationId, revokeOnClose));
                this.stashedChannelByRegistrationId.remove(publicationRegistrationId);
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    Subscription addSubscription(String channel, int streamId) {
        return this.addSubscription(channel, streamId, this.defaultAvailableImageHandler, this.defaultUnavailableImageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.addSubscription(channel, streamId);
            Subscription subscription = new Subscription(this, channel, streamId, correlationId, availableImageHandler, unavailableImageHandler);
            this.resourceByRegIdMap.put(correlationId, (Object)subscription);
            this.awaitResponse(correlationId);
            Subscription subscription2 = subscription;
            return subscription2;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    long asyncAddSubscription(String channel, int streamId) {
        return this.asyncAddSubscription(channel, streamId, this.defaultAvailableImageHandler, this.defaultUnavailableImageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.driverProxy.addSubscription(channel, streamId);
            PendingSubscription subscription = new PendingSubscription(new Subscription(this, channel, streamId, registrationId, availableImageHandler, unavailableImageHandler));
            this.resourceByRegIdMap.put(registrationId, (Object)subscription);
            this.asyncCommandIdSet.add(registrationId);
            long l = registrationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscription getSubscription(long registrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (this.asyncCommandIdSet.contains(registrationId)) {
                this.service(-1L);
            }
            Subscription subscription = this.resourceOrThrow(registrationId, Subscription.class);
            return subscription;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(Subscription subscription) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                return;
            }
            if (!subscription.isClosed()) {
                this.ensureNotReentrant();
                subscription.internalClose(EXPLICIT_CLOSE_LINGER_NS);
                long registrationId = subscription.registrationId();
                if (subscription == this.resourceByRegIdMap.remove(registrationId)) {
                    this.asyncCommandIdSet.add(this.driverProxy.removeSubscription(registrationId));
                }
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(long subscriptionRegistrationId) {
        this.clientLock.lock();
        try {
            Subscription subscription;
            if (-1L == subscriptionRegistrationId || this.isTerminating || this.isClosed) {
                return;
            }
            this.ensureNotReentrant();
            Object resource = this.resourceByRegIdMap.get(subscriptionRegistrationId);
            if (resource != null && !(resource instanceof PendingSubscription) && !(resource instanceof Subscription)) {
                throw new AeronException("registration id is not a Subscription: " + resource.getClass().getSimpleName());
            }
            Subscription subscription2 = subscription = resource instanceof PendingSubscription ? ((PendingSubscription)resource).subscription : (Subscription)resource;
            if (null != subscription) {
                this.resourceByRegIdMap.remove(subscriptionRegistrationId);
                subscription.internalClose(EXPLICIT_CLOSE_LINGER_NS);
            }
            if (this.asyncCommandIdSet.remove(subscriptionRegistrationId) || null != subscription) {
                this.asyncCommandIdSet.add(this.driverProxy.removeSubscription(subscriptionRegistrationId));
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.addDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addDestinationWithId(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.addDestination(registrationId, endpointChannel);
            this.awaitResponse(correlationId);
            long l = correlationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(long publicationRegistrationId, long destinationRegistrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeDestination(publicationRegistrationId, destinationRegistrationId));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRcvDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.addRcvDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRcvDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeRcvDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.addDestination(registrationId, endpointChannel);
            this.asyncCommandIdSet.add(correlationId);
            long l = correlationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncRemoveDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.removeDestination(registrationId, endpointChannel);
            this.asyncCommandIdSet.add(correlationId);
            long l = correlationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncRemoveDestination(long registrationId, long destinationRegistrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.removeDestination(registrationId, destinationRegistrationId);
            this.asyncCommandIdSet.add(correlationId);
            long l = correlationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncAddRcvDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.addRcvDestination(registrationId, endpointChannel);
            this.asyncCommandIdSet.add(correlationId);
            long l = correlationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long asyncRemoveRcvDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.removeRcvDestination(registrationId, endpointChannel);
            this.asyncCommandIdSet.add(correlationId);
            long l = correlationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCommandActive(long correlationId) {
        this.clientLock.lock();
        try {
            if (this.isClosed) {
                boolean bl = false;
                return bl;
            }
            this.ensureActive();
            if (this.asyncCommandIdSet.contains(correlationId)) {
                this.service(-1L);
            }
            boolean bl = this.asyncCommandIdSet.contains(correlationId);
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    boolean hasActiveCommands() {
        this.clientLock.lock();
        try {
            if (this.isClosed) {
                boolean bl = false;
                return bl;
            }
            this.ensureActive();
            boolean bl = !this.asyncCommandIdSet.isEmpty();
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (keyLength < 0 || keyLength > 112) {
                throw new IllegalArgumentException("key length out of bounds: " + keyLength);
            }
            if (labelLength < 0 || labelLength > 380) {
                throw new IllegalArgumentException("label length out of bounds: " + labelLength);
            }
            long registrationId = this.driverProxy.addCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
            this.awaitResponse(registrationId);
            Counter counter = (Counter)((Object)this.resourceByRegIdMap.get(registrationId));
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addCounter(int typeId, String label) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (label.length() > 380) {
                throw new IllegalArgumentException("label length exceeds MAX_LABEL_LENGTH: " + label.length());
            }
            long registrationId = this.driverProxy.addCounter(typeId, label);
            this.awaitResponse(registrationId);
            Counter counter = (Counter)((Object)this.resourceByRegIdMap.get(registrationId));
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addStaticCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long registrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (keyLength < 0 || keyLength > 112) {
                throw new IllegalArgumentException("key length out of bounds: " + keyLength);
            }
            if (labelLength < 0 || labelLength > 380) {
                throw new IllegalArgumentException("label length out of bounds: " + labelLength);
            }
            long correlationId = this.driverProxy.addStaticCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength, registrationId);
            this.awaitResponse(correlationId);
            int counterId = (Integer)this.resourceByRegIdMap.remove(correlationId);
            Counter counter = new Counter(this.aeron.countersReader(), registrationId, counterId);
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addStaticCounter(int typeId, String label, long registrationId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (label.length() > 380) {
                throw new IllegalArgumentException("label length exceeds MAX_LABEL_LENGTH: " + label.length());
            }
            long correlationId = this.driverProxy.addStaticCounter(typeId, label, registrationId);
            this.awaitResponse(correlationId);
            int counterId = (Integer)this.resourceByRegIdMap.remove(correlationId);
            Counter counter = new Counter(this.aeron.countersReader(), registrationId, counterId);
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addAvailableCounterHandler(AvailableCounterHandler handler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.aeron.nextCorrelationId();
            this.availableCounterHandlerById.put(registrationId, (Object)handler);
            long l = registrationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAvailableCounterHandler(long registrationId) {
        this.clientLock.lock();
        try {
            boolean bl = this.availableCounterHandlerById.remove(registrationId) != null;
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeAvailableCounterHandler(AvailableCounterHandler handler) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                boolean bl = false;
                return bl;
            }
            this.ensureNotReentrant();
            Long2ObjectHashMap.ValueIterator iterator = this.availableCounterHandlerById.values().iterator();
            while (iterator.hasNext()) {
                if (handler != iterator.next()) continue;
                iterator.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addUnavailableCounterHandler(UnavailableCounterHandler handler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.aeron.nextCorrelationId();
            this.unavailableCounterHandlerById.put(registrationId, (Object)handler);
            long l = registrationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnavailableCounterHandler(long registrationId) {
        this.clientLock.lock();
        try {
            boolean bl = this.unavailableCounterHandlerById.remove(registrationId) != null;
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnavailableCounterHandler(UnavailableCounterHandler handler) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                boolean bl = false;
                return bl;
            }
            this.ensureNotReentrant();
            Long2ObjectHashMap.ValueIterator iterator = this.unavailableCounterHandlerById.values().iterator();
            while (iterator.hasNext()) {
                if (handler != iterator.next()) continue;
                iterator.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addCloseHandler(Runnable handler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.aeron.nextCorrelationId();
            this.closeHandlerByIdMap.put(registrationId, (Object)handler);
            long l = registrationId;
            return l;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCloseHandler(long registrationId) {
        this.clientLock.lock();
        try {
            boolean bl = this.closeHandlerByIdMap.remove(registrationId) != null;
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCloseHandler(Runnable handler) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                boolean bl = false;
                return bl;
            }
            this.ensureNotReentrant();
            Long2ObjectHashMap.ValueIterator iterator = this.closeHandlerByIdMap.values().iterator();
            while (iterator.hasNext()) {
                if (handler != iterator.next()) continue;
                iterator.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCounter(Counter counter) {
        this.clientLock.lock();
        try {
            if (this.isTerminating || this.isClosed) {
                return;
            }
            this.ensureNotReentrant();
            long registrationId = counter.registrationId();
            if (counter == this.resourceByRegIdMap.remove(registrationId)) {
                this.asyncCommandIdSet.add(this.driverProxy.removeCounter(registrationId));
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    void releaseLogBuffers(LogBuffers logBuffers, long registrationId, long lingerDurationNs) {
        if (logBuffers.decRef() == 0) {
            this.lingeringLogBuffers.add(logBuffers);
            this.logBuffersByIdMap.remove(registrationId);
            long lingerNs = -1L == lingerDurationNs ? this.ctx.resourceLingerDurationNs() : lingerDurationNs;
            logBuffers.lingerDeadlineNs(this.nanoClock.nanoTime() + lingerNs);
        }
    }

    DriverEventsAdapter driverListenerAdapter() {
        return this.driverEventsAdapter;
    }

    long channelStatus(int channelStatusId) {
        switch (channelStatusId) {
            case 0: {
                return 0L;
            }
            case -1: {
                return 1L;
            }
        }
        return this.countersReader.getCounterValue(channelStatusId);
    }

    void closeImages(Image[] images, UnavailableImageHandler unavailableImageHandler, long lingerNs) {
        for (Image image : images) {
            image.close();
        }
        for (Image image : images) {
            this.releaseLogBuffers(image.logBuffers(), image.correlationId(), lingerNs);
        }
        if (null != unavailableImageHandler) {
            for (Image image : images) {
                this.notifyImageUnavailable(unavailableImageHandler, image);
            }
        }
    }

    void onStaticCounter(long correlationId, int counterId) {
        this.resourceByRegIdMap.put(correlationId, (Object)counterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rejectImage(long correlationId, long position, String reason) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long registrationId = this.driverProxy.rejectImage(correlationId, position, reason);
            this.awaitResponse(registrationId);
        }
        finally {
            this.clientLock.unlock();
        }
    }

    private void ensureActive() {
        if (this.isClosed) {
            throw new AeronException("Aeron client is closed");
        }
        if (this.isTerminating) {
            throw new AeronException("Aeron client is terminating");
        }
    }

    private void ensureNotReentrant() {
        if (this.isInCallback) {
            throw new AeronException("reentrant calls not permitted during callbacks");
        }
    }

    private LogBuffers logBuffers(long registrationId, String logFileName, String channel) {
        LogBuffers logBuffers = (LogBuffers)this.logBuffersByIdMap.get(registrationId);
        if (null == logBuffers) {
            logBuffers = this.logBuffersFactory.map(logFileName);
            if (this.ctx.preTouchMappedMemory()) {
                logBuffers.preTouch();
            }
            this.logBuffersByIdMap.put(registrationId, (Object)logBuffers);
        }
        logBuffers.incRef();
        return logBuffers;
    }

    private int service(long correlationId) {
        int workCount = 0;
        try {
            workCount += this.checkTimeouts(this.nanoClock.nanoTime());
            workCount += this.driverEventsAdapter.receive(correlationId);
        }
        catch (AgentTerminationException ex) {
            if (ClientConductor.isClientApiCall(correlationId)) {
                this.terminateConductor();
            }
            throw ex;
        }
        catch (Exception ex) {
            if (this.driverEventsAdapter.isInvalid()) {
                this.terminateConductor();
                if (!ClientConductor.isClientApiCall(correlationId)) {
                    throw new AeronException("Driver events adapter is invalid", ex);
                }
            }
            if (ClientConductor.isClientApiCall(correlationId)) {
                throw ex;
            }
            this.handleError(ex);
        }
        return workCount;
    }

    private void terminateConductor() {
        this.isTerminating = true;
        this.forceCloseResources();
    }

    private void awaitResponse(long correlationId) {
        long nowNs = this.nanoClock.nanoTime();
        long deadlineNs = nowNs + this.driverTimeoutNs;
        this.checkTimeouts(nowNs);
        this.awaitingIdleStrategy.reset();
        do {
            if (null == this.driverAgentInvoker) {
                this.awaitingIdleStrategy.idle();
            } else {
                this.driverAgentInvoker.invoke();
            }
            this.service(correlationId);
            if (this.driverEventsAdapter.receivedCorrelationId() == correlationId) {
                this.stashedChannelByRegistrationId.remove(correlationId);
                RegistrationException ex = this.driverException;
                if (null != ex) {
                    this.driverException = null;
                    throw ex;
                }
                return;
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            this.terminateConductor();
            throw new AeronException("unexpected interrupt");
        } while (deadlineNs - this.nanoClock.nanoTime() > 0L);
        throw new DriverTimeoutException("no response from MediaDriver within " + this.driverTimeoutNs + "ns");
    }

    private int checkTimeouts(long nowNs) {
        int workCount = 0;
        if (this.timeOfLastServiceNs + this.idleSleepDurationNs - nowNs < 0L) {
            this.checkServiceInterval(nowNs);
            this.timeOfLastServiceNs = nowNs;
            workCount += this.checkLiveness(nowNs);
            workCount += this.checkLingeringResources(nowNs);
        }
        return workCount;
    }

    private void checkServiceInterval(long nowNs) {
        if (this.timeOfLastServiceNs + this.interServiceTimeoutNs - nowNs < 0L) {
            this.terminateConductor();
            throw new ConductorServiceTimeoutException("service interval exceeded: timeout=" + this.interServiceTimeoutNs + "ns, interval=" + (nowNs - this.timeOfLastServiceNs) + "ns");
        }
    }

    private int checkLiveness(long nowNs) {
        if (this.timeOfLastKeepAliveNs + this.keepAliveIntervalNs - nowNs < 0L) {
            long lastKeepAliveMs;
            long nowMs = this.epochClock.time();
            if (nowMs > (lastKeepAliveMs = this.driverProxy.timeOfLastDriverKeepaliveMs()) + this.driverTimeoutMs) {
                this.terminateConductor();
                if (-1L == lastKeepAliveMs) {
                    throw new DriverTimeoutException("MediaDriver (" + this.aeron.context().aeronDirectoryName() + ") has been shutdown");
                }
                throw new DriverTimeoutException("MediaDriver (" + this.aeron.context().aeronDirectoryName() + ") keepalive: age=" + (nowMs - lastKeepAliveMs) + "ms > timeout=" + this.driverTimeoutMs + "ms");
            }
            if (null == this.heartbeatTimestamp) {
                int counterId = HeartbeatTimestamp.findCounterIdByRegistrationId(this.countersReader, 11, this.ctx.clientId());
                if (-1 != counterId) {
                    try {
                        this.heartbeatTimestamp = new AtomicCounter((AtomicBuffer)this.counterValuesBuffer, counterId);
                        this.heartbeatTimestamp.setRelease(nowMs);
                        AeronCounters.appendToLabel(this.countersReader.metaDataBuffer(), counterId, " name=" + this.ctx.clientName() + " " + AeronCounters.formatVersionInfo("1.48.0", "d800d60405"));
                        this.timeOfLastKeepAliveNs = nowNs;
                    }
                    catch (RuntimeException ex) {
                        this.terminateConductor();
                        throw new AeronException("unexpected close of heartbeat timestamp counter: " + counterId, ex);
                    }
                }
            } else {
                int counterId = this.heartbeatTimestamp.id();
                if (!HeartbeatTimestamp.isActive(this.countersReader, counterId, 11, this.ctx.clientId())) {
                    this.terminateConductor();
                    throw new AeronException("unexpected close of heartbeat timestamp counter: " + counterId);
                }
                this.heartbeatTimestamp.setRelease(nowMs);
                this.timeOfLastKeepAliveNs = nowNs;
            }
            return 1;
        }
        return 0;
    }

    private int checkLingeringResources(long nowNs) {
        int lastIndex;
        int workCount = 0;
        for (int i = lastIndex = this.lingeringLogBuffers.size() - 1; i >= 0; --i) {
            LogBuffers logBuffers = this.lingeringLogBuffers.get(i);
            if (logBuffers.lingerDeadlineNs() - nowNs >= 0L) continue;
            ArrayListUtil.fastUnorderedRemove(this.lingeringLogBuffers, (int)i, (int)lastIndex--);
            CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)logBuffers);
            ++workCount;
        }
        return workCount;
    }

    private void forceCloseResources() {
        for (Object resource : this.resourceByRegIdMap.values()) {
            if (resource instanceof Subscription) {
                Subscription subscription = (Subscription)resource;
                subscription.internalClose(-1L);
                continue;
            }
            if (resource instanceof Publication) {
                Publication publication = (Publication)resource;
                publication.internalClose();
                this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId(), -1L);
                continue;
            }
            if (!(resource instanceof Counter)) continue;
            Counter counter = (Counter)((Object)resource);
            counter.internalClose();
            this.notifyUnavailableCounterHandlers(counter.registrationId(), counter.id());
        }
        this.resourceByRegIdMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUnavailableCounterHandlers(long registrationId, int counterId) {
        for (UnavailableCounterHandler handler : this.unavailableCounterHandlerById.values()) {
            this.isInCallback = true;
            try {
                handler.onUnavailableCounter(this.countersReader, registrationId, counterId);
            }
            catch (AgentTerminationException ex) {
                if (!this.isTerminating) {
                    throw ex;
                }
                this.handleError(ex);
            }
            catch (Exception ex) {
                this.handleError(ex);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyImageUnavailable(UnavailableImageHandler handler, Image image) {
        this.isInCallback = true;
        try {
            handler.onUnavailableImage(image);
        }
        catch (AgentTerminationException ex) {
            if (!this.isTerminating) {
                throw ex;
            }
            this.handleError(ex);
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
        finally {
            this.isInCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCounterAvailable(long registrationId, int counterId, AvailableCounterHandler handler) {
        this.isInCallback = true;
        try {
            handler.onAvailableCounter(this.countersReader, registrationId, counterId);
        }
        catch (AgentTerminationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
        finally {
            this.isInCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloseHandlers() {
        for (Runnable closeHandler : this.closeHandlerByIdMap.values()) {
            this.isInCallback = true;
            try {
                closeHandler.run();
            }
            catch (Exception ex) {
                this.handleError(ex);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    private <T> T resourceOrThrow(long registrationId, Class<T> resourceClass) {
        Object resource = this.resourceByRegIdMap.get(registrationId);
        if (resourceClass.isInstance(resource)) {
            return resourceClass.cast(resource);
        }
        RegistrationException ex = (RegistrationException)this.asyncExceptionByRegIdMap.remove(registrationId);
        if (null != ex) {
            throw new RegistrationException(ex);
        }
        return null;
    }

    private static boolean isClientApiCall(long correlationId) {
        return correlationId != -1L;
    }

    static final class PendingSubscription {
        final Subscription subscription;

        private PendingSubscription(Subscription subscription) {
            this.subscription = subscription;
        }
    }
}

