/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BufferClaim {
    private final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);

    public void wrap(AtomicBuffer buffer, int offset, int length) {
        this.buffer.wrap((DirectBuffer)buffer, offset, length);
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return 32;
    }

    public int length() {
        return this.buffer.capacity() - 32;
    }

    public int headerType() {
        return this.buffer.getShort(6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public byte flags() {
        return this.buffer.getByte(5);
    }

    public BufferClaim flags(byte flags) {
        this.buffer.putByte(5, flags);
        return this;
    }

    public BufferClaim headerType(int type) {
        this.buffer.putShort(6, (short)type, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long reservedValue() {
        return this.buffer.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public BufferClaim reservedValue(long value) {
        this.buffer.putLong(24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public BufferClaim putBytes(DirectBuffer srcBuffer, int srcIndex, int length) {
        this.buffer.putBytes(32, srcBuffer, srcIndex, length);
        return this;
    }

    public void commit() {
        int frameLength = this.buffer.capacity();
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            frameLength = Integer.reverseBytes(frameLength);
        }
        this.buffer.putIntRelease(0, frameLength);
    }

    public void abort() {
        int frameLength = this.buffer.capacity();
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            frameLength = Integer.reverseBytes(frameLength);
        }
        this.buffer.putShort(6, (short)0, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putIntRelease(0, frameLength);
    }
}

