/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationByIdMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RejectImageFlyweight;
import io.aeron.command.RemoveCounterFlyweight;
import io.aeron.command.RemovePublicationFlyweight;
import io.aeron.command.RemoveSubscriptionFlyweight;
import io.aeron.command.StaticCounterMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.exceptions.AeronException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public final class DriverProxy {
    private final long clientId;
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveCounterFlyweight removeCounter = new RemoveCounterFlyweight();
    private final RemovePublicationFlyweight removePublication = new RemovePublicationFlyweight();
    private final RemoveSubscriptionFlyweight removeSubscription = new RemoveSubscriptionFlyweight();
    private final DestinationMessageFlyweight destinationMessage = new DestinationMessageFlyweight();
    private final DestinationByIdMessageFlyweight destinationByIdMessage = new DestinationByIdMessageFlyweight();
    private final CounterMessageFlyweight counterMessage = new CounterMessageFlyweight();
    private final StaticCounterMessageFlyweight staticCounterMessageFlyweight = new StaticCounterMessageFlyweight();
    private final RejectImageFlyweight rejectImage = new RejectImageFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer toDriverCommandBuffer, long clientId) {
        this.toDriverCommandBuffer = toDriverCommandBuffer;
        this.clientId = clientId;
    }

    public long timeOfLastDriverKeepaliveMs() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = PublicationMessageFlyweight.computeLength(channel.length());
        int index = this.toDriverCommandBuffer.tryClaim(1, length);
        if (index < 0) {
            throw new AeronException("could not write add publication command");
        }
        this.publicationMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).streamId(streamId).channel(channel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addExclusivePublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = PublicationMessageFlyweight.computeLength(channel.length());
        int index = this.toDriverCommandBuffer.tryClaim(3, length);
        if (index < 0) {
            throw new AeronException("could not write add exclusive publication command");
        }
        this.publicationMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).streamId(streamId).channel(channel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removePublication(long registrationId, boolean revoke) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(2, RemovePublicationFlyweight.length());
        if (index < 0) {
            throw new AeronException("could not write remove publication command");
        }
        this.removePublication.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).revoke(revoke).registrationId(registrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addSubscription(String channel, int streamId) {
        long registrationId = -1L;
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = SubscriptionMessageFlyweight.computeLength(channel.length());
        int index = this.toDriverCommandBuffer.tryClaim(4, length);
        if (index < 0) {
            throw new AeronException("could not write add subscription command");
        }
        this.subscriptionMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(-1L).streamId(streamId).channel(channel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeSubscription(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(5, RemoveSubscriptionFlyweight.length());
        if (index < 0) {
            throw new AeronException("could not write remove subscription command");
        }
        this.removeSubscription.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationId(registrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(7, length);
        if (index < 0) {
            throw new AeronException("could not write add destination command");
        }
        this.destinationMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(8, length);
        if (index < 0) {
            throw new AeronException("could not write remove destination command");
        }
        this.destinationMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeDestination(long publicationRegistrationId, long destinationRegistrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(17, 32);
        if (index < 0) {
            throw new AeronException("could not write remove destination command");
        }
        this.destinationByIdMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).resourceRegistrationId(publicationRegistrationId).destinationRegistrationId(destinationRegistrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addRcvDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(12, length);
        if (index < 0) {
            throw new AeronException("could not write add rcv destination command");
        }
        this.destinationMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeRcvDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = DestinationMessageFlyweight.computeLength(endpointChannel.length());
        int index = this.toDriverCommandBuffer.tryClaim(13, length);
        if (index < 0) {
            throw new AeronException("could not write remove rcv destination command");
        }
        this.destinationMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationCorrelationId(registrationId).channel(endpointChannel).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = CounterMessageFlyweight.computeLength(keyLength, labelLength);
        int index = this.toDriverCommandBuffer.tryClaim(9, length);
        if (index < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.counterMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).keyBuffer(keyBuffer, keyOffset, keyLength).labelBuffer(labelBuffer, labelOffset, labelLength).typeId(typeId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long addCounter(int typeId, String label) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = CounterMessageFlyweight.computeLength(0, label.length());
        int index = this.toDriverCommandBuffer.tryClaim(9, length);
        if (index < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.counterMessage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).keyBuffer(null, 0, 0).label(label).typeId(typeId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public long removeCounter(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int index = this.toDriverCommandBuffer.tryClaim(10, RemoveCounterFlyweight.length());
        if (index < 0) {
            throw new AeronException("could not write remove counter command");
        }
        this.removeCounter.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).registrationId(registrationId).clientId(this.clientId).correlationId(correlationId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public void clientClose() {
        int index = this.toDriverCommandBuffer.tryClaim(11, 16);
        if (index > 0) {
            new CorrelatedMessageFlyweight().wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).clientId(this.clientId).correlationId(-1L);
            this.toDriverCommandBuffer.commit(index);
        }
    }

    public boolean terminateDriver(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        int length = TerminateDriverFlyweight.computeLength(tokenLength);
        int index = this.toDriverCommandBuffer.tryClaim(14, length);
        if (index > 0) {
            new TerminateDriverFlyweight().wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).tokenBuffer(tokenBuffer, tokenOffset, tokenLength).clientId(this.clientId).correlationId(-1L);
            this.toDriverCommandBuffer.commit(index);
            return true;
        }
        return false;
    }

    public long rejectImage(long imageCorrelationId, long position, String reason) {
        int length = RejectImageFlyweight.computeLength(reason);
        int index = this.toDriverCommandBuffer.tryClaim(16, length);
        if (index < 0) {
            throw new AeronException("could not write reject image command");
        }
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.rejectImage.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).clientId(this.clientId).correlationId(correlationId).imageCorrelationId(imageCorrelationId).position(position).reason(reason);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    public String toString() {
        return "DriverProxy{clientId=" + this.clientId + "}";
    }

    long addStaticCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = StaticCounterMessageFlyweight.computeLength(keyLength, labelLength);
        int index = this.toDriverCommandBuffer.tryClaim(15, length);
        if (index < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.staticCounterMessageFlyweight.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).keyBuffer(keyBuffer, keyOffset, keyLength).labelBuffer(labelBuffer, labelOffset, labelLength).typeId(typeId).registrationId(registrationId).correlationId(correlationId).clientId(this.clientId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }

    long addStaticCounter(int typeId, String label, long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        int length = StaticCounterMessageFlyweight.computeLength(0, label.length());
        int index = this.toDriverCommandBuffer.tryClaim(15, length);
        if (index < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.staticCounterMessageFlyweight.wrap((MutableDirectBuffer)this.toDriverCommandBuffer.buffer(), index).keyBuffer(null, 0, 0).label(label).typeId(typeId).registrationId(registrationId).correlationId(correlationId).clientId(this.clientId);
        this.toDriverCommandBuffer.commit(index);
        return correlationId;
    }
}

