/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.Archive;
import io.aeron.cluster.ClusterBackup;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class ClusterBackupMediaDriver
implements AutoCloseable {
    private final MediaDriver driver;
    private final Archive archive;
    private final ClusterBackup clusterBackup;

    ClusterBackupMediaDriver(MediaDriver driver, Archive archive, ClusterBackup clusterBackup) {
        this.driver = driver;
        this.archive = archive;
        this.clusterBackup = clusterBackup;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        try (ClusterBackupMediaDriver driver = ClusterBackupMediaDriver.launch();){
            driver.clusterBackup().context().shutdownSignalBarrier().await();
            System.out.println("Shutdown ClusterBackupMediaDriver...");
        }
    }

    public static ClusterBackupMediaDriver launch() {
        return ClusterBackupMediaDriver.launch(new MediaDriver.Context(), new Archive.Context(), new ClusterBackup.Context());
    }

    public static ClusterBackupMediaDriver launch(MediaDriver.Context driverCtx, Archive.Context archiveCtx, ClusterBackup.Context clusterBackupCtx) {
        MediaDriver driver = null;
        Archive archive = null;
        ClusterBackup clusterBackup = null;
        try {
            driver = MediaDriver.launch((MediaDriver.Context)driverCtx.spiesSimulateConnection(true));
            int errorCounterId = SystemCounterDescriptor.ERRORS.id();
            AtomicCounter errorCounter = null == archiveCtx.errorCounter() ? new AtomicCounter((AtomicBuffer)driverCtx.countersValuesBuffer(), errorCounterId) : archiveCtx.errorCounter();
            ErrorHandler errorHandler = null == archiveCtx.errorHandler() ? driverCtx.errorHandler() : archiveCtx.errorHandler();
            archive = Archive.launch((Archive.Context)archiveCtx.aeronDirectoryName(driverCtx.aeronDirectoryName()).mediaDriverAgentInvoker(driver.sharedAgentInvoker()).errorHandler(errorHandler).errorCounter(errorCounter));
            clusterBackup = ClusterBackup.launch(clusterBackupCtx.aeronDirectoryName(driverCtx.aeronDirectoryName()));
            return new ClusterBackupMediaDriver(driver, archive, clusterBackup);
        }
        catch (Throwable throwable) {
            CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{clusterBackup, archive, driver});
            throw throwable;
        }
    }

    public MediaDriver mediaDriver() {
        return this.driver;
    }

    public Archive archive() {
        return this.archive;
    }

    public ClusterBackup clusterBackup() {
        return this.clusterBackup;
    }

    @Override
    public void close() {
        CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.clusterBackup, this.archive, this.driver});
    }
}

