/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUriStringBuilder;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.ConsensusPublisher;
import io.aeron.cluster.ElectionState;
import io.aeron.cluster.LogReplay;
import io.aeron.cluster.LogReplication;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ChangeType;
import io.aeron.cluster.service.Cluster;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.TimeoutException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.AgentTerminationException;

class Election {
    private final boolean isNodeStartup;
    private boolean isFirstInit = true;
    private boolean isLeaderStartup;
    private boolean isExtendedCanvass;
    private int logSessionId = -1;
    private long timeOfLastStateChangeNs;
    private long timeOfLastUpdateNs;
    private final long initialTimeOfLastUpdateNs;
    private long nominationDeadlineNs;
    private long logPosition;
    private long appendPosition;
    private long catchupPosition = -1L;
    private long replicationLeadershipTermId = -1L;
    private long replicationStopPosition = -1L;
    private long leaderRecordingId = -1L;
    private long leadershipTermId;
    private long logLeadershipTermId;
    private long candidateTermId;
    private ClusterMember leaderMember = null;
    private ElectionState state = ElectionState.INIT;
    private Subscription logSubscription = null;
    private LogReplay logReplay = null;
    private ClusterMember[] clusterMembers;
    private final ClusterMember thisMember;
    private final Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap;
    private final ConsensusPublisher consensusPublisher;
    private final ConsensusModule.Context ctx;
    private final ConsensusModuleAgent consensusModuleAgent;
    private LogReplication logReplication = null;
    private long replicationCommitPosition = 0L;
    private long replicationCommitPositionDeadlineNs = 0L;

    Election(boolean isNodeStartup, long leadershipTermId, long logPosition, long appendPosition, ClusterMember[] clusterMembers, Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap, ClusterMember thisMember, ConsensusPublisher consensusPublisher, ConsensusModule.Context ctx, ConsensusModuleAgent consensusModuleAgent) {
        this.isNodeStartup = isNodeStartup;
        this.isExtendedCanvass = isNodeStartup;
        this.logPosition = logPosition;
        this.appendPosition = appendPosition;
        this.logLeadershipTermId = leadershipTermId;
        this.leadershipTermId = leadershipTermId;
        this.candidateTermId = leadershipTermId;
        this.clusterMembers = clusterMembers;
        this.clusterMemberByIdMap = clusterMemberByIdMap;
        this.thisMember = thisMember;
        this.consensusPublisher = consensusPublisher;
        this.ctx = ctx;
        this.consensusModuleAgent = consensusModuleAgent;
        long nowNs = ctx.clusterClock().timeNanos();
        this.timeOfLastUpdateNs = this.initialTimeOfLastUpdateNs = nowNs - TimeUnit.DAYS.toNanos(1L);
        Objects.requireNonNull(thisMember);
        ctx.electionStateCounter().setOrdered((long)ElectionState.INIT.code());
        this.init(nowNs);
    }

    ClusterMember leader() {
        return this.leaderMember;
    }

    long leadershipTermId() {
        return this.leadershipTermId;
    }

    long logPosition() {
        return this.logPosition;
    }

    boolean isLeaderStartup() {
        return this.isLeaderStartup;
    }

    int doWork(long nowNs) {
        int workCount = ElectionState.INIT == this.state ? this.init(nowNs) : 0;
        try {
            switch (this.state) {
                case CANVASS: {
                    workCount += this.canvass(nowNs);
                    break;
                }
                case NOMINATE: {
                    workCount += this.nominate(nowNs);
                    break;
                }
                case CANDIDATE_BALLOT: {
                    workCount += this.candidateBallot(nowNs);
                    break;
                }
                case FOLLOWER_BALLOT: {
                    workCount += this.followerBallot(nowNs);
                    break;
                }
                case LEADER_LOG_REPLICATION: {
                    workCount += this.leaderLogReplication(nowNs);
                    break;
                }
                case LEADER_REPLAY: {
                    workCount += this.leaderReplay(nowNs);
                    break;
                }
                case LEADER_INIT: {
                    workCount += this.leaderInit(nowNs);
                    break;
                }
                case LEADER_READY: {
                    workCount += this.leaderReady(nowNs);
                    break;
                }
                case FOLLOWER_LOG_REPLICATION: {
                    workCount += this.followerLogReplication(nowNs);
                    break;
                }
                case FOLLOWER_REPLAY: {
                    workCount += this.followerReplay(nowNs);
                    break;
                }
                case FOLLOWER_CATCHUP_INIT: {
                    workCount += this.followerCatchupInit(nowNs);
                    break;
                }
                case FOLLOWER_CATCHUP_AWAIT: {
                    workCount += this.followerCatchupAwait(nowNs);
                    break;
                }
                case FOLLOWER_CATCHUP: {
                    workCount += this.followerCatchup(nowNs);
                    break;
                }
                case FOLLOWER_LOG_INIT: {
                    workCount += this.followerLogInit(nowNs);
                    break;
                }
                case FOLLOWER_LOG_AWAIT: {
                    workCount += this.followerLogAwait(nowNs);
                    break;
                }
                case FOLLOWER_READY: {
                    workCount += this.followerReady(nowNs);
                }
            }
        }
        catch (Throwable ex) {
            this.handleError(nowNs, ex);
        }
        return workCount;
    }

    void handleError(long nowNs, Throwable ex) {
        this.ctx.countedErrorHandler().onError(ex);
        this.logPosition = this.ctx.commitPositionCounter().getWeak();
        this.state(ElectionState.INIT, nowNs);
        if (ex instanceof AgentTerminationException || ex instanceof InterruptedException) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    void onRecordingSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (null != this.logReplication) {
            this.logReplication.onSignal(correlationId, recordingId, position, signal);
            this.consensusModuleAgent.logRecordingId(this.logReplication.recordingId());
        }
    }

    void onMembershipChange(ClusterMember[] clusterMembers, ChangeType changeType, int memberId, long logPosition) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        ClusterMember.copyVotes(this.clusterMembers, clusterMembers);
        this.clusterMembers = clusterMembers;
        if (ChangeType.QUIT == changeType && ElectionState.FOLLOWER_CATCHUP == this.state && this.leaderMember.id() == memberId) {
            this.logPosition = logPosition;
            this.state(ElectionState.INIT, this.ctx.clusterClock().timeNanos());
        }
    }

    void onCanvassPosition(long logLeadershipTermId, long logPosition, long leadershipTermId, int followerMemberId) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        ClusterMember follower = (ClusterMember)this.clusterMemberByIdMap.get(followerMemberId);
        if (null != follower && this.thisMember.id() != followerMemberId) {
            follower.leadershipTermId(logLeadershipTermId).logPosition(logPosition);
            if (logLeadershipTermId < this.leadershipTermId) {
                switch (this.state) {
                    case LEADER_LOG_REPLICATION: 
                    case LEADER_REPLAY: 
                    case LEADER_INIT: 
                    case LEADER_READY: {
                        this.publishNewLeadershipTerm(follower, logLeadershipTermId, this.ctx.clusterClock().timeNanos());
                    }
                }
            } else if (logLeadershipTermId > this.leadershipTermId) {
                switch (this.state) {
                    case LEADER_LOG_REPLICATION: 
                    case LEADER_READY: {
                        throw new ClusterException("potential new election in progress", AeronException.Category.WARN);
                    }
                }
            }
        }
    }

    void onRequestVote(long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (this.isPassiveMember() || candidateId == this.thisMember.id()) {
            return;
        }
        if (candidateTermId <= this.candidateTermId) {
            this.placeVote(candidateTermId, candidateId, false);
        } else if (ClusterMember.compareLog(this.logLeadershipTermId, this.appendPosition, logLeadershipTermId, logPosition) > 0) {
            this.candidateTermId = this.ctx.clusterMarkFile().proposeMaxCandidateTermId(candidateTermId, this.ctx.fileSyncLevel());
            this.placeVote(candidateTermId, candidateId, false);
            this.state(ElectionState.INIT, this.ctx.clusterClock().timeNanos());
        } else if (ElectionState.CANVASS == this.state || ElectionState.NOMINATE == this.state || ElectionState.CANDIDATE_BALLOT == this.state || ElectionState.FOLLOWER_BALLOT == this.state) {
            this.candidateTermId = this.ctx.clusterMarkFile().proposeMaxCandidateTermId(candidateTermId, this.ctx.fileSyncLevel());
            this.placeVote(candidateTermId, candidateId, true);
            this.state(ElectionState.FOLLOWER_BALLOT, this.ctx.clusterClock().timeNanos());
        }
    }

    void onVote(long candidateTermId, long logLeadershipTermId, long logPosition, int candidateMemberId, int followerMemberId, boolean vote) {
        ClusterMember follower;
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (ElectionState.CANDIDATE_BALLOT == this.state && candidateTermId == this.candidateTermId && candidateMemberId == this.thisMember.id() && null != (follower = (ClusterMember)this.clusterMemberByIdMap.get(followerMemberId))) {
            follower.candidateTermId(candidateTermId).leadershipTermId(logLeadershipTermId).logPosition(logPosition).vote(vote ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onNewLeadershipTerm(long logLeadershipTermId, long nextLeadershipTermId, long nextTermBaseLogPosition, long nextLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long leaderRecordingId, long timestamp, int leaderMemberId, int logSessionId, boolean isStartup) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        ClusterMember leader = (ClusterMember)this.clusterMemberByIdMap.get(leaderMemberId);
        if (null == leader || leaderMemberId == this.thisMember.id() && leadershipTermId == this.leadershipTermId) {
            return;
        }
        if ((ElectionState.FOLLOWER_BALLOT != this.state && ElectionState.CANDIDATE_BALLOT != this.state || leadershipTermId != this.candidateTermId) && ElectionState.CANVASS != this.state) return;
        if (this.logLeadershipTermId == logLeadershipTermId) {
            if (-1L != nextTermBaseLogPosition && nextTermBaseLogPosition < this.appendPosition) {
                this.consensusModuleAgent.truncateLogEntry(logLeadershipTermId, nextTermBaseLogPosition);
                this.appendPosition = this.consensusModuleAgent.prepareForNewLeadership(nextTermBaseLogPosition);
            }
            this.leaderMember = leader;
            this.isLeaderStartup = isStartup;
            this.leadershipTermId = leadershipTermId;
            this.candidateTermId = Math.max(leadershipTermId, this.candidateTermId);
            this.logSessionId = logSessionId;
            this.leaderRecordingId = leaderRecordingId;
            long l = this.catchupPosition = this.appendPosition < logPosition ? logPosition : -1L;
            if (this.appendPosition < termBaseLogPosition) {
                if (-1L == nextLeadershipTermId) throw new ClusterException("invalid newLeadershipTerm - this.appendPosition=" + this.appendPosition + " < termBaseLogPosition = " + termBaseLogPosition + " and nextLeadershipTermId = " + nextLeadershipTermId + ", logLeadershipTermId = " + logLeadershipTermId + ", nextTermBaseLogPosition = " + nextTermBaseLogPosition + ", nextLogPosition = " + nextLogPosition + ", leadershipTermId = " + leadershipTermId + ", termBaseLogPosition = " + termBaseLogPosition + ", logPosition = " + logPosition + ", leaderRecordingId = " + leaderRecordingId + ", timestamp = " + timestamp + ", leaderMemberId = " + leaderMemberId + ", logSessionId = " + logSessionId + ", isStartup = " + isStartup);
                if (this.appendPosition < nextTermBaseLogPosition) {
                    this.replicationLeadershipTermId = logLeadershipTermId;
                    this.replicationStopPosition = nextTermBaseLogPosition;
                    this.state(ElectionState.FOLLOWER_LOG_REPLICATION, this.ctx.clusterClock().timeNanos());
                    return;
                } else {
                    if (this.appendPosition != nextTermBaseLogPosition || -1L == nextLogPosition) return;
                    this.replicationLeadershipTermId = nextLeadershipTermId;
                    this.replicationStopPosition = nextLogPosition;
                    this.state(ElectionState.FOLLOWER_LOG_REPLICATION, this.ctx.clusterClock().timeNanos());
                }
                return;
            } else {
                this.state(ElectionState.FOLLOWER_REPLAY, this.ctx.clusterClock().timeNanos());
            }
            return;
        } else {
            this.state(ElectionState.CANVASS, this.ctx.clusterClock().timeNanos());
        }
    }

    void onAppendPosition(long leadershipTermId, long logPosition, int followerMemberId) {
        ClusterMember follower;
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (leadershipTermId <= this.leadershipTermId && null != (follower = (ClusterMember)this.clusterMemberByIdMap.get(followerMemberId))) {
            follower.leadershipTermId(leadershipTermId).logPosition(logPosition).timeOfLastAppendPositionNs(this.ctx.clusterClock().timeNanos());
            this.consensusModuleAgent.trackCatchupCompletion(follower, leadershipTermId);
        }
    }

    void onCommitPosition(long leadershipTermId, long logPosition, int leaderMemberId) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (leadershipTermId == this.leadershipTermId && -1L != this.catchupPosition && ElectionState.FOLLOWER_CATCHUP == this.state && leaderMemberId == this.leaderMember.id()) {
            this.catchupPosition = Math.max(this.catchupPosition, logPosition);
        } else if (ElectionState.FOLLOWER_LOG_REPLICATION == this.state && leaderMemberId == this.leaderMember.id()) {
            this.replicationCommitPosition = Math.max(this.replicationCommitPosition, logPosition);
            this.replicationCommitPositionDeadlineNs = this.ctx.clusterClock().timeNanos() + this.ctx.leaderHeartbeatTimeoutNs();
        } else if (leadershipTermId > this.leadershipTermId && ElectionState.LEADER_READY == this.state) {
            throw new ClusterException("new leader detected", AeronException.Category.WARN);
        }
    }

    void onReplayNewLeadershipTermEvent(long logRecordingId, long leadershipTermId, long logPosition, long timestamp, long termBaseLogPosition) {
        if (ElectionState.INIT == this.state) {
            return;
        }
        if (ElectionState.FOLLOWER_CATCHUP == this.state || ElectionState.FOLLOWER_REPLAY == this.state) {
            for (long termId = Math.max(this.logLeadershipTermId, 0L); termId <= leadershipTermId; ++termId) {
                RecordingLog recordingLog = this.ctx.recordingLog();
                if (!recordingLog.isUnknown(termId - 1L)) {
                    recordingLog.commitLogPosition(termId - 1L, termBaseLogPosition);
                    recordingLog.force(this.ctx.fileSyncLevel());
                }
                if (!recordingLog.isUnknown(termId)) continue;
                recordingLog.appendTerm(logRecordingId, termId, termBaseLogPosition, timestamp);
                recordingLog.force(this.ctx.fileSyncLevel());
            }
            this.logLeadershipTermId = leadershipTermId;
            this.logPosition = logPosition;
        }
    }

    private int init(long nowNs) {
        if (this.isFirstInit) {
            this.isFirstInit = false;
            if (!this.isNodeStartup) {
                this.appendPosition = this.consensusModuleAgent.prepareForNewLeadership(this.logPosition);
            }
        } else {
            this.cleanupLogReplication();
            this.resetCatchup();
            this.appendPosition = this.consensusModuleAgent.prepareForNewLeadership(this.logPosition);
            this.logSessionId = -1;
            this.cleanupReplay();
            CloseHelper.close((AutoCloseable)this.logSubscription);
            this.logSubscription = null;
        }
        this.candidateTermId = Math.max(this.ctx.clusterMarkFile().candidateTermId(), this.leadershipTermId);
        if (this.clusterMembers.length == 1 && this.thisMember.id() == this.clusterMembers[0].id()) {
            this.leadershipTermId = this.candidateTermId = Math.max(this.leadershipTermId + 1L, this.candidateTermId + 1L);
            this.leaderMember = this.thisMember;
            this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs);
        } else {
            this.state(ElectionState.CANVASS, nowNs);
        }
        return 1;
    }

    private int canvass(long nowNs) {
        int workCount = 0;
        if (this.hasIntervalExpired(nowNs, this.ctx.electionStatusIntervalNs())) {
            this.timeOfLastUpdateNs = nowNs;
            for (ClusterMember member : this.clusterMembers) {
                if (member.id() == this.thisMember.id()) continue;
                this.consensusPublisher.canvassPosition(member.publication(), this.logLeadershipTermId, this.appendPosition, this.leadershipTermId, this.thisMember.id());
            }
            ++workCount;
        }
        if (this.isPassiveMember() || this.ctx.appointedLeaderId() != -1 && this.ctx.appointedLeaderId() != this.thisMember.id()) {
            return workCount;
        }
        long canvassDeadlineNs = this.timeOfLastStateChangeNs + (this.isExtendedCanvass ? this.ctx.startupCanvassTimeoutNs() : this.ctx.electionTimeoutNs());
        if (ClusterMember.isUnanimousCandidate(this.clusterMembers, this.thisMember) || ClusterMember.isQuorumCandidate(this.clusterMembers, this.thisMember) && nowNs >= canvassDeadlineNs) {
            long delayNs = (long)(this.ctx.random().nextDouble() * (double)(this.ctx.electionTimeoutNs() >> 1));
            this.nominationDeadlineNs = nowNs + delayNs;
            this.state(ElectionState.NOMINATE, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int nominate(long nowNs) {
        if (nowNs >= this.nominationDeadlineNs) {
            this.candidateTermId = this.ctx.clusterMarkFile().proposeMaxCandidateTermId(this.candidateTermId + 1L, this.ctx.fileSyncLevel());
            ClusterMember.becomeCandidate(this.clusterMembers, this.candidateTermId, this.thisMember.id());
            this.state(ElectionState.CANDIDATE_BALLOT, nowNs);
            return 1;
        }
        return 0;
    }

    private int candidateBallot(long nowNs) {
        int workCount = 0;
        if (ClusterMember.hasWonVoteOnFullCount(this.clusterMembers, this.candidateTermId) || ClusterMember.hasMajorityVoteWithCanvassMembers(this.clusterMembers, this.candidateTermId)) {
            this.leaderMember = this.thisMember;
            this.leadershipTermId = this.candidateTermId;
            this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs);
            ++workCount;
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.electionTimeoutNs()) {
            if (ClusterMember.hasMajorityVote(this.clusterMembers, this.candidateTermId)) {
                this.leaderMember = this.thisMember;
                this.leadershipTermId = this.candidateTermId;
                this.state(ElectionState.LEADER_LOG_REPLICATION, nowNs);
            } else {
                this.state(ElectionState.CANVASS, nowNs);
            }
            ++workCount;
        } else {
            for (ClusterMember member : this.clusterMembers) {
                if (member.isBallotSent()) continue;
                ++workCount;
                member.isBallotSent(this.consensusPublisher.requestVote(member.publication(), this.logLeadershipTermId, this.appendPosition, this.candidateTermId, this.thisMember.id()));
            }
        }
        return workCount;
    }

    private int followerBallot(long nowNs) {
        int workCount = 0;
        if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.electionTimeoutNs()) {
            this.state(ElectionState.CANVASS, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int leaderLogReplication(long nowNs) {
        int workCount = 0;
        workCount += this.consensusModuleAgent.updateLeaderPosition(nowNs, this.appendPosition);
        workCount += this.publishNewLeadershipTermOnInterval(nowNs);
        if (this.ctx.commitPositionCounter().getWeak() >= this.appendPosition) {
            ++workCount;
            this.state(ElectionState.LEADER_REPLAY, nowNs);
        }
        return workCount;
    }

    private int leaderReplay(long nowNs) {
        int workCount = 0;
        if (null == this.logReplay) {
            if (this.logPosition < this.appendPosition) {
                this.ctx.commitPositionCounter().setOrdered(this.logPosition);
                this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition, this.appendPosition);
            } else {
                this.state(ElectionState.LEADER_INIT, nowNs);
            }
            ++workCount;
            this.isLeaderStartup = this.isNodeStartup;
            ClusterMember.resetLogPositions(this.clusterMembers, -1L);
            this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.appendPosition);
        } else {
            workCount += this.logReplay.doWork();
            if (this.logReplay.isDone()) {
                this.cleanupReplay();
                this.logPosition = this.appendPosition;
                this.state(ElectionState.LEADER_INIT, nowNs);
            }
        }
        return workCount += this.publishNewLeadershipTermOnInterval(nowNs);
    }

    private int leaderInit(long nowNs) {
        this.consensusModuleAgent.joinLogAsLeader(this.leadershipTermId, this.logPosition, this.logSessionId, this.isLeaderStartup);
        this.updateRecordingLog(nowNs);
        this.state(ElectionState.LEADER_READY, nowNs);
        return 1;
    }

    private int leaderReady(long nowNs) {
        int workCount = this.consensusModuleAgent.updateLeaderPosition(nowNs, this.appendPosition);
        workCount += this.publishNewLeadershipTermOnInterval(nowNs);
        if (ClusterMember.haveVotersReachedPosition(this.clusterMembers, this.logPosition, this.leadershipTermId)) {
            if (this.consensusModuleAgent.electionComplete()) {
                this.state(ElectionState.CLOSED, nowNs);
                ++workCount;
            }
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs() && ClusterMember.haveQuorumReachedPosition(this.clusterMembers, this.logPosition, this.leadershipTermId) && this.consensusModuleAgent.electionComplete()) {
            this.state(ElectionState.CLOSED, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int followerLogReplication(long nowNs) {
        int workCount = 0;
        if (null == this.logReplication) {
            if (this.appendPosition < this.replicationStopPosition) {
                this.logReplication = this.consensusModuleAgent.newLogReplication(this.leaderMember.archiveEndpoint(), this.leaderRecordingId, this.replicationStopPosition, nowNs);
                this.replicationCommitPositionDeadlineNs = nowNs + this.ctx.leaderHeartbeatTimeoutNs();
                ++workCount;
            } else {
                this.updateRecordingLogForReplication(this.replicationLeadershipTermId, this.replicationStopPosition, nowNs);
                this.state(ElectionState.CANVASS, nowNs);
            }
        } else {
            workCount += this.consensusModuleAgent.pollArchiveEvents();
            workCount += this.publishFollowerReplicationPosition(nowNs);
            if (this.logReplication.isDone(nowNs)) {
                if (this.replicationCommitPosition >= this.appendPosition) {
                    this.appendPosition = this.logReplication.position();
                    this.cleanupLogReplication();
                    this.updateRecordingLogForReplication(this.replicationLeadershipTermId, this.replicationStopPosition, nowNs);
                    this.state(ElectionState.CANVASS, nowNs);
                    ++workCount;
                } else if (nowNs >= this.replicationCommitPositionDeadlineNs) {
                    throw new TimeoutException("timeout awaiting commit position", AeronException.Category.WARN);
                }
            }
        }
        return workCount;
    }

    private int followerReplay(long nowNs) {
        int workCount = 0;
        if (null == this.logReplay) {
            ++workCount;
            if (this.logPosition < this.appendPosition) {
                this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition, this.appendPosition);
            } else {
                this.state(-1L != this.catchupPosition ? ElectionState.FOLLOWER_CATCHUP_INIT : ElectionState.FOLLOWER_LOG_INIT, nowNs);
            }
        } else {
            workCount += this.logReplay.doWork();
            if (this.logReplay.isDone()) {
                this.cleanupReplay();
                this.logPosition = this.appendPosition;
                this.state(-1L != this.catchupPosition ? ElectionState.FOLLOWER_CATCHUP_INIT : ElectionState.FOLLOWER_LOG_INIT, nowNs);
            }
        }
        return workCount;
    }

    private int followerCatchupInit(long nowNs) {
        if (null == this.logSubscription) {
            this.logSubscription = this.addFollowerSubscription();
            this.addCatchupLogDestination();
        }
        String catchupEndpoint = null;
        String endpoint = this.thisMember.catchupEndpoint();
        if (endpoint.endsWith(":0")) {
            String resolvedEndpoint = this.logSubscription.resolvedEndpoint();
            if (null != resolvedEndpoint) {
                int i = resolvedEndpoint.lastIndexOf(58);
                catchupEndpoint = endpoint.substring(0, endpoint.length() - 2) + resolvedEndpoint.substring(i);
            }
        } else {
            catchupEndpoint = endpoint;
        }
        if (null != catchupEndpoint && this.sendCatchupPosition(catchupEndpoint)) {
            this.timeOfLastUpdateNs = nowNs;
            this.consensusModuleAgent.catchupInitiated(nowNs);
            this.state(ElectionState.FOLLOWER_CATCHUP_AWAIT, nowNs);
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("failed to send catchup position", AeronException.Category.WARN);
        }
        return 1;
    }

    private int followerCatchupAwait(long nowNs) {
        int workCount = 0;
        Image image = this.logSubscription.imageBySessionId(this.logSessionId);
        if (null != image) {
            this.verifyLogImage(image);
            this.consensusModuleAgent.joinLogAsFollower(image, this.isLeaderStartup);
            this.state(ElectionState.FOLLOWER_CATCHUP, nowNs);
            ++workCount;
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("failed to join catchup log", AeronException.Category.WARN);
        }
        return workCount;
    }

    private int followerCatchup(long nowNs) {
        long position;
        int workCount = this.consensusModuleAgent.catchupPoll(this.catchupPosition, nowNs);
        if (null == this.consensusModuleAgent.liveLogDestination() && this.consensusModuleAgent.isCatchupNearLive(this.catchupPosition)) {
            this.addLiveLogDestination();
            ++workCount;
        }
        if ((position = this.ctx.commitPositionCounter().getWeak()) >= this.catchupPosition && null == this.consensusModuleAgent.catchupLogDestination() && ConsensusModule.State.SNAPSHOT != this.consensusModuleAgent.state()) {
            this.appendPosition = position;
            this.logPosition = position;
            this.state(ElectionState.FOLLOWER_LOG_INIT, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int followerLogInit(long nowNs) {
        if (null == this.logSubscription) {
            if (-1 != this.logSessionId) {
                this.logSubscription = this.addFollowerSubscription();
                this.addLiveLogDestination();
                this.state(ElectionState.FOLLOWER_LOG_AWAIT, nowNs);
            }
        } else {
            this.state(ElectionState.FOLLOWER_READY, nowNs);
        }
        return 1;
    }

    private int followerLogAwait(long nowNs) {
        int workCount = 0;
        Image image = this.logSubscription.imageBySessionId(this.logSessionId);
        if (null != image) {
            this.verifyLogImage(image);
            if (this.consensusModuleAgent.tryJoinLogAsFollower(image, this.isLeaderStartup)) {
                this.appendPosition = image.joinPosition();
                this.logPosition = image.joinPosition();
                this.updateRecordingLog(nowNs);
                this.state(ElectionState.FOLLOWER_READY, nowNs);
                ++workCount;
            } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
                throw new TimeoutException("failed to join live log", AeronException.Category.WARN);
            }
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("failed to join live log", AeronException.Category.WARN);
        }
        return workCount;
    }

    private int followerReady(long nowNs) {
        if (this.consensusPublisher.appendPosition(this.leaderMember.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id())) {
            this.consensusModuleAgent.leadershipTermId(this.leadershipTermId);
            if (this.consensusModuleAgent.electionComplete()) {
                this.state(ElectionState.CLOSED, nowNs);
            }
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("ready follower failed to notify leader", AeronException.Category.WARN);
        }
        return 1;
    }

    private void placeVote(long candidateTermId, int candidateId, boolean vote) {
        ClusterMember candidate = (ClusterMember)this.clusterMemberByIdMap.get(candidateId);
        if (null != candidate) {
            this.consensusPublisher.placeVote(candidate.publication(), candidateTermId, this.logLeadershipTermId, this.appendPosition, candidateId, this.thisMember.id(), vote);
        }
    }

    private int publishNewLeadershipTermOnInterval(long nowNs) {
        int workCount = 0;
        if (this.hasIntervalExpired(nowNs, this.ctx.leaderHeartbeatIntervalNs())) {
            this.timeOfLastUpdateNs = nowNs;
            this.publishNewLeadershipTerm(this.ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS));
            ++workCount;
        }
        return workCount;
    }

    private void publishNewLeadershipTerm(long timestamp) {
        for (ClusterMember member : this.clusterMembers) {
            this.publishNewLeadershipTerm(member, this.logLeadershipTermId, timestamp);
        }
    }

    private void publishNewLeadershipTerm(ClusterMember member, long logLeadershipTermId, long timestamp) {
        if (member.id() != this.thisMember.id() && -1 != this.logSessionId) {
            long nextTermBaseLogPosition;
            RecordingLog.Entry logNextTermEntry = this.ctx.recordingLog().findTermEntry(logLeadershipTermId + 1L);
            long nextLeadershipTermId = null != logNextTermEntry ? logNextTermEntry.leadershipTermId : this.leadershipTermId;
            long l = nextTermBaseLogPosition = null != logNextTermEntry ? logNextTermEntry.termBaseLogPosition : this.appendPosition;
            long nextLogPosition = null != logNextTermEntry ? (-1L != logNextTermEntry.logPosition ? logNextTermEntry.logPosition : this.appendPosition) : -1L;
            this.consensusPublisher.newLeadershipTerm(member.publication(), logLeadershipTermId, nextLeadershipTermId, nextTermBaseLogPosition, nextLogPosition, this.leadershipTermId, this.appendPosition, this.appendPosition, this.consensusModuleAgent.logRecordingId(), timestamp, this.thisMember.id(), this.logSessionId, this.isLeaderStartup);
        }
    }

    private int publishFollowerReplicationPosition(long nowNs) {
        long position = this.logReplication.position();
        if (position > this.appendPosition && this.hasIntervalExpired(nowNs, this.ctx.leaderHeartbeatIntervalNs()) && this.consensusPublisher.appendPosition(this.leaderMember.publication(), this.leadershipTermId, position, this.thisMember.id())) {
            this.appendPosition = position;
            this.timeOfLastUpdateNs = nowNs;
            return 1;
        }
        return 0;
    }

    private boolean sendCatchupPosition(String catchupEndpoint) {
        return this.consensusPublisher.catchupPosition(this.leaderMember.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id(), catchupEndpoint);
    }

    private void addCatchupLogDestination() {
        String destination = "aeron:udp?endpoint=" + this.thisMember.catchupEndpoint();
        this.logSubscription.addDestination(destination);
        this.consensusModuleAgent.catchupLogDestination(destination);
    }

    private void addLiveLogDestination() {
        String destination = this.ctx.isLogMdc() ? "aeron:udp?endpoint=" + this.thisMember.logEndpoint() : this.ctx.logChannel();
        this.logSubscription.addDestination(destination);
        this.consensusModuleAgent.liveLogDestination(destination);
    }

    private Subscription addFollowerSubscription() {
        String channel = new ChannelUriStringBuilder().media("udp").tags(this.ctx.aeron().nextCorrelationId() + "," + this.ctx.aeron().nextCorrelationId()).controlMode("manual").sessionId(Integer.valueOf(this.logSessionId)).group(Boolean.TRUE).rejoin(Boolean.FALSE).alias("log").build();
        return this.ctx.aeron().addSubscription(channel, this.ctx.logStreamId());
    }

    private void state(ElectionState newState, long nowNs) {
        if (newState != this.state) {
            this.stateChange(this.state, newState, this.thisMember.id());
            if (ElectionState.CANVASS == this.state) {
                this.isExtendedCanvass = false;
            }
            switch (newState) {
                case CANVASS: {
                    this.resetMembers();
                    this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
                    break;
                }
                case CANDIDATE_BALLOT: {
                    this.consensusModuleAgent.role(Cluster.Role.CANDIDATE);
                    break;
                }
                case LEADER_LOG_REPLICATION: {
                    this.logSessionId = this.consensusModuleAgent.addLogPublication();
                    break;
                }
                case LEADER_INIT: {
                    this.consensusModuleAgent.role(Cluster.Role.LEADER);
                    break;
                }
                case FOLLOWER_LOG_REPLICATION: 
                case FOLLOWER_REPLAY: {
                    this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
                }
            }
            this.state = newState;
            this.ctx.electionStateCounter().setOrdered((long)newState.code());
            this.timeOfLastStateChangeNs = nowNs;
            this.timeOfLastUpdateNs = this.initialTimeOfLastUpdateNs;
        }
    }

    private void resetCatchup() {
        this.consensusModuleAgent.stopAllCatchups();
        this.catchupPosition = -1L;
    }

    private void resetMembers() {
        ClusterMember.reset(this.clusterMembers);
        this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.appendPosition);
        this.leaderMember = null;
    }

    private void cleanupReplay() {
        if (null != this.logReplay) {
            this.logReplay.close();
            this.logReplay = null;
        }
    }

    private void cleanupLogReplication() {
        if (null != this.logReplication) {
            this.logReplication.close();
            this.logReplication = null;
        }
        this.replicationCommitPosition = 0L;
        this.replicationCommitPositionDeadlineNs = 0L;
    }

    private boolean isPassiveMember() {
        return null == ClusterMember.findMember(this.clusterMembers, this.thisMember.id());
    }

    private void updateRecordingLog(long nowNs) {
        RecordingLog recordingLog = this.ctx.recordingLog();
        long timestamp = this.ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS);
        long recordingId = this.consensusModuleAgent.logRecordingId();
        if (-1L == recordingId) {
            throw new AgentTerminationException("log recording id not found");
        }
        for (long termId = this.logLeadershipTermId + 1L; termId <= this.leadershipTermId; ++termId) {
            if (!recordingLog.isUnknown(termId)) continue;
            recordingLog.appendTerm(recordingId, termId, this.logPosition, timestamp);
            recordingLog.force(this.ctx.fileSyncLevel());
            this.logLeadershipTermId = termId;
        }
    }

    private void updateRecordingLogForReplication(long leadershipTermId, long logPosition, long nowNs) {
        RecordingLog recordingLog = this.ctx.recordingLog();
        long timestamp = this.ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS);
        long recordingId = this.consensusModuleAgent.logRecordingId();
        if (-1L == recordingId) {
            throw new AgentTerminationException("log recording id not found");
        }
        long termId = this.logLeadershipTermId + 1L;
        while (termId <= leadershipTermId) {
            if (recordingLog.isUnknown(termId)) {
                RecordingLog.Entry lastTerm = recordingLog.findLastTerm();
                long termBaseLogPosition = null != lastTerm ? lastTerm.logPosition : 0L;
                recordingLog.appendTerm(recordingId, termId, termBaseLogPosition, timestamp);
            }
            recordingLog.commitLogPosition(termId, logPosition);
            recordingLog.force(this.ctx.fileSyncLevel());
            this.logLeadershipTermId = termId++;
        }
    }

    private void verifyLogImage(Image image) {
        if (image.joinPosition() != this.logPosition) {
            throw new ClusterException("joinPosition=" + image.joinPosition() + " != logPosition=" + this.logPosition, AeronException.Category.WARN);
        }
    }

    private boolean hasIntervalExpired(long nowNs, long intervalNs) {
        return nowNs - this.timeOfLastUpdateNs >= intervalNs;
    }

    void stateChange(ElectionState oldState, ElectionState newState, int memberId) {
    }

    public String toString() {
        return "Election{isNodeStartup=" + this.isNodeStartup + ", isLeaderStartup=" + this.isLeaderStartup + ", isExtendedCanvass=" + this.isExtendedCanvass + ", logSessionId=" + this.logSessionId + ", timeOfLastStateChangeNs=" + this.timeOfLastStateChangeNs + ", timeOfLastUpdateNs=" + this.timeOfLastUpdateNs + ", nominationDeadlineNs=" + this.nominationDeadlineNs + ", logPosition=" + this.logPosition + ", appendPosition=" + this.appendPosition + ", catchupPosition=" + this.catchupPosition + ", logReplicationPosition=" + this.replicationStopPosition + ", leaderRecordingId=" + this.leaderRecordingId + ", leadershipTermId=" + this.leadershipTermId + ", logLeadershipTermId=" + this.logLeadershipTermId + ", candidateTermId=" + this.candidateTermId + ", leaderMember=" + this.leaderMember + ", state=" + (Object)((Object)this.state) + ", logSubscription=" + this.logSubscription + ", logReplay=" + this.logReplay + ", clusterMembers=" + Arrays.toString(this.clusterMembers) + ", thisMember=" + this.thisMember + ", clusterMemberByIdMap=" + this.clusterMemberByIdMap + ", logReplication=" + this.logReplication + ", ctx=" + this.ctx + '}';
    }
}

