/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.VoteDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class VoteEncoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 52;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 7;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final VoteEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 52;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 7;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public VoteEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 36);
        return this;
    }

    public VoteEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(36).templateId(52).schemaId(111).version(7);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int candidateTermIdId() {
        return 1;
    }

    public static int candidateTermIdSinceVersion() {
        return 0;
    }

    public static int candidateTermIdEncodingOffset() {
        return 0;
    }

    public static int candidateTermIdEncodingLength() {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long candidateTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long candidateTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public VoteEncoder candidateTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logLeadershipTermIdId() {
        return 2;
    }

    public static int logLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset() {
        return 8;
    }

    public static int logLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public VoteEncoder logLeadershipTermId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logPositionId() {
        return 3;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 16;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public VoteEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int candidateMemberIdId() {
        return 4;
    }

    public static int candidateMemberIdSinceVersion() {
        return 0;
    }

    public static int candidateMemberIdEncodingOffset() {
        return 24;
    }

    public static int candidateMemberIdEncodingLength() {
        return 4;
    }

    public static String candidateMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int candidateMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int candidateMemberIdMinValue() {
        return -2147483647;
    }

    public static int candidateMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public VoteEncoder candidateMemberId(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int followerMemberIdId() {
        return 5;
    }

    public static int followerMemberIdSinceVersion() {
        return 0;
    }

    public static int followerMemberIdEncodingOffset() {
        return 28;
    }

    public static int followerMemberIdEncodingLength() {
        return 4;
    }

    public static String followerMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int followerMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int followerMemberIdMinValue() {
        return -2147483647;
    }

    public static int followerMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public VoteEncoder followerMemberId(int value) {
        this.buffer.putInt(this.offset + 28, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int voteId() {
        return 6;
    }

    public static int voteSinceVersion() {
        return 0;
    }

    public static int voteEncodingOffset() {
        return 32;
    }

    public static int voteEncodingLength() {
        return 4;
    }

    public static String voteMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public VoteEncoder vote(BooleanType value) {
        this.buffer.putInt(this.offset + 32, value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        VoteDecoder decoder = new VoteDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 36, 7);
        return decoder.appendTo(builder);
    }
}

