/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.Counter;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ClusterCounters {
    private ClusterCounters() {
    }

    public static Counter allocate(Aeron aeron, String name, int typeId, int clusterId) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        int index = 0;
        buffer.putInt(index, clusterId);
        index += 4;
        index += buffer.putStringWithoutLengthAscii(index, name);
        index += buffer.putStringWithoutLengthAscii(index, " - clusterId=");
        index += buffer.putIntAscii(index, clusterId);
        return aeron.addCounter(typeId, (DirectBuffer)buffer, 0, 4, (DirectBuffer)buffer, 4, index - 4);
    }

    public static int find(CountersReader counters, int typeId, int clusterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = counters.getCounterState(i);
            if (counterState == 1) {
                if (counters.getCounterTypeId(i) != typeId || buffer.getInt(CountersReader.metaDataOffset((int)i) + 16) != clusterId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }
}

