/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.DirectBufferVector;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CancelTimerEncoder;
import io.aeron.cluster.codecs.CloseSessionEncoder;
import io.aeron.cluster.codecs.ClusterMembersQueryEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.RemoveMemberEncoder;
import io.aeron.cluster.codecs.ScheduleTimerEncoder;
import io.aeron.cluster.codecs.ServiceAckEncoder;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

public final class ConsensusModuleProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 3;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ScheduleTimerEncoder scheduleTimerEncoder = new ScheduleTimerEncoder();
    private final CancelTimerEncoder cancelTimerEncoder = new CancelTimerEncoder();
    private final ServiceAckEncoder serviceAckEncoder = new ServiceAckEncoder();
    private final CloseSessionEncoder closeSessionEncoder = new CloseSessionEncoder();
    private final ClusterMembersQueryEncoder clusterMembersQueryEncoder = new ClusterMembersQueryEncoder();
    private final RemoveMemberEncoder removeMemberEncoder = new RemoveMemberEncoder();
    private final Publication publication;

    public ConsensusModuleProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.publication);
    }

    boolean scheduleTimer(long correlationId, long deadline) {
        int length = 24;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) {
                this.scheduleTimerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).deadline(deadline);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean cancelTimer(long correlationId) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.cancelTimerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    long offer(DirectBuffer headerBuffer, int headerOffset, int headerLength, DirectBuffer messageBuffer, int messageOffset, int messageLength) {
        return this.publication.offer(headerBuffer, headerOffset, headerLength, messageBuffer, messageOffset, messageLength);
    }

    long offer(DirectBufferVector[] vectors) {
        return this.publication.offer(vectors, null);
    }

    long tryClaim(int length, BufferClaim bufferClaim, DirectBuffer sessionHeader) {
        long result = this.publication.tryClaim(length, bufferClaim);
        if (result > 0L) {
            bufferClaim.putBytes(sessionHeader, 0, 32);
        }
        return result;
    }

    boolean ack(long logPosition, long timestamp, long ackId, long relevantId, int serviceId) {
        int length = 44;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(44, this.bufferClaim)) > 0L) {
                this.serviceAckEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition).timestamp(timestamp).ackId(ackId).relevantId(relevantId).serviceId(serviceId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean closeSession(long clusterSessionId) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.closeSessionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(clusterSessionId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    public boolean clusterMembersQuery(long correlationId) {
        int length = 20;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(20, this.bufferClaim)) > 0L) {
                this.clusterMembersQueryEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).extended(BooleanType.TRUE);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    public boolean removeMember(int memberId, BooleanType isPassive) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.removeMemberEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).memberId(memberId).isPassive(isPassive);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new ClusterException("unexpected publication state: " + result);
        }
    }
}

