/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.Counter;
import io.aeron.ExclusivePublication;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ControlResponsePoller;
import io.aeron.archive.client.RecordingSignalPoller;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import io.aeron.cluster.ClusterBackup;
import io.aeron.cluster.ClusterBackupEventsListener;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusPublisher;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.SnapshotReplication;
import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BackupResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.TimeoutException;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.CountersReader;

public final class ClusterBackupAgent
implements Agent {
    public static final long MARK_FILE_UPDATE_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final int SLOW_TICK_INTERVAL_MS = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final BackupResponseDecoder backupResponseDecoder = new BackupResponseDecoder();
    private final ClusterBackup.Context ctx;
    private final ClusterMarkFile markFile;
    private final AgentInvoker aeronClientInvoker;
    private final EpochClock epochClock;
    private final Aeron aeron;
    private final String[] clusterConsensusEndpoints;
    private final ConsensusPublisher consensusPublisher = new ConsensusPublisher();
    private final ArrayList<RecordingLog.Snapshot> snapshotsToRetrieve = new ArrayList(4);
    private final ArrayList<RecordingLog.Snapshot> snapshotsRetrieved = new ArrayList(4);
    private final Counter stateCounter;
    private final Counter liveLogPositionCounter;
    private final Counter nextQueryDeadlineMsCounter;
    private final ClusterBackupEventsListener eventsListener;
    private final long backupResponseTimeoutMs;
    private final long backupQueryIntervalMs;
    private final long backupProgressTimeoutMs;
    private final long coolDownIntervalMs;
    private final long unavailableCounterHandlerRegistrationId;
    private ClusterBackup.State state = ClusterBackup.State.BACKUP_QUERY;
    private RecordingSignalPoller recordingSignalPoller;
    private AeronArchive backupArchive;
    private AeronArchive.AsyncConnect clusterArchiveAsyncConnect;
    private AeronArchive clusterArchive;
    private SnapshotReplication snapshotReplication;
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this::onFragment);
    private final Subscription consensusSubscription;
    private ExclusivePublication consensusPublication;
    private ClusterMember[] clusterMembers;
    private ClusterMember leaderMember;
    private RecordingLog recordingLog;
    private RecordingLog.Entry leaderLogEntry;
    private RecordingLog.Entry leaderLastTermEntry;
    private Subscription recordingSubscription;
    private String replayChannel;
    private String recordingChannel;
    private long slowTickDeadlineMs = 0L;
    private long markFileUpdateDeadlineMs = 0L;
    private long timeOfLastBackupQueryMs = 0L;
    private long timeOfLastProgressMs = 0L;
    private long coolDownDeadlineMs = -1L;
    private long correlationId = -1L;
    private long leaderLogRecordingId = -1L;
    private long liveLogRecordingSubscriptionId = -1L;
    private long liveLogRecordingId = -1L;
    private int leaderCommitPositionCounterId = -1;
    private int clusterConsensusEndpointsCursor = -1;
    private int snapshotCursor = 0;
    private int liveLogReplaySessionId = -1;
    private int liveLogRecCounterId = -1;

    ClusterBackupAgent(ClusterBackup.Context ctx) {
        this.ctx = ctx;
        this.aeron = ctx.aeron();
        this.epochClock = ctx.epochClock();
        this.backupResponseTimeoutMs = TimeUnit.NANOSECONDS.toMillis(ctx.clusterBackupResponseTimeoutNs());
        this.backupQueryIntervalMs = TimeUnit.NANOSECONDS.toMillis(ctx.clusterBackupIntervalNs());
        this.backupProgressTimeoutMs = TimeUnit.NANOSECONDS.toMillis(ctx.clusterBackupProgressTimeoutNs());
        this.coolDownIntervalMs = TimeUnit.NANOSECONDS.toMillis(ctx.clusterBackupCoolDownIntervalNs());
        this.markFile = ctx.clusterMarkFile();
        this.eventsListener = ctx.eventsListener();
        this.clusterConsensusEndpoints = ctx.clusterConsensusEndpoints().split(",");
        this.aeronClientInvoker = this.aeron.conductorAgentInvoker();
        this.aeronClientInvoker.invoke();
        this.unavailableCounterHandlerRegistrationId = this.aeron.addUnavailableCounterHandler(this::onUnavailableCounter);
        this.consensusSubscription = this.aeron.addSubscription(ctx.consensusChannel(), ctx.consensusStreamId());
        this.stateCounter = ctx.stateCounter();
        this.liveLogPositionCounter = ctx.liveLogPositionCounter();
        this.nextQueryDeadlineMsCounter = ctx.nextQueryDeadlineMsCounter();
    }

    public void onStart() {
        this.recordingLog = new RecordingLog(this.ctx.clusterDir());
        this.backupArchive = AeronArchive.connect((AeronArchive.Context)this.ctx.archiveContext().clone());
        this.recordingSignalPoller = new RecordingSignalPoller(this.backupArchive.controlSessionId(), this.backupArchive.controlResponsePoller().subscription());
        long nowMs = this.epochClock.time();
        this.nextQueryDeadlineMsCounter.setOrdered(nowMs - 1L);
        this.timeOfLastProgressMs = nowMs;
    }

    public void onClose() {
        if (!this.aeron.isClosed()) {
            this.aeron.removeUnavailableCounterHandler(this.unavailableCounterHandlerRegistrationId);
            if (-1L != this.liveLogRecordingSubscriptionId) {
                this.backupArchive.tryStopRecording(this.liveLogRecordingSubscriptionId);
            }
            if (null != this.snapshotReplication) {
                this.snapshotReplication.close(this.backupArchive);
            }
            if (!this.ctx.ownsAeronClient()) {
                CloseHelper.closeAll((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable[])new AutoCloseable[]{this.consensusSubscription, this.consensusPublication, this.recordingSubscription});
            }
            this.state(ClusterBackup.State.CLOSED, this.epochClock.time());
        }
        CloseHelper.closeAll((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable[])new AutoCloseable[]{this.backupArchive, this.clusterArchiveAsyncConnect, this.clusterArchive, this.recordingLog});
        this.markFile.updateActivityTimestamp(-1L);
        this.ctx.close();
    }

    public int doWork() {
        long nowMs = this.epochClock.time();
        int workCount = 0;
        try {
            if (nowMs > this.slowTickDeadlineMs) {
                this.slowTickDeadlineMs = nowMs + 10L;
                workCount += this.slowTick(nowMs);
            }
            workCount += this.consensusSubscription.poll((FragmentHandler)this.fragmentAssembler, 10);
            switch (this.state) {
                case BACKUP_QUERY: {
                    workCount += this.backupQuery(nowMs);
                    break;
                }
                case SNAPSHOT_RETRIEVE: {
                    workCount += this.snapshotRetrieve(nowMs);
                    break;
                }
                case LIVE_LOG_RECORD: {
                    workCount += this.liveLogRecord(nowMs);
                    break;
                }
                case LIVE_LOG_REPLAY: {
                    workCount += this.liveLogReplay(nowMs);
                    break;
                }
                case UPDATE_RECORDING_LOG: {
                    workCount += this.updateRecordingLog(nowMs);
                    break;
                }
                case BACKING_UP: {
                    workCount += this.backingUp(nowMs);
                    break;
                }
                case RESET_BACKUP: {
                    workCount += this.resetBackup(nowMs);
                }
            }
            if (this.hasProgressStalled(nowMs)) {
                if (null != this.eventsListener) {
                    this.eventsListener.onPossibleFailure((Exception)new TimeoutException("progress has stalled", AeronException.Category.WARN));
                }
                this.state(ClusterBackup.State.RESET_BACKUP, nowMs);
            }
        }
        catch (AgentTerminationException ex) {
            this.runTerminationHook(ex);
        }
        catch (Exception ex) {
            if (null != this.eventsListener) {
                this.eventsListener.onPossibleFailure(ex);
            }
            this.state(ClusterBackup.State.RESET_BACKUP, nowMs);
            throw ex;
        }
        return workCount;
    }

    public String roleName() {
        return "cluster-backup";
    }

    private void reset() {
        this.clusterMembers = null;
        this.leaderMember = null;
        this.leaderLogEntry = null;
        this.leaderLastTermEntry = null;
        this.clusterConsensusEndpointsCursor = -1;
        this.liveLogRecCounterId = -1;
        this.liveLogRecordingId = -1L;
        this.snapshotsToRetrieve.clear();
        this.snapshotsRetrieved.clear();
        this.fragmentAssembler.clear();
        if (null != this.snapshotReplication) {
            this.snapshotReplication.close(this.backupArchive);
            this.snapshotReplication = null;
        }
        if (-1L != this.liveLogRecordingSubscriptionId) {
            try {
                this.backupArchive.tryStopRecording(this.liveLogRecordingSubscriptionId);
            }
            catch (Throwable ex) {
                this.ctx.countedErrorHandler().onError(ex);
            }
            this.liveLogRecordingSubscriptionId = -1L;
        }
        CloseHelper.closeAll((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable[])new AutoCloseable[]{this.consensusPublication, this.clusterArchive, this.clusterArchiveAsyncConnect, this.recordingSubscription});
        this.consensusPublication = null;
        this.clusterArchive = null;
        this.clusterArchiveAsyncConnect = null;
        this.recordingSubscription = null;
    }

    private void onUnavailableCounter(CountersReader counters, long registrationId, int counterId) {
        if (counterId == this.liveLogRecCounterId) {
            if (null != this.eventsListener) {
                this.eventsListener.onPossibleFailure((Exception)((Object)new ClusterException("log recording counter unexpectedly unavailable", AeronException.Category.WARN)));
            }
            this.state(ClusterBackup.State.RESET_BACKUP, this.epochClock.time());
        }
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        if (this.messageHeaderDecoder.templateId() == 78) {
            this.backupResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.onBackupResponse(this.backupResponseDecoder.correlationId(), this.backupResponseDecoder.logRecordingId(), this.backupResponseDecoder.logLeadershipTermId(), this.backupResponseDecoder.logTermBaseLogPosition(), this.backupResponseDecoder.lastLeadershipTermId(), this.backupResponseDecoder.lastTermBaseLogPosition(), this.backupResponseDecoder.commitPositionCounterId(), this.backupResponseDecoder.leaderMemberId(), this.backupResponseDecoder);
        }
    }

    private void onBackupResponse(long correlationId, long logRecordingId, long logLeadershipTermId, long logTermBaseLogPosition, long lastLeadershipTermId, long lastTermBaseLogPosition, int commitPositionCounterId, int leaderMemberId, BackupResponseDecoder backupResponseDecoder) {
        if (ClusterBackup.State.BACKUP_QUERY == this.state && correlationId == this.correlationId) {
            long nowMs;
            RecordingLog.Entry lastTerm;
            BackupResponseDecoder.SnapshotsDecoder snapshotsDecoder = backupResponseDecoder.snapshots();
            if (snapshotsDecoder.count() > 0) {
                for (BackupResponseDecoder.SnapshotsDecoder snapshot : snapshotsDecoder) {
                    RecordingLog.Entry entry = this.recordingLog.getLatestSnapshot(snapshot.serviceId());
                    if (null != entry && snapshot.logPosition() == entry.logPosition) continue;
                    this.snapshotsToRetrieve.add(new RecordingLog.Snapshot(snapshot.recordingId(), snapshot.leadershipTermId(), snapshot.termBaseLogPosition(), snapshot.logPosition(), snapshot.timestamp(), snapshot.serviceId()));
                }
            }
            if (null == this.leaderMember || this.leaderMember.id() != leaderMemberId || logRecordingId != this.leaderLogRecordingId) {
                this.leaderLogRecordingId = logRecordingId;
                this.leaderLogEntry = new RecordingLog.Entry(logRecordingId, logLeadershipTermId, logTermBaseLogPosition, -1L, -1L, -1, 0, true, -1);
            }
            if (null == (lastTerm = this.recordingLog.findLastTerm()) || lastLeadershipTermId != lastTerm.leadershipTermId) {
                this.leaderLastTermEntry = new RecordingLog.Entry(logRecordingId, lastLeadershipTermId, lastTermBaseLogPosition, -1L, -1L, -1, 0, true, -1);
            }
            this.timeOfLastBackupQueryMs = 0L;
            this.snapshotCursor = 0;
            this.correlationId = -1L;
            this.leaderCommitPositionCounterId = commitPositionCounterId;
            this.clusterMembers = ClusterMember.parse(backupResponseDecoder.clusterMembers());
            this.leaderMember = ClusterMember.findMember(this.clusterMembers, leaderMemberId);
            if (null != this.eventsListener) {
                this.eventsListener.onBackupResponse(this.clusterMembers, this.leaderMember, this.snapshotsToRetrieve);
            }
            if (null == this.clusterArchive) {
                CloseHelper.close((AutoCloseable)this.clusterArchiveAsyncConnect);
                AeronArchive.Context clusterArchiveContext = this.ctx.clusterArchiveContext().clone();
                ChannelUri leaderArchiveUri = ChannelUri.parse((CharSequence)clusterArchiveContext.controlRequestChannel());
                leaderArchiveUri.put("endpoint", this.leaderMember.archiveEndpoint());
                clusterArchiveContext.controlRequestChannel(leaderArchiveUri.toString());
                this.clusterArchiveAsyncConnect = AeronArchive.asyncConnect((AeronArchive.Context)clusterArchiveContext);
            }
            this.timeOfLastProgressMs = nowMs = this.epochClock.time();
            this.state(this.snapshotsToRetrieve.isEmpty() ? ClusterBackup.State.LIVE_LOG_RECORD : ClusterBackup.State.SNAPSHOT_RETRIEVE, nowMs);
        }
    }

    private int slowTick(long nowMs) {
        String errorResponse;
        int workCount = this.aeronClientInvoker.invoke();
        if (this.aeron.isClosed()) {
            throw new AgentTerminationException("unexpected Aeron close");
        }
        if (nowMs >= this.markFileUpdateDeadlineMs) {
            this.markFileUpdateDeadlineMs = nowMs + MARK_FILE_UPDATE_INTERVAL_MS;
            this.markFile.updateActivityTimestamp(nowMs);
        }
        workCount += this.pollBackupArchiveEvents();
        if (-1L == this.correlationId && null != this.clusterArchive && null != (errorResponse = this.clusterArchive.pollForErrorResponse())) {
            this.ctx.countedErrorHandler().onError((Throwable)((Object)new ClusterException("cluster archive - " + errorResponse, AeronException.Category.WARN)));
            this.state(ClusterBackup.State.RESET_BACKUP, nowMs);
        }
        return workCount;
    }

    private int resetBackup(long nowMs) {
        this.timeOfLastProgressMs = nowMs;
        if (-1L == this.coolDownDeadlineMs) {
            this.coolDownDeadlineMs = nowMs + this.coolDownIntervalMs;
            this.reset();
            return 1;
        }
        if (nowMs > this.coolDownDeadlineMs) {
            this.coolDownDeadlineMs = -1L;
            this.state(ClusterBackup.State.BACKUP_QUERY, nowMs);
            return 1;
        }
        return 0;
    }

    private int backupQuery(long nowMs) {
        long correlationId;
        if (null == this.consensusPublication || nowMs > this.timeOfLastBackupQueryMs + this.backupResponseTimeoutMs) {
            int cursor;
            if ((cursor = ++this.clusterConsensusEndpointsCursor) >= this.clusterConsensusEndpoints.length) {
                this.clusterConsensusEndpointsCursor = 0;
                cursor = 0;
            }
            CloseHelper.close((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable)this.clusterArchiveAsyncConnect);
            CloseHelper.close((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable)this.clusterArchive);
            this.clusterArchiveAsyncConnect = null;
            this.clusterArchive = null;
            CloseHelper.close((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable)this.consensusPublication);
            ChannelUri uri = ChannelUri.parse((CharSequence)this.ctx.consensusChannel());
            uri.put("endpoint", this.clusterConsensusEndpoints[cursor]);
            this.consensusPublication = this.aeron.addExclusivePublication(uri.toString(), this.ctx.consensusStreamId());
            this.correlationId = -1L;
            this.timeOfLastBackupQueryMs = nowMs;
            return 1;
        }
        if (-1L == this.correlationId && this.consensusPublication.isConnected() && this.consensusPublisher.backupQuery(this.consensusPublication, correlationId = this.aeron.nextCorrelationId(), this.ctx.consensusStreamId(), AeronCluster.Configuration.PROTOCOL_SEMANTIC_VERSION, this.ctx.consensusChannel(), ArrayUtil.EMPTY_BYTE_ARRAY)) {
            this.timeOfLastBackupQueryMs = nowMs;
            this.correlationId = correlationId;
            return 1;
        }
        return 0;
    }

    private int snapshotRetrieve(long nowMs) {
        int workCount = 0;
        if (null == this.clusterArchive) {
            int step = this.clusterArchiveAsyncConnect.step();
            this.clusterArchive = this.clusterArchiveAsyncConnect.poll();
            return null == this.clusterArchive ? this.clusterArchiveAsyncConnect.step() - step : 1;
        }
        if (null == this.snapshotReplication) {
            ChannelUri replicationUri = ChannelUri.parse((CharSequence)this.ctx.catchupChannel());
            replicationUri.put("endpoint", this.ctx.catchupEndpoint());
            long replicationId = this.backupArchive.replicate(this.snapshotsToRetrieve.get((int)this.snapshotCursor).recordingId, -1L, -1L, this.clusterArchive.context().controlRequestStreamId(), this.clusterArchive.context().controlRequestChannel(), null, replicationUri.toString());
            this.snapshotReplication = new SnapshotReplication(replicationId, true);
            this.timeOfLastProgressMs = nowMs;
            ++workCount;
        } else {
            workCount += this.pollBackupArchiveEvents();
            this.timeOfLastProgressMs = nowMs;
            if (this.snapshotReplication.isDone()) {
                if (this.snapshotReplication.isComplete()) {
                    RecordingLog.Snapshot snapshot = this.snapshotsToRetrieve.get(this.snapshotCursor);
                    this.snapshotsRetrieved.add(new RecordingLog.Snapshot(this.snapshotReplication.recordingId(), snapshot.leadershipTermId, snapshot.termBaseLogPosition, snapshot.logPosition, snapshot.timestamp, snapshot.serviceId));
                    this.snapshotReplication = null;
                    if (++this.snapshotCursor >= this.snapshotsToRetrieve.size()) {
                        this.state(ClusterBackup.State.LIVE_LOG_RECORD, nowMs);
                        ++workCount;
                    }
                } else {
                    ChannelUri replicationUri = ChannelUri.parse((CharSequence)this.ctx.catchupChannel());
                    replicationUri.put("endpoint", this.ctx.catchupEndpoint());
                    long replicationId = this.backupArchive.replicate(this.snapshotsToRetrieve.get((int)this.snapshotCursor).recordingId, this.snapshotReplication.recordingId(), -1L, this.clusterArchive.context().controlRequestStreamId(), this.clusterArchive.context().controlRequestChannel(), null, replicationUri.toString());
                    this.snapshotReplication = new SnapshotReplication(replicationId, false);
                    this.timeOfLastProgressMs = nowMs;
                    ++workCount;
                }
            }
        }
        return workCount;
    }

    private int liveLogRecord(long nowMs) {
        int workCount = 0;
        if (-1L == this.liveLogRecordingSubscriptionId) {
            String catchupEndpoint = this.ctx.catchupEndpoint();
            if (catchupEndpoint.endsWith(":0")) {
                if (null == this.recordingSubscription) {
                    ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.catchupChannel());
                    channelUri.remove("endpoint");
                    channelUri.put("tags", this.aeron.nextCorrelationId() + "," + this.aeron.nextCorrelationId());
                    this.recordingChannel = channelUri.toString();
                    String channel = this.recordingChannel + "|endpoint=" + catchupEndpoint;
                    this.recordingSubscription = this.aeron.addSubscription(channel, this.ctx.logStreamId());
                    this.timeOfLastProgressMs = nowMs;
                    return 1;
                }
                String resolvedEndpoint = this.recordingSubscription.resolvedEndpoint();
                if (null == resolvedEndpoint) {
                    return 0;
                }
                String endpoint = catchupEndpoint.substring(0, catchupEndpoint.length() - 2) + resolvedEndpoint.substring(resolvedEndpoint.lastIndexOf(58));
                ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.catchupChannel());
                channelUri.put("endpoint", endpoint);
                this.replayChannel = channelUri.toString();
            } else {
                ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.catchupChannel());
                channelUri.put("endpoint", catchupEndpoint);
                this.recordingChannel = this.replayChannel = channelUri.toString();
            }
            this.liveLogRecordingSubscriptionId = this.startLogRecording();
        }
        this.timeOfLastProgressMs = nowMs;
        this.state(ClusterBackup.State.LIVE_LOG_REPLAY, nowMs);
        return ++workCount;
    }

    private int liveLogReplay(long nowMs) {
        int workCount = 0;
        if (-1L == this.liveLogRecordingId) {
            if (null == this.clusterArchive) {
                int step = this.clusterArchiveAsyncConnect.step();
                this.clusterArchive = this.clusterArchiveAsyncConnect.poll();
                return null == this.clusterArchive ? this.clusterArchiveAsyncConnect.step() - step : 1;
            }
            if (-1L == this.correlationId) {
                RecordingLog.Entry logEntry = this.recordingLog.findLastTerm();
                long startPosition = null == logEntry ? -1L : this.backupArchive.getStopPosition(logEntry.recordingId);
                long replayId = this.ctx.aeron().nextCorrelationId();
                if (this.clusterArchive.archiveProxy().boundedReplay(this.leaderLogRecordingId, startPosition, -1L, this.leaderCommitPositionCounterId, this.replayChannel, this.ctx.logStreamId(), replayId, this.clusterArchive.controlSessionId())) {
                    this.replayChannel = null;
                    this.correlationId = replayId;
                    this.timeOfLastProgressMs = nowMs;
                    ++workCount;
                }
            } else if (ClusterBackupAgent.pollForResponse(this.clusterArchive, this.correlationId)) {
                this.liveLogReplaySessionId = (int)this.clusterArchive.controlResponsePoller().relevantId();
                this.timeOfLastProgressMs = nowMs;
            } else if (-1 == this.liveLogRecCounterId) {
                CountersReader countersReader = this.aeron.countersReader();
                this.liveLogRecCounterId = RecordingPos.findCounterIdBySession((CountersReader)countersReader, (int)this.liveLogReplaySessionId);
                if (-1 != this.liveLogRecCounterId) {
                    this.liveLogPositionCounter.setOrdered(countersReader.getCounterValue(this.liveLogRecCounterId));
                    this.liveLogRecordingId = RecordingPos.getRecordingId((CountersReader)countersReader, (int)this.liveLogRecCounterId);
                    this.timeOfLastBackupQueryMs = nowMs;
                    this.timeOfLastProgressMs = nowMs;
                    this.state(ClusterBackup.State.UPDATE_RECORDING_LOG, nowMs);
                }
            }
        } else {
            this.timeOfLastProgressMs = nowMs;
            this.state(ClusterBackup.State.UPDATE_RECORDING_LOG, nowMs);
        }
        return workCount;
    }

    private int updateRecordingLog(long nowMs) {
        boolean wasRecordingLogUpdated = false;
        try {
            long snapshotLeadershipTermId;
            long l = snapshotLeadershipTermId = this.snapshotsRetrieved.isEmpty() ? -1L : this.snapshotsRetrieved.get((int)0).leadershipTermId;
            if (null != this.leaderLogEntry && this.recordingLog.isUnknown(this.leaderLogEntry.leadershipTermId) && this.leaderLogEntry.leadershipTermId <= snapshotLeadershipTermId) {
                this.recordingLog.appendTerm(this.liveLogRecordingId, this.leaderLogEntry.leadershipTermId, this.leaderLogEntry.termBaseLogPosition, this.leaderLogEntry.timestamp);
                wasRecordingLogUpdated = true;
                this.leaderLogEntry = null;
            }
            if (!this.snapshotsRetrieved.isEmpty()) {
                for (int i = this.snapshotsRetrieved.size() - 1; i >= 0; --i) {
                    RecordingLog.Snapshot snapshot = this.snapshotsRetrieved.get(i);
                    this.recordingLog.appendSnapshot(snapshot.recordingId, snapshot.leadershipTermId, snapshot.termBaseLogPosition, snapshot.logPosition, snapshot.timestamp, snapshot.serviceId);
                }
                wasRecordingLogUpdated = true;
            }
            if (null != this.leaderLastTermEntry && this.recordingLog.isUnknown(this.leaderLastTermEntry.leadershipTermId)) {
                this.recordingLog.appendTerm(this.liveLogRecordingId, this.leaderLastTermEntry.leadershipTermId, this.leaderLastTermEntry.termBaseLogPosition, this.leaderLastTermEntry.timestamp);
                wasRecordingLogUpdated = true;
                this.leaderLastTermEntry = null;
            }
        }
        catch (Throwable ex) {
            this.ctx.countedErrorHandler().onError(ex);
            throw new AgentTerminationException("failed to update recording log", ex);
        }
        if (wasRecordingLogUpdated && null != this.eventsListener) {
            this.eventsListener.onUpdatedRecordingLog(this.recordingLog, this.snapshotsRetrieved);
        }
        this.snapshotsRetrieved.clear();
        this.snapshotsToRetrieve.clear();
        this.timeOfLastProgressMs = nowMs;
        this.nextQueryDeadlineMsCounter.setOrdered(nowMs + this.backupQueryIntervalMs);
        this.state(ClusterBackup.State.BACKING_UP, nowMs);
        return 1;
    }

    private int backingUp(long nowMs) {
        long liveLogPosition;
        int workCount = 0;
        if (nowMs > this.nextQueryDeadlineMsCounter.get()) {
            this.timeOfLastBackupQueryMs = nowMs;
            this.timeOfLastProgressMs = nowMs;
            this.state(ClusterBackup.State.BACKUP_QUERY, nowMs);
            ++workCount;
        }
        if (-1 != this.liveLogRecCounterId && this.liveLogPositionCounter.proposeMaxOrdered(liveLogPosition = this.aeron.countersReader().getCounterValue(this.liveLogRecCounterId))) {
            if (null != this.eventsListener) {
                this.eventsListener.onLiveLogProgress(this.liveLogRecordingId, this.liveLogRecCounterId, liveLogPosition);
            }
            ++workCount;
        }
        return workCount;
    }

    private void state(ClusterBackup.State newState, long nowMs) {
        this.stateChange(this.state, newState, nowMs);
        if (ClusterBackup.State.BACKUP_QUERY == newState && null != this.eventsListener) {
            this.eventsListener.onBackupQuery();
        }
        if (!this.stateCounter.isClosed()) {
            this.stateCounter.setOrdered((long)newState.code());
        }
        this.state = newState;
        this.correlationId = -1L;
    }

    private void stateChange(ClusterBackup.State oldState, ClusterBackup.State newState, long nowMs) {
    }

    private static boolean pollForResponse(AeronArchive archive, long correlationId) {
        ControlResponsePoller poller = archive.controlResponsePoller();
        if (poller.poll() > 0 && poller.isPollComplete() && poller.controlSessionId() == archive.controlSessionId()) {
            ControlResponseCode code = poller.code();
            if (ControlResponseCode.ERROR == code) {
                throw new ArchiveException(poller.errorMessage(), (int)poller.relevantId(), poller.correlationId());
            }
            return ControlResponseCode.OK == code && poller.correlationId() == correlationId;
        }
        return false;
    }

    private int pollBackupArchiveEvents() {
        int workCount = 0;
        if (null != this.backupArchive) {
            RecordingSignalPoller poller = this.recordingSignalPoller;
            workCount += poller.poll();
            if (poller.isPollComplete()) {
                int templateId = poller.templateId();
                if (1 == templateId && poller.code() == ControlResponseCode.ERROR) {
                    ArchiveException ex = new ArchiveException(poller.errorMessage(), (int)poller.relevantId(), poller.correlationId());
                    if (ex.errorCode() == 11) {
                        this.ctx.countedErrorHandler().onError((Throwable)ex);
                        throw new AgentTerminationException();
                    }
                    throw ex;
                }
                if (24 == templateId && null != this.snapshotReplication) {
                    this.snapshotReplication.onSignal(poller.correlationId(), poller.recordingId(), poller.recordingPosition(), poller.recordingSignal());
                }
            } else if (0 == workCount && !poller.subscription().isConnected()) {
                this.ctx.countedErrorHandler().onError((Throwable)((Object)new ClusterException("local archive is not connected", AeronException.Category.WARN)));
                throw new AgentTerminationException();
            }
        }
        return workCount;
    }

    private long startLogRecording() {
        RecordingLog.Entry logEntry = this.recordingLog.findLastTerm();
        int streamId = this.ctx.logStreamId();
        long recordingSubscriptionId = null == logEntry ? this.backupArchive.startRecording(this.recordingChannel, streamId, SourceLocation.REMOTE, true) : this.backupArchive.extendRecording(logEntry.recordingId, this.recordingChannel, streamId, SourceLocation.REMOTE, true);
        CloseHelper.close((ErrorHandler)this.ctx.countedErrorHandler(), (AutoCloseable)this.recordingSubscription);
        this.recordingChannel = null;
        this.recordingSubscription = null;
        return recordingSubscriptionId;
    }

    private boolean hasProgressStalled(long nowMs) {
        return -1 == this.liveLogRecCounterId && nowMs > this.timeOfLastProgressMs + this.backupProgressTimeoutMs;
    }

    private void runTerminationHook(AgentTerminationException ex) {
        try {
            this.ctx.terminationHook().run();
        }
        catch (Throwable t) {
            this.ctx.countedErrorHandler().onError(t);
        }
        throw ex;
    }
}

