/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusPublisher;
import io.aeron.cluster.client.ClusterException;
import io.aeron.exceptions.AeronException;
import org.agrona.ErrorHandler;

class ClusterTermination {
    private long deadlineNs;
    private boolean haveServicesTerminated = false;

    ClusterTermination(long deadlineNs) {
        this.deadlineNs = deadlineNs;
    }

    void deadlineNs(long deadlineNs) {
        this.deadlineNs = deadlineNs;
    }

    boolean canTerminate(ClusterMember[] members, long terminationPosition, long nowNs) {
        if (this.haveServicesTerminated) {
            return ClusterTermination.haveFollowersTerminated(members, terminationPosition) || nowNs >= this.deadlineNs;
        }
        return false;
    }

    void onServicesTerminated() {
        this.haveServicesTerminated = true;
    }

    void terminationPosition(ErrorHandler errorHandler, ConsensusPublisher consensusPublisher, ClusterMember[] members, ClusterMember thisMember, long leadershipTermId, long position) {
        for (ClusterMember member : members) {
            member.hasTerminated(false);
            if (member == thisMember || consensusPublisher.terminationPosition(member.publication(), leadershipTermId, position)) continue;
            errorHandler.onError((Throwable)((Object)new ClusterException("failed to send termination position to member=" + member.id(), AeronException.Category.WARN)));
        }
    }

    private static boolean haveFollowersTerminated(ClusterMember[] members, long terminationPosition) {
        boolean result = true;
        for (ClusterMember member : members) {
            if (member.hasTerminated() || member.logPosition() >= terminationPosition) continue;
            result = false;
            break;
        }
        return result;
    }
}

