/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.Publication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ClusterControl;
import io.aeron.cluster.ClusterControlAdapter;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ClusterMembership;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusterNodeControlProperties;
import io.aeron.cluster.service.ConsensusModuleProxy;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.MutableBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class ClusterTool {
    public static final String AERON_CLUSTER_TOOL_TIMEOUT_PROP_NAME = "aeron.cluster.tool.timeout";
    public static final String AERON_CLUSTER_TOOL_DELAY_PROP_NAME = "aeron.cluster.tool.delay";
    private static final long TIMEOUT_MS = TimeUnit.NANOSECONDS.toMillis(SystemUtil.getDurationInNanos((String)"aeron.cluster.tool.timeout", (long)0L));

    public static void main(String[] args) {
        File clusterDir;
        if (args.length < 2) {
            ClusterTool.printHelp(System.out);
            System.exit(-1);
        }
        if (!(clusterDir = new File(args[0])).exists()) {
            System.err.println("ERR: cluster directory not found: " + clusterDir.getAbsolutePath());
            ClusterTool.printHelp(System.out);
            System.exit(-1);
        }
        switch (args[1]) {
            case "describe": {
                ClusterTool.describe(System.out, clusterDir);
                break;
            }
            case "pid": {
                ClusterTool.pid(System.out, clusterDir);
                break;
            }
            case "recovery-plan": {
                if (args.length < 3) {
                    ClusterTool.printHelp(System.out);
                    System.exit(-1);
                }
                ClusterTool.recoveryPlan(System.out, clusterDir, Integer.parseInt(args[2]));
                break;
            }
            case "recording-log": {
                ClusterTool.recordingLog(System.out, clusterDir);
                break;
            }
            case "sort-recording-log": {
                ClusterTool.sortRecordingLog(clusterDir);
                break;
            }
            case "errors": {
                ClusterTool.errors(System.out, clusterDir);
                break;
            }
            case "list-members": {
                ClusterTool.listMembers(System.out, clusterDir);
                break;
            }
            case "remove-member": {
                if (args.length < 3) {
                    ClusterTool.printHelp(System.out);
                    System.exit(-1);
                }
                ClusterTool.removeMember(System.out, clusterDir, Integer.parseInt(args[2]), false);
                break;
            }
            case "remove-passive": {
                if (args.length < 3) {
                    ClusterTool.printHelp(System.out);
                    System.exit(-1);
                }
                ClusterTool.removeMember(System.out, clusterDir, Integer.parseInt(args[2]), true);
                break;
            }
            case "backup-query": {
                if (args.length < 3) {
                    ClusterTool.printNextBackupQuery(System.out, clusterDir);
                    break;
                }
                ClusterTool.nextBackupQuery(System.out, clusterDir, TimeUnit.NANOSECONDS.toMillis(SystemUtil.parseDuration((String)AERON_CLUSTER_TOOL_DELAY_PROP_NAME, (String)args[2])));
                break;
            }
            case "invalidate-latest-snapshot": {
                ClusterTool.invalidateLatestSnapshot(System.out, clusterDir);
                break;
            }
            case "snapshot": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.snapshot(clusterDir, System.out));
                break;
            }
            case "suspend": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.suspend(clusterDir, System.out));
                break;
            }
            case "resume": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.resume(clusterDir, System.out));
                break;
            }
            case "shutdown": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.shutdown(clusterDir, System.out));
                break;
            }
            case "abort": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.abort(clusterDir, System.out));
                break;
            }
            default: {
                System.out.println("Unknown command: " + args[1]);
                ClusterTool.printHelp(System.out);
                System.exit(-1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void describe(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir)) ** GOTO lbl6
        if (ClusterTool.TIMEOUT_MS > 0L) {
lbl6:
            // 2 sources

            markFile = ClusterTool.openMarkFile(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)out));
            var3_3 = null;
            try {
                ClusterTool.printTypeAndActivityTimestamp(out, markFile);
                out.println(markFile.decoder());
            }
            catch (Throwable var4_5) {
                var3_3 = var4_5;
                throw var4_5;
            }
            finally {
                if (markFile != null) {
                    if (var3_3 != null) {
                        try {
                            markFile.close();
                        }
                        catch (Throwable var4_4) {
                            var3_3.addSuppressed(var4_4);
                        }
                    } else {
                        markFile.close();
                    }
                }
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
        serviceMarkFiles = ClusterTool.openServiceMarkFiles(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)out));
        ClusterTool.describe(out, serviceMarkFiles);
    }

    public static void pid(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                out.println(markFile.decoder().pid());
            }
        } else {
            System.exit(-1);
        }
    }

    public static void recoveryPlan(PrintStream out, File clusterDir, int serviceCount) {
        try (AeronArchive archive = AeronArchive.connect();
             RecordingLog recordingLog = new RecordingLog(clusterDir);){
            out.println(recordingLog.createRecoveryPlan(archive, serviceCount, -1L));
        }
    }

    public static void recordingLog(PrintStream out, File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir);){
            out.println(recordingLog);
        }
    }

    public static boolean sortRecordingLog(File clusterDir) {
        List<RecordingLog.Entry> entries;
        try (RecordingLog recordingLog = new RecordingLog(clusterDir);){
            entries = recordingLog.entries();
            if (ClusterTool.isRecordingLogSorted(entries)) {
                boolean bl = false;
                return bl;
            }
        }
        int size = entries.size();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(RecordingLog.ENTRY_LENGTH).order(ByteOrder.LITTLE_ENDIAN);
        UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
        File newLogFile = new File(clusterDir, "recording.log.sorted");
        try {
            try (FileChannel fileChannel = FileChannel.open(newLogFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                long position = 0L;
                for (int i = 0; i < size; ++i) {
                    RecordingLog.writeEntryToBuffer(entries.get(0), buffer);
                    byteBuffer.limit(RecordingLog.ENTRY_LENGTH).position(0);
                    if (RecordingLog.ENTRY_LENGTH != fileChannel.write(byteBuffer, position)) {
                        throw new ClusterException("failed to write recording");
                    }
                    position += (long)RecordingLog.ENTRY_LENGTH;
                }
            }
            Path logFile = clusterDir.toPath().resolve("recording.log");
            Files.delete(logFile);
            Files.move(newLogFile.toPath(), logFile, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void errors(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir)) ** GOTO lbl6
        if (ClusterTool.TIMEOUT_MS > 0L) {
lbl6:
            // 2 sources

            markFile = ClusterTool.openMarkFile(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)System.out));
            var3_3 = null;
            try {
                ClusterTool.printTypeAndActivityTimestamp(out, markFile);
                ClusterTool.printErrors(out, markFile);
                aeronDirectory = markFile.decoder().aeronDirectory();
                out.println();
                ClusterTool.printDriverErrors(out, aeronDirectory);
            }
            catch (Throwable var4_6) {
                var3_3 = var4_6;
                throw var4_6;
            }
            finally {
                if (markFile != null) {
                    if (var3_3 != null) {
                        try {
                            markFile.close();
                        }
                        catch (Throwable var4_5) {
                            var3_3.addSuppressed(var4_5);
                        }
                    } else {
                        markFile.close();
                    }
                }
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
        serviceMarkFiles = ClusterTool.openServiceMarkFiles(clusterDir, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, println(java.lang.String ), (Ljava/lang/String;)V)((PrintStream)out));
        ClusterTool.errors(out, serviceMarkFiles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void listMembers(PrintStream out, File clusterDir) {
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, System.out::println);){
            ClusterMembership clusterMembership = new ClusterMembership();
            long timeoutMs = Math.max(TimeUnit.SECONDS.toMillis(1L), TIMEOUT_MS);
            if (ClusterTool.queryClusterMembers(markFile, timeoutMs, clusterMembership)) {
                out.println("currentTimeNs=" + clusterMembership.currentTimeNs + ", leaderMemberId=" + clusterMembership.leaderMemberId + ", memberId=" + clusterMembership.memberId + ", activeMembers=" + clusterMembership.activeMembers + ", passiveMembers=" + clusterMembership.passiveMembers);
                return;
            }
            out.println("timeout waiting for response from node");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeMember(PrintStream out, File clusterDir, int memberId, boolean isPassive) {
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, System.out::println);){
            if (ClusterTool.removeMember(markFile, memberId, isPassive)) return;
            out.println("could not send remove member request");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void printNextBackupQuery(PrintStream out, File clusterDir) {
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, System.out::println);){
            if (markFile.decoder().componentType() != ClusterComponentType.BACKUP) {
                out.println("not a cluster backup node");
                return;
            }
            out.format("%2$tF %1$tH:%1$tM:%1$tS next: %2$tF %2$tH:%2$tM:%2$tS%n", new Date(), new Date(ClusterTool.nextBackupQueryDeadlineMs(markFile)));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void nextBackupQuery(PrintStream out, File clusterDir, long delayMs) {
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, System.out::println);){
            if (markFile.decoder().componentType() != ClusterComponentType.BACKUP) {
                out.println("not a cluster backup node");
                return;
            }
            SystemEpochClock epochClock = SystemEpochClock.INSTANCE;
            ClusterTool.nextBackupQueryDeadlineMs(markFile, epochClock.time() + delayMs);
            out.format("%2$tF %1$tH:%1$tM:%1$tS setting next: %2$tF %2$tH:%2$tM:%2$tS%n", new Date(), new Date(ClusterTool.nextBackupQueryDeadlineMs(markFile)));
            return;
        }
    }

    public static void describe(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles) {
            ClusterTool.printTypeAndActivityTimestamp(out, serviceMarkFile);
            out.println(serviceMarkFile.decoder());
            serviceMarkFile.close();
        }
    }

    public static void errors(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles) {
            ClusterTool.printTypeAndActivityTimestamp(out, serviceMarkFile);
            ClusterTool.printErrors(out, serviceMarkFile);
            serviceMarkFile.close();
        }
    }

    public static boolean markFileExists(File clusterDir) {
        File markFile = new File(clusterDir, "cluster-mark.dat");
        return markFile.exists();
    }

    public static boolean listMembers(ClusterMembership clusterMembership, File clusterDir, long timeoutMs) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                boolean bl = ClusterTool.queryClusterMembers(markFile, timeoutMs, clusterMembership);
                return bl;
            }
        }
        return false;
    }

    public static boolean queryClusterMembers(ClusterMarkFile markFile, long timeoutMs, ClusterMembership clusterMembership) {
        return ClusterTool.queryClusterMembers(markFile.loadControlProperties(), timeoutMs, clusterMembership);
    }

    public static boolean queryClusterMembers(ClusterNodeControlProperties controlProperties, long timeoutMs, final ClusterMembership clusterMembership) {
        MutableLong id;
        block38: {
            id = new MutableLong(-1L);
            ClusterControlAdapter.Listener listener = new ClusterControlAdapter.Listener(){

                @Override
                public void onClusterMembersResponse(long correlationId, int leaderMemberId, String activeMembers, String passiveMembers) {
                    if (correlationId == id.get()) {
                        clusterMembership.leaderMemberId = leaderMemberId;
                        clusterMembership.activeMembersStr = activeMembers;
                        clusterMembership.passiveMembersStr = passiveMembers;
                        id.set(-1L);
                    }
                }

                @Override
                public void onClusterMembersExtendedResponse(long correlationId, long currentTimeNs, int leaderMemberId, int memberId, List<ClusterMember> activeMembers, List<ClusterMember> passiveMembers) {
                    if (correlationId == id.get()) {
                        clusterMembership.currentTimeNs = currentTimeNs;
                        clusterMembership.leaderMemberId = leaderMemberId;
                        clusterMembership.memberId = memberId;
                        clusterMembership.activeMembers = activeMembers;
                        clusterMembership.passiveMembers = passiveMembers;
                        clusterMembership.activeMembersStr = ClusterMember.encodeAsString(activeMembers);
                        clusterMembership.passiveMembersStr = ClusterMember.encodeAsString(passiveMembers);
                        id.set(-1L);
                    }
                }
            };
            try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(controlProperties.aeronDirectoryName));
                 ConsensusModuleProxy consensusModuleProxy = new ConsensusModuleProxy((Publication)aeron.addPublication(controlProperties.controlChannel, controlProperties.consensusModuleStreamId));
                 ClusterControlAdapter clusterControlAdapter = new ClusterControlAdapter(aeron.addSubscription(controlProperties.controlChannel, controlProperties.serviceStreamId), listener);){
                id.set(aeron.nextCorrelationId());
                if (!consensusModuleProxy.clusterMembersQuery(id.get())) break block38;
                long startTime = System.currentTimeMillis();
                do {
                    if (clusterControlAdapter.poll() != 0) continue;
                    if (System.currentTimeMillis() - startTime > timeoutMs) {
                        break;
                    }
                    Thread.yield();
                } while (-1L != id.get());
            }
        }
        return id.get() == -1L;
    }

    public static boolean removeMember(File clusterDir, int memberId, boolean isPassive) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                boolean bl = ClusterTool.removeMember(markFile, memberId, isPassive);
                return bl;
            }
        }
        return false;
    }

    public static boolean removeMember(ClusterMarkFile markFile, int memberId, boolean isPassive) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        String controlChannel = markFile.decoder().controlChannel();
        int consensusModuleStreamId = markFile.decoder().consensusModuleStreamId();
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(aeronDirectoryName));
             ConsensusModuleProxy consensusModuleProxy = new ConsensusModuleProxy((Publication)aeron.addPublication(controlChannel, consensusModuleStreamId));){
            if (consensusModuleProxy.removeMember(memberId, isPassive ? BooleanType.TRUE : BooleanType.FALSE)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static long nextBackupQueryDeadlineMs(File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                long l = ClusterTool.nextBackupQueryDeadlineMs(markFile);
                return l;
            }
        }
        return -1L;
    }

    public static long nextBackupQueryDeadlineMs(ClusterMarkFile markFile) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        MutableLong nextQueryMs = new MutableLong(-1L);
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
            aeron.countersReader().forEach((counterId, typeId, keyBuffer, label) -> {
                if (210 == typeId) {
                    nextQueryMs.set(aeron.countersReader().getCounterValue(counterId));
                }
            });
        }
        return nextQueryMs.get();
    }

    public static boolean nextBackupQueryDeadlineMs(File clusterDir, long timeMs) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, null);){
                boolean bl = ClusterTool.nextBackupQueryDeadlineMs(markFile, timeMs);
                return bl;
            }
        }
        return false;
    }

    public static boolean nextBackupQueryDeadlineMs(ClusterMarkFile markFile, long timeMs) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        MutableBoolean result = new MutableBoolean(false);
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
            CountersReader countersReader = aeron.countersReader();
            countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
                if (210 == typeId) {
                    AtomicCounter atomicCounter = new AtomicCounter(countersReader.valuesBuffer(), counterId, null);
                    atomicCounter.setOrdered(timeMs);
                    result.value = true;
                }
            });
        }
        return result.value;
    }

    public static boolean invalidateLatestSnapshot(PrintStream out, File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir);){
            boolean result = recordingLog.invalidateLatestSnapshot();
            out.println(" invalidate latest snapshot: " + result);
            boolean bl = result;
            return bl;
        }
    }

    public static boolean snapshot(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SNAPSHOT, true, TimeUnit.SECONDS.toMillis(30L));
    }

    public static boolean suspend(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SUSPEND, false, TimeUnit.SECONDS.toMillis(1L));
    }

    public static boolean resume(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.SUSPENDED, ClusterControl.ToggleState.RESUME, true, TimeUnit.SECONDS.toMillis(1L));
    }

    public static boolean shutdown(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SHUTDOWN, false, TimeUnit.SECONDS.toMillis(1L));
    }

    public static boolean abort(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.ABORT, false, TimeUnit.SECONDS.toMillis(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean toggleClusterState(PrintStream out, File clusterDir, ConsensusModule.State expectedState, ClusterControl.ToggleState toggleState, boolean waitForToggleToComplete, long defaultTimeoutMs) {
        ClusterNodeControlProperties clusterNodeControlProperties;
        int clusterId;
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return false;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir, out::println);){
            clusterId = markFile.clusterId();
            clusterNodeControlProperties = markFile.loadControlProperties();
        }
        ClusterMembership clusterMembership = new ClusterMembership();
        long queryTimeoutMs = Math.max(TimeUnit.SECONDS.toMillis(1L), TIMEOUT_MS);
        if (!ClusterTool.queryClusterMembers(clusterNodeControlProperties, queryTimeoutMs, clusterMembership)) {
            out.println("Timed out querying cluster.");
            return false;
        }
        String prefix = "Member [" + clusterMembership.memberId + "]: ";
        if (clusterMembership.leaderMemberId != clusterMembership.memberId) {
            out.println(prefix + "Current node is not the leader (leaderMemberId = " + clusterMembership.leaderMemberId + "), unable to " + (Object)((Object)toggleState));
            return false;
        }
        File cncFile = new File(clusterNodeControlProperties.aeronDirectoryName, "cnc.dat");
        if (!cncFile.exists()) {
            out.println(prefix + "Unable to locate media driver. C`n`C file [" + cncFile.getAbsolutePath() + "] does not exist.");
            return false;
        }
        CountersReader countersReader = ClusterControl.mapCounters(cncFile);
        try {
            ConsensusModule.State moduleState = ConsensusModule.State.find(countersReader, clusterId);
            if (null == moduleState) {
                out.println(prefix + "Unable to resolve state of consensus module.");
                boolean bl = false;
                return bl;
            }
            if (expectedState != moduleState) {
                out.println(prefix + "Unable to " + (Object)((Object)toggleState) + " as the state of the consensus module is " + (Object)((Object)moduleState) + ", but needs to be " + (Object)((Object)expectedState));
                boolean bl = false;
                return bl;
            }
            AtomicCounter controlToggle = ClusterControl.findControlToggle(countersReader, clusterId);
            if (null == controlToggle) {
                out.println(prefix + "Failed to find control toggle");
                boolean bl = false;
                return bl;
            }
            if (!toggleState.toggle(controlToggle)) {
                out.println(prefix + "Failed to apply " + (Object)((Object)toggleState) + ", current toggle value = " + (Object)((Object)ClusterControl.ToggleState.get(controlToggle)));
                boolean bl = false;
                return bl;
            }
            if (waitForToggleToComplete) {
                long toggleTimeoutMs = Math.max(defaultTimeoutMs, TIMEOUT_MS);
                long startTime = System.currentTimeMillis();
                ClusterControl.ToggleState currentState = null;
                do {
                    Thread.yield();
                } while (System.currentTimeMillis() - startTime <= toggleTimeoutMs && (currentState = ClusterControl.ToggleState.get(controlToggle)) != ClusterControl.ToggleState.NEUTRAL);
                if (currentState != ClusterControl.ToggleState.NEUTRAL) {
                    out.println(prefix + "Timed out after " + toggleTimeoutMs + "ms waiting for " + (Object)((Object)toggleState) + " to complete.");
                }
            }
            out.println(prefix + (Object)((Object)toggleState) + " applied successfully");
            boolean bl = true;
            return bl;
        }
        finally {
            IoUtil.unmap((ByteBuffer)countersReader.valuesBuffer().byteBuffer());
        }
    }

    private static ClusterMarkFile openMarkFile(File clusterDir, Consumer<String> logger) {
        return new ClusterMarkFile(clusterDir, "cluster-mark.dat", System::currentTimeMillis, TIMEOUT_MS, logger);
    }

    private static ClusterMarkFile[] openServiceMarkFiles(File clusterDir, Consumer<String> logger) {
        String[] clusterMarkFileNames = clusterDir.list((dir, name) -> name.startsWith("cluster-mark-service-") && name.endsWith(".dat"));
        if (null == clusterMarkFileNames) {
            clusterMarkFileNames = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ClusterMarkFile[] clusterMarkFiles = new ClusterMarkFile[clusterMarkFileNames.length];
        int length = clusterMarkFiles.length;
        for (int i = 0; i < length; ++i) {
            clusterMarkFiles[i] = new ClusterMarkFile(clusterDir, clusterMarkFileNames[i], System::currentTimeMillis, TIMEOUT_MS, logger);
        }
        return clusterMarkFiles;
    }

    private static void printTypeAndActivityTimestamp(PrintStream out, ClusterMarkFile markFile) {
        out.print("Type: " + (Object)((Object)markFile.decoder().componentType()) + " ");
        out.format("%1$tH:%1$tM:%1$tS (start: %2$tF %2$tH:%2$tM:%2$tS, activity: %3$tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(markFile.decoder().startTimestamp()), new Date(markFile.activityTimestampVolatile()));
    }

    private static void printErrors(PrintStream out, ClusterMarkFile markFile) {
        out.println("Cluster component error log:");
        CommonContext.printErrorLog((AtomicBuffer)markFile.errorBuffer(), (PrintStream)out);
    }

    private static void printDriverErrors(PrintStream out, String aeronDirectory) {
        out.println("Aeron driver error log (directory: " + aeronDirectory + "):");
        File cncFile = new File(aeronDirectory, "cnc.dat");
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY, (String)"cnc");
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        CncFileDescriptor.checkVersion((int)cncVersion);
        CommonContext.printErrorLog((AtomicBuffer)CncFileDescriptor.createErrorLogBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaDataBuffer), (PrintStream)out);
    }

    private static boolean isRecordingLogSorted(List<RecordingLog.Entry> entries) {
        for (int i = entries.size() - 1; i >= 0; --i) {
            if (entries.get((int)i).entryIndex == i) continue;
            return false;
        }
        return true;
    }

    private static void exitWithErrorOnFailure(boolean success) {
        if (!success) {
            System.exit(-1);
        }
    }

    private static void printHelp(PrintStream out) {
        out.format("Usage: <cluster-dir> <command> [options]%n                   describe: prints out all descriptors in the file%n                        pid: prints PID of cluster component%n              recovery-plan: [service count] prints recovery plan of cluster component%n              recording-log: prints recording log of cluster component%n         sort-recording-log: re-arranges entries in the recording log to match the order in memory%n                     errors: prints Aeron and cluster component error logs%n               list-members: print leader memberId, active members list, and passive members list%n              remove-member: [memberId] requests removal of a member specified in memberId%n             remove-passive: [memberId] requests removal of passive member specified in memberId%n               backup-query: [delay] get time of next backup query or set time of next backup query%n invalidate-latest-snapshot: Mark the latest snapshot as a invalid so previous is loaded%n                   snapshot: Trigger a snapshot on the leader%n                    suspend: Suspend reading from the ingress channel%n                     resume: Resume reading from the ingress channel%n                   shutdown: Do an orderly stop of the cluster with a snapshot%n                      abort: Stop the cluster without a snapshot.%n", new Object[0]);
        out.flush();
    }
}

