/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.DirectBufferVector;
import io.aeron.FragmentAssembler;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.client.ControlledEgressListener;
import io.aeron.cluster.client.EgressListener;
import io.aeron.cluster.client.EgressPoller;
import io.aeron.cluster.codecs.ChallengeResponseEncoder;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeaderEventDecoder;
import io.aeron.cluster.codecs.SessionCloseRequestEncoder;
import io.aeron.cluster.codecs.SessionConnectRequestEncoder;
import io.aeron.cluster.codecs.SessionEventDecoder;
import io.aeron.cluster.codecs.SessionKeepAliveEncoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.exceptions.TimeoutException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.security.AuthenticationException;
import io.aeron.security.CredentialsSupplier;
import io.aeron.security.NullCredentialsSupplier;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.agrona.AsciiEncoding;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;

public final class AeronCluster
implements AutoCloseable {
    public static final int SESSION_HEADER_LENGTH = 32;
    private static final int SEND_ATTEMPTS = 3;
    private static final int FRAGMENT_LIMIT = 10;
    private final long clusterSessionId;
    private long leadershipTermId;
    private int leaderMemberId;
    private boolean isClosed;
    private final Context ctx;
    private final Subscription subscription;
    private Publication publication;
    private final IdleStrategy idleStrategy;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final UnsafeBuffer headerBuffer = new UnsafeBuffer(new byte[32]);
    private final DirectBufferVector headerVector = new DirectBufferVector((DirectBuffer)this.headerBuffer, 0, 32);
    private final UnsafeBuffer keepaliveMsgBuffer;
    private final MessageHeaderEncoder messageHeaderEncoder;
    private final SessionMessageHeaderEncoder sessionMessageHeaderEncoder = new SessionMessageHeaderEncoder();
    private final SessionKeepAliveEncoder sessionKeepAliveEncoder = new SessionKeepAliveEncoder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionMessageHeaderDecoder sessionMessageHeaderDecoder = new SessionMessageHeaderDecoder();
    private final NewLeaderEventDecoder newLeaderEventDecoder = new NewLeaderEventDecoder();
    private final SessionEventDecoder sessionEventDecoder = new SessionEventDecoder();
    private final FragmentAssembler fragmentAssembler;
    private final EgressListener egressListener;
    private final ControlledFragmentAssembler controlledFragmentAssembler;
    private final ControlledEgressListener controlledEgressListener;
    private Int2ObjectHashMap<MemberIngress> endpointByIdMap;

    public static AeronCluster connect() {
        return AeronCluster.connect(new Context());
    }

    public static AeronCluster connect(Context ctx) {
        Subscription subscription = null;
        AsyncConnect asyncConnect = null;
        try {
            AeronCluster aeronCluster;
            ctx.conclude();
            Aeron aeron = ctx.aeron();
            subscription = aeron.addSubscription(ctx.egressChannel(), ctx.egressStreamId());
            long deadlineNs = aeron.context().nanoClock().nanoTime() + ctx.messageTimeoutNs();
            IdleStrategy idleStrategy = ctx.idleStrategy();
            asyncConnect = new AsyncConnect(ctx, subscription, deadlineNs);
            AgentInvoker aeronClientInvoker = aeron.conductorAgentInvoker();
            int step = asyncConnect.step();
            while (null == (aeronCluster = asyncConnect.poll())) {
                if (null != aeronClientInvoker) {
                    aeronClientInvoker.invoke();
                }
                if (step != asyncConnect.step()) {
                    step = asyncConnect.step();
                    idleStrategy.reset();
                    continue;
                }
                idleStrategy.idle();
            }
            return aeronCluster;
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (!ctx.ownsAeronClient()) {
                CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{subscription, asyncConnect});
            }
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static AsyncConnect asyncConnect() {
        return AeronCluster.asyncConnect(new Context());
    }

    public static AsyncConnect asyncConnect(Context ctx) {
        Subscription subscription = null;
        try {
            ctx.conclude();
            long deadlineNs = ctx.aeron().context().nanoClock().nanoTime() + ctx.messageTimeoutNs();
            subscription = ctx.aeron().addSubscription(ctx.egressChannel(), ctx.egressStreamId());
            return new AsyncConnect(ctx, subscription, deadlineNs);
        }
        catch (Exception ex) {
            if (!ctx.ownsAeronClient()) {
                CloseHelper.quietClose(subscription);
            }
            ctx.close();
            throw ex;
        }
    }

    AeronCluster(Context ctx, MessageHeaderEncoder messageHeaderEncoder, Publication publication, Subscription subscription, Int2ObjectHashMap<MemberIngress> endpointByIdMap, long clusterSessionId, long leadershipTermId, int leaderMemberId) {
        this.ctx = ctx;
        this.messageHeaderEncoder = messageHeaderEncoder;
        this.subscription = subscription;
        this.endpointByIdMap = endpointByIdMap;
        this.clusterSessionId = clusterSessionId;
        this.leadershipTermId = leadershipTermId;
        this.leaderMemberId = leaderMemberId;
        this.publication = publication;
        this.idleStrategy = ctx.idleStrategy();
        this.egressListener = ctx.egressListener();
        this.fragmentAssembler = new FragmentAssembler(this::onFragment, 0, ctx.isDirectAssemblers());
        this.controlledEgressListener = ctx.controlledEgressListener();
        this.controlledFragmentAssembler = new ControlledFragmentAssembler(this::onControlledFragment, 0, ctx.isDirectAssemblers());
        this.sessionMessageHeaderEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.headerBuffer, 0, messageHeaderEncoder).clusterSessionId(clusterSessionId).leadershipTermId(leadershipTermId);
        this.keepaliveMsgBuffer = new UnsafeBuffer(new byte[24]);
        this.sessionKeepAliveEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.keepaliveMsgBuffer, 0, messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(clusterSessionId);
    }

    @Override
    public void close() {
        if (null != this.publication && this.publication.isConnected() && !this.isClosed) {
            this.closeSession();
        }
        if (!this.ctx.ownsAeronClient()) {
            ErrorHandler errorHandler = this.ctx.errorHandler();
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.subscription);
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.publication);
        }
        this.isClosed = true;
        this.ctx.close();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Context context() {
        return this.ctx;
    }

    public long clusterSessionId() {
        return this.clusterSessionId;
    }

    public long leadershipTermId() {
        return this.leadershipTermId;
    }

    public int leaderMemberId() {
        return this.leaderMemberId;
    }

    public Publication ingressPublication() {
        return this.publication;
    }

    public Subscription egressSubscription() {
        return this.subscription;
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        long offset = this.publication.tryClaim(length + 32, bufferClaim);
        if (offset > 0L) {
            bufferClaim.putBytes((DirectBuffer)this.headerBuffer, 0, 32);
        }
        return offset;
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.publication.offer((DirectBuffer)this.headerBuffer, 0, 32, buffer, offset, length, null);
    }

    public long offer(DirectBufferVector[] vectors) {
        vectors[0] = this.headerVector;
        return this.publication.offer(vectors, null);
    }

    public boolean sendKeepAlive() {
        this.idleStrategy.reset();
        int attempts = 3;
        while (true) {
            long result;
            if ((result = this.publication.offer((DirectBuffer)this.keepaliveMsgBuffer, 0, this.keepaliveMsgBuffer.capacity(), null)) > 0L) {
                return true;
            }
            if (result == -4L) {
                throw new ClusterException("ingress publication is closed");
            }
            if (result == -5L) {
                throw new ClusterException("max position exceeded");
            }
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
        }
        return false;
    }

    public int pollEgress() {
        int fragments = this.subscription.poll((FragmentHandler)this.fragmentAssembler, 10);
        if (this.isClosed) {
            this.close();
        }
        return fragments;
    }

    public int controlledPollEgress() {
        int fragments = this.subscription.controlledPoll((ControlledFragmentHandler)this.controlledFragmentAssembler, 10);
        if (this.isClosed) {
            this.close();
        }
        return fragments;
    }

    public void onNewLeader(long clusterSessionId, long leadershipTermId, int leaderMemberId, String ingressEndpoints) {
        if (clusterSessionId != this.clusterSessionId) {
            throw new ClusterException("invalid clusterSessionId=" + clusterSessionId + " expected " + this.clusterSessionId);
        }
        this.leadershipTermId = leadershipTermId;
        this.leaderMemberId = leaderMemberId;
        this.sessionMessageHeaderEncoder.leadershipTermId(leadershipTermId);
        this.sessionKeepAliveEncoder.leadershipTermId(leadershipTermId);
        if (this.ctx.ingressEndpoints() != null) {
            CloseHelper.close((AutoCloseable)this.publication);
            this.ctx.ingressEndpoints(ingressEndpoints);
            this.updateMemberEndpoints(ingressEndpoints, leaderMemberId);
        }
        this.fragmentAssembler.clear();
        this.controlledFragmentAssembler.clear();
        this.egressListener.onNewLeader(clusterSessionId, leadershipTermId, leaderMemberId, ingressEndpoints);
        this.controlledEgressListener.onNewLeader(clusterSessionId, leadershipTermId, leaderMemberId, ingressEndpoints);
    }

    static Int2ObjectHashMap<MemberIngress> parseIngressEndpoints(String endpoints) {
        Int2ObjectHashMap endpointByIdMap = new Int2ObjectHashMap();
        if (null != endpoints) {
            for (String endpoint : endpoints.split(",")) {
                int i = endpoint.indexOf(61);
                if (-1 == i) {
                    throw new ConfigurationException("endpoint missing '=' separator: " + endpoints);
                }
                int memberId = AsciiEncoding.parseIntAscii((CharSequence)endpoint, (int)0, (int)i);
                endpointByIdMap.put(memberId, (Object)new MemberIngress(memberId, endpoint.substring(i + 1)));
            }
        }
        return endpointByIdMap;
    }

    private void updateMemberEndpoints(String ingressEndpoints, int leaderMemberId) {
        Int2ObjectHashMap<MemberIngress> map = AeronCluster.parseIngressEndpoints(ingressEndpoints);
        MemberIngress existingLeader = (MemberIngress)this.endpointByIdMap.get(leaderMemberId);
        MemberIngress newLeader = (MemberIngress)map.get(leaderMemberId);
        if (null != existingLeader && null != existingLeader.publication && existingLeader.endpoint.equals(newLeader.endpoint)) {
            newLeader.publication = existingLeader.publication;
            this.publication = existingLeader.publication;
            existingLeader.publication = null;
        }
        if (null == newLeader.publication) {
            ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.ingressChannel());
            channelUri.put("endpoint", newLeader.endpoint);
            newLeader.publication = this.publication = AeronCluster.addIngressPublication(this.ctx, channelUri.toString(), this.ctx.ingressStreamId());
        }
        CloseHelper.closeAll((Collection)this.endpointByIdMap.values());
        this.endpointByIdMap = map;
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (1 == templateId) {
            this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.sessionMessageHeaderDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.egressListener.onMessage(sessionId, this.sessionMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
        } else if (6 == templateId) {
            this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.newLeaderEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.ingressEndpoints());
            }
        } else if (2 == templateId) {
            this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.sessionEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                EventCode code = this.sessionEventDecoder.code();
                if (EventCode.CLOSED == code) {
                    this.isClosed = true;
                }
                this.egressListener.onSessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), code, this.sessionEventDecoder.detail());
            }
        }
    }

    private ControlledFragmentHandler.Action onControlledFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        if (1 == templateId) {
            this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.sessionMessageHeaderDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                return this.controlledEgressListener.onMessage(sessionId, this.sessionMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
        } else if (6 == templateId) {
            this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.newLeaderEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                this.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.ingressEndpoints());
                return ControlledFragmentHandler.Action.COMMIT;
            }
        } else if (2 == templateId) {
            this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long sessionId = this.sessionEventDecoder.clusterSessionId();
            if (sessionId == this.clusterSessionId) {
                EventCode code = this.sessionEventDecoder.code();
                if (EventCode.CLOSED == code) {
                    this.isClosed = true;
                }
                this.controlledEgressListener.onSessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), code, this.sessionEventDecoder.detail());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void closeSession() {
        this.idleStrategy.reset();
        int length = 24;
        SessionCloseRequestEncoder sessionCloseRequestEncoder = new SessionCloseRequestEncoder();
        int attempts = 3;
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) {
                sessionCloseRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(this.leadershipTermId).clusterSessionId(this.clusterSessionId);
                this.bufferClaim.commit();
                break;
            }
            if (--attempts <= 0) break;
            this.idleStrategy.idle();
        }
    }

    private static Publication addIngressPublication(Context ctx, String channel, int streamId) {
        if (ctx.isIngressExclusive()) {
            return ctx.aeron().addExclusivePublication(channel, streamId);
        }
        return ctx.aeron().addPublication(channel, streamId);
    }

    static final class MemberIngress
    implements AutoCloseable {
        final int memberId;
        final String endpoint;
        Publication publication;

        MemberIngress(int memberId, String endpoint) {
            this.memberId = memberId;
            this.endpoint = endpoint;
        }

        @Override
        public void close() {
            CloseHelper.close((AutoCloseable)this.publication);
            this.publication = null;
        }

        public String toString() {
            return "MemberIngress{memberId=" + this.memberId + ", endpoint='" + this.endpoint + '\'' + ", publication=" + this.publication + '}';
        }
    }

    public static final class AsyncConnect
    implements AutoCloseable {
        private final Subscription egressSubscription;
        private final long deadlineNs;
        private long correlationId = -1L;
        private long clusterSessionId;
        private long leadershipTermId;
        private int leaderMemberId;
        private int step = 0;
        private int messageLength = 0;
        private final Context ctx;
        private final NanoClock nanoClock;
        private final EgressPoller egressPoller;
        private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        private Int2ObjectHashMap<MemberIngress> memberByIdMap;
        private Publication ingressPublication;
        private RegistrationException registrationException;

        AsyncConnect(Context ctx, Subscription egressSubscription, long deadlineNs) {
            this.ctx = ctx;
            this.memberByIdMap = AeronCluster.parseIngressEndpoints(ctx.ingressEndpoints());
            this.egressSubscription = egressSubscription;
            this.egressPoller = new EgressPoller(egressSubscription, 10);
            this.nanoClock = ctx.aeron().context().nanoClock();
            this.deadlineNs = deadlineNs;
        }

        @Override
        public void close() {
            if (5 != this.step) {
                ErrorHandler errorHandler = this.ctx.errorHandler();
                CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.ingressPublication);
                CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.egressSubscription);
                CloseHelper.closeAll((ErrorHandler)errorHandler, (Collection)this.memberByIdMap.values());
                this.ctx.close();
            }
        }

        public int step() {
            return this.step;
        }

        private void step(int newStep) {
            this.step = newStep;
        }

        public AeronCluster poll() {
            AeronCluster aeronCluster = null;
            this.checkDeadline();
            switch (this.step) {
                case 0: {
                    this.createIngressPublications();
                    break;
                }
                case 1: {
                    this.awaitPublicationConnected();
                    break;
                }
                case 2: {
                    this.sendMessage();
                    break;
                }
                case 3: {
                    this.pollResponse();
                }
            }
            if (4 == this.step) {
                aeronCluster = this.newInstance();
                this.ingressPublication = null;
                this.memberByIdMap.remove(this.leaderMemberId);
                CloseHelper.closeAll((Collection)this.memberByIdMap.values());
                this.step(5);
            }
            return aeronCluster;
        }

        private void checkDeadline() {
            if (this.deadlineNs - this.nanoClock.nanoTime() < 0L) {
                TimeoutException ex = new TimeoutException("cluster connect timeout: step=" + this.step + " ingressChannel=" + this.ctx.ingressChannel() + " ingressPublication=" + this.ingressPublication + " egress.isConnected=" + this.egressSubscription.isConnected() + " responseChannel=" + this.egressSubscription.tryResolveChannelEndpointPort());
                if (null != this.registrationException) {
                    ex.addSuppressed((Throwable)this.registrationException);
                }
                throw ex;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new AeronException("unexpected interrupt");
            }
        }

        private void createIngressPublications() {
            if (null == this.ctx.ingressEndpoints()) {
                this.ingressPublication = AeronCluster.addIngressPublication(this.ctx, this.ctx.ingressChannel(), this.ctx.ingressStreamId());
            } else {
                int publicationCount = 0;
                ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.ingressChannel());
                for (MemberIngress member : this.memberByIdMap.values()) {
                    try {
                        channelUri.put("endpoint", member.endpoint);
                        member.publication = AeronCluster.addIngressPublication(this.ctx, channelUri.toString(), this.ctx.ingressStreamId());
                        ++publicationCount;
                    }
                    catch (RegistrationException ex) {
                        this.registrationException = ex;
                    }
                }
                if (0 == publicationCount && null != this.registrationException) {
                    throw this.registrationException;
                }
            }
            this.step(1);
        }

        private void awaitPublicationConnected() {
            String responseChannel = this.egressSubscription.tryResolveChannelEndpointPort();
            if (null != responseChannel) {
                if (null == this.ingressPublication) {
                    for (MemberIngress member : this.memberByIdMap.values()) {
                        if (null == member.publication || !member.publication.isConnected()) continue;
                        this.ingressPublication = member.publication;
                        this.prepareConnectRequest(responseChannel);
                        break;
                    }
                } else if (this.ingressPublication.isConnected()) {
                    this.prepareConnectRequest(responseChannel);
                }
            }
        }

        private void prepareConnectRequest(String responseChannel) {
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            byte[] encodedCredentials = this.ctx.credentialsSupplier().encodedCredentials();
            SessionConnectRequestEncoder encoder = new SessionConnectRequestEncoder().wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(this.correlationId).responseStreamId(this.ctx.egressStreamId()).version(Configuration.PROTOCOL_SEMANTIC_VERSION).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
            this.messageLength = 8 + encoder.encodedLength();
            this.step(2);
        }

        private void sendMessage() {
            long result = this.ingressPublication.offer((DirectBuffer)this.buffer, 0, this.messageLength);
            if (result > 0L) {
                this.step(3);
            } else if (-4L == result || -1L == result) {
                throw new ClusterException("unexpected loss of connection to cluster");
            }
        }

        private void pollResponse() {
            if (this.egressPoller.poll() > 0 && this.egressPoller.isPollComplete() && this.egressPoller.correlationId() == this.correlationId) {
                if (this.egressPoller.isChallenged()) {
                    this.correlationId = -1L;
                    this.clusterSessionId = this.egressPoller.clusterSessionId();
                    this.prepareChallengeResponse(this.ctx.credentialsSupplier().onChallenge(this.egressPoller.encodedChallenge()));
                    this.step(2);
                    return;
                }
                switch (this.egressPoller.eventCode()) {
                    case OK: {
                        this.leadershipTermId = this.egressPoller.leadershipTermId();
                        this.leaderMemberId = this.egressPoller.leaderMemberId();
                        this.clusterSessionId = this.egressPoller.clusterSessionId();
                        this.step(4);
                        break;
                    }
                    case ERROR: {
                        throw new ClusterException(this.egressPoller.detail());
                    }
                    case REDIRECT: {
                        this.updateMembers();
                        break;
                    }
                    case AUTHENTICATION_REJECTED: {
                        throw new AuthenticationException(this.egressPoller.detail());
                    }
                }
            }
        }

        private void prepareChallengeResponse(byte[] encodedCredentials) {
            this.correlationId = this.ctx.aeron().nextCorrelationId();
            ChallengeResponseEncoder encoder = new ChallengeResponseEncoder().wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(this.correlationId).clusterSessionId(this.clusterSessionId).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
            this.messageLength = 8 + encoder.encodedLength();
            this.step(2);
        }

        private void updateMembers() {
            this.leaderMemberId = this.egressPoller.leaderMemberId();
            MemberIngress leader = (MemberIngress)this.memberByIdMap.get(this.leaderMemberId);
            if (null != leader) {
                this.ingressPublication = leader.publication;
                leader.publication = null;
            }
            CloseHelper.closeAll((Collection)this.memberByIdMap.values());
            this.memberByIdMap = AeronCluster.parseIngressEndpoints(this.egressPoller.detail());
            if (null == this.ingressPublication) {
                MemberIngress member = (MemberIngress)this.memberByIdMap.get(this.leaderMemberId);
                ChannelUri channelUri = ChannelUri.parse((CharSequence)this.ctx.ingressChannel());
                channelUri.put("endpoint", member.endpoint);
                this.ingressPublication = AeronCluster.addIngressPublication(this.ctx, channelUri.toString(), this.ctx.ingressStreamId());
            }
            this.step(1);
        }

        private AeronCluster newInstance() {
            return new AeronCluster(this.ctx, this.messageHeaderEncoder, this.ingressPublication, this.egressSubscription, this.memberByIdMap, this.clusterSessionId, this.leadershipTermId, this.leaderMemberId);
        }
    }

    public static final class Context
    implements Cloneable {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private long messageTimeoutNs = Configuration.messageTimeoutNs();
        private String ingressEndpoints = Configuration.ingressEndpoints();
        private String ingressChannel = Configuration.ingressChannel();
        private int ingressStreamId = Configuration.ingressStreamId();
        private String egressChannel = Configuration.egressChannel();
        private int egressStreamId = Configuration.egressStreamId();
        private IdleStrategy idleStrategy;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private CredentialsSupplier credentialsSupplier;
        private boolean ownsAeronClient = false;
        private boolean isIngressExclusive = true;
        private ErrorHandler errorHandler = Aeron.Configuration.DEFAULT_ERROR_HANDLER;
        private boolean isDirectAssemblers = false;
        private EgressListener egressListener;
        private ControlledEgressListener controlledEgressListener;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            if (null == this.aeron) {
                this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler));
                this.ownsAeronClient = true;
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new BackoffIdleStrategy(1L, 10L, 1000L, 1000L);
            }
            if (null == this.credentialsSupplier) {
                this.credentialsSupplier = new NullCredentialsSupplier();
            }
            if (null == this.egressListener) {
                this.egressListener = (clusterSessionId, timestamp, buffer, offset, length, header) -> {
                    throw new ConfigurationException("egressListener must be specified on AeronCluster.Context");
                };
            }
            if (null == this.controlledEgressListener) {
                this.controlledEgressListener = (clusterSessionId, timestamp, buffer, offset, length, header) -> {
                    throw new ConfigurationException("controlledEgressListener must be specified on AeronCluster.Context");
                };
            }
        }

        public Context messageTimeoutNs(long messageTimeoutNs) {
            this.messageTimeoutNs = messageTimeoutNs;
            return this;
        }

        public long messageTimeoutNs() {
            return CommonContext.checkDebugTimeout((long)this.messageTimeoutNs, (TimeUnit)TimeUnit.NANOSECONDS);
        }

        public Context ingressEndpoints(String clusterMembers) {
            this.ingressEndpoints = clusterMembers;
            return this;
        }

        public String ingressEndpoints() {
            return this.ingressEndpoints;
        }

        public Context ingressChannel(String channel) {
            this.ingressChannel = channel;
            return this;
        }

        public String ingressChannel() {
            return this.ingressChannel;
        }

        public Context ingressStreamId(int streamId) {
            this.ingressStreamId = streamId;
            return this;
        }

        public int ingressStreamId() {
            return this.ingressStreamId;
        }

        public Context egressChannel(String channel) {
            this.egressChannel = channel;
            return this;
        }

        public String egressChannel() {
            return this.egressChannel;
        }

        public Context egressStreamId(int streamId) {
            this.egressStreamId = streamId;
            return this;
        }

        public int egressStreamId() {
            return this.egressStreamId;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context isIngressExclusive(boolean isIngressExclusive) {
            this.isIngressExclusive = isIngressExclusive;
            return this;
        }

        public boolean isIngressExclusive() {
            return this.isIngressExclusive;
        }

        public Context credentialsSupplier(CredentialsSupplier credentialsSupplier) {
            this.credentialsSupplier = credentialsSupplier;
            return this;
        }

        public CredentialsSupplier credentialsSupplier() {
            return this.credentialsSupplier;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context isDirectAssemblers(boolean isDirectAssemblers) {
            this.isDirectAssemblers = isDirectAssemblers;
            return this;
        }

        public boolean isDirectAssemblers() {
            return this.isDirectAssemblers;
        }

        public Context egressListener(EgressListener listener) {
            this.egressListener = listener;
            return this;
        }

        public EgressListener egressListener() {
            return this.egressListener;
        }

        public Context controlledEgressListener(ControlledEgressListener listener) {
            this.controlledEgressListener = listener;
            return this;
        }

        public ControlledEgressListener controlledEgressListener() {
            return this.controlledEgressListener;
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close((AutoCloseable)this.aeron);
            }
        }
    }

    public static final class Configuration {
        public static final int PROTOCOL_MAJOR_VERSION = 0;
        public static final int PROTOCOL_MINOR_VERSION = 1;
        public static final int PROTOCOL_PATCH_VERSION = 1;
        public static final int PROTOCOL_SEMANTIC_VERSION = SemanticVersion.compose((int)0, (int)1, (int)1);
        public static final String MESSAGE_TIMEOUT_PROP_NAME = "aeron.cluster.message.timeout";
        public static final long MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String INGRESS_ENDPOINTS_PROP_NAME = "aeron.cluster.ingress.endpoints";
        public static final String INGRESS_ENDPOINTS_DEFAULT = null;
        public static final String INGRESS_CHANNEL_PROP_NAME = "aeron.cluster.ingress.channel";
        public static final String INGRESS_CHANNEL_DEFAULT = null;
        public static final String INGRESS_STREAM_ID_PROP_NAME = "aeron.cluster.ingress.stream.id";
        public static final int INGRESS_STREAM_ID_DEFAULT = 101;
        public static final String EGRESS_CHANNEL_PROP_NAME = "aeron.cluster.egress.channel";
        public static final String EGRESS_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:0";
        public static final String EGRESS_STREAM_ID_PROP_NAME = "aeron.cluster.egress.stream.id";
        public static final int EGRESS_STREAM_ID_DEFAULT = 102;

        public static long messageTimeoutNs() {
            return SystemUtil.getDurationInNanos((String)MESSAGE_TIMEOUT_PROP_NAME, (long)MESSAGE_TIMEOUT_DEFAULT_NS);
        }

        public static String ingressEndpoints() {
            return System.getProperty(INGRESS_ENDPOINTS_PROP_NAME, INGRESS_ENDPOINTS_DEFAULT);
        }

        public static String ingressChannel() {
            return System.getProperty(INGRESS_CHANNEL_PROP_NAME, INGRESS_CHANNEL_DEFAULT);
        }

        public static int ingressStreamId() {
            return Integer.getInteger(INGRESS_STREAM_ID_PROP_NAME, 101);
        }

        public static String egressChannel() {
            return System.getProperty(EGRESS_CHANNEL_PROP_NAME, EGRESS_CHANNEL_DEFAULT);
        }

        public static int egressStreamId() {
            return Integer.getInteger(EGRESS_STREAM_ID_PROP_NAME, 102);
        }
    }
}

