/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.AdminRequestDecoder;
import io.aeron.cluster.codecs.ChallengeResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionCloseRequestDecoder;
import io.aeron.cluster.codecs.SessionConnectRequestDecoder;
import io.aeron.cluster.codecs.SessionKeepAliveDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;

class IngressAdapter
implements ControlledFragmentHandler,
AutoCloseable {
    private final int fragmentPollLimit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionConnectRequestDecoder connectRequestDecoder = new SessionConnectRequestDecoder();
    private final SessionCloseRequestDecoder closeRequestDecoder = new SessionCloseRequestDecoder();
    private final SessionMessageHeaderDecoder sessionMessageHeaderDecoder = new SessionMessageHeaderDecoder();
    private final SessionKeepAliveDecoder sessionKeepAliveDecoder = new SessionKeepAliveDecoder();
    private final ChallengeResponseDecoder challengeResponseDecoder = new ChallengeResponseDecoder();
    private final AdminRequestDecoder adminRequestDecoder = new AdminRequestDecoder();
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler((ControlledFragmentHandler)this);
    private final ConsensusModuleAgent consensusModuleAgent;
    private Subscription subscription;

    IngressAdapter(int fragmentPollLimit, ConsensusModuleAgent consensusModuleAgent) {
        this.fragmentPollLimit = fragmentPollLimit;
        this.consensusModuleAgent = consensusModuleAgent;
    }

    @Override
    public void close() {
        Subscription subscription = this.subscription;
        this.subscription = null;
        this.fragmentAssembler.clear();
        if (null != subscription) {
            subscription.close();
        }
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 1) {
            this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            return this.consensusModuleAgent.onIngressMessage(this.sessionMessageHeaderDecoder.leadershipTermId(), this.sessionMessageHeaderDecoder.clusterSessionId(), buffer, offset + 32, length - 32);
        }
        switch (templateId) {
            case 3: {
                byte[] credentials;
                this.connectRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.connectRequestDecoder.responseChannel();
                int credentialsLength = this.connectRequestDecoder.encodedCredentialsLength();
                if (credentialsLength > 0) {
                    credentials = new byte[credentialsLength];
                    this.connectRequestDecoder.getEncodedCredentials(credentials, 0, credentialsLength);
                } else {
                    credentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                }
                this.consensusModuleAgent.onSessionConnect(this.connectRequestDecoder.correlationId(), this.connectRequestDecoder.responseStreamId(), this.connectRequestDecoder.version(), responseChannel, credentials);
                break;
            }
            case 4: {
                this.closeRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onSessionClose(this.closeRequestDecoder.leadershipTermId(), this.closeRequestDecoder.clusterSessionId());
                break;
            }
            case 5: {
                this.sessionKeepAliveDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onSessionKeepAlive(this.sessionKeepAliveDecoder.leadershipTermId(), this.sessionKeepAliveDecoder.clusterSessionId());
                break;
            }
            case 8: {
                this.challengeResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                byte[] credentials = new byte[this.challengeResponseDecoder.encodedCredentialsLength()];
                this.challengeResponseDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                this.consensusModuleAgent.onChallengeResponse(this.challengeResponseDecoder.correlationId(), this.challengeResponseDecoder.clusterSessionId(), credentials);
                break;
            }
            case 26: {
                this.adminRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                int payloadOffset = this.adminRequestDecoder.offset() + this.adminRequestDecoder.encodedLength() + AdminRequestDecoder.payloadHeaderLength();
                this.consensusModuleAgent.onAdminRequest(this.adminRequestDecoder.leadershipTermId(), this.adminRequestDecoder.clusterSessionId(), this.adminRequestDecoder.correlationId(), this.adminRequestDecoder.requestType(), buffer, payloadOffset, this.adminRequestDecoder.payloadLength());
                break;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    void connect(Subscription subscription) {
        this.subscription = subscription;
    }

    int poll() {
        if (null != this.subscription) {
            return this.subscription.controlledPoll((ControlledFragmentHandler)this.fragmentAssembler, this.fragmentPollLimit);
        }
        return 0;
    }

    void freeSessionBuffer(int imageSessionId) {
        this.fragmentAssembler.freeSessionBuffer(imageSessionId);
    }
}

