/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.status.RecordingPos;
import io.aeron.cluster.client.ClusterException;
import io.aeron.exceptions.AeronException;
import org.agrona.concurrent.status.CountersReader;

final class LogReplication {
    private final long replicationId;
    private final long stopPosition;
    private final long progressCheckTimeoutNs;
    private final long progressCheckIntervalNs;
    private int recordingPositionCounterId = -1;
    private long recordingId;
    private long position = -1L;
    private long progressDeadlineNs;
    private long progressCheckDeadlineNs;
    private final AeronArchive archive;
    private RecordingSignal lastRecordingSignal = RecordingSignal.NULL_VAL;
    private boolean isStopped = false;

    LogReplication(AeronArchive archive, long srcRecordingId, long dstRecordingId, long stopPosition, String srcArchiveChannel, String replicationChannel, long progressCheckTimeoutNs, long progressCheckIntervalNs, long nowNs) {
        this.archive = archive;
        this.stopPosition = stopPosition;
        this.progressCheckTimeoutNs = progressCheckTimeoutNs;
        this.progressCheckIntervalNs = progressCheckIntervalNs;
        this.progressDeadlineNs = nowNs + progressCheckTimeoutNs;
        this.progressCheckDeadlineNs = nowNs + progressCheckIntervalNs;
        this.replicationId = archive.replicate(srcRecordingId, dstRecordingId, stopPosition, archive.context().controlRequestStreamId(), srcArchiveChannel, null, replicationChannel);
    }

    boolean isDone(long nowNs) {
        if (this.position == this.stopPosition && this.isStopped) {
            return true;
        }
        if (this.position > this.stopPosition) {
            throw new ClusterException("log replication has progressed past stopPosition: " + this);
        }
        if (nowNs >= this.progressCheckDeadlineNs) {
            this.progressCheckDeadlineNs = nowNs + this.progressCheckIntervalNs;
            if (-1 != this.recordingPositionCounterId) {
                CountersReader counters = this.archive.context().aeron().countersReader();
                long recordingPosition = counters.getCounterValue(this.recordingPositionCounterId);
                if (RecordingPos.isActive((CountersReader)counters, (int)this.recordingPositionCounterId, (long)this.recordingId) && recordingPosition > this.position) {
                    this.position = recordingPosition;
                    this.progressDeadlineNs = nowNs + this.progressCheckTimeoutNs;
                }
            }
        }
        if (nowNs >= this.progressDeadlineNs) {
            if (this.position < this.stopPosition) {
                throw new ClusterException("log replication has not progressed: " + this, AeronException.Category.WARN);
            }
            throw new ClusterException("log replication failed to stop: " + this);
        }
        return false;
    }

    long position() {
        return this.position;
    }

    long recordingId() {
        return this.recordingId;
    }

    void close() {
        if (!this.isStopped) {
            try {
                this.isStopped = true;
                this.archive.tryStopReplication(this.replicationId);
            }
            catch (Exception ex) {
                throw new ClusterException("failed to stop log replication", ex, AeronException.Category.WARN);
            }
        }
    }

    void onSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (correlationId == this.replicationId) {
            switch (signal) {
                case EXTEND: {
                    CountersReader counters = this.archive.context().aeron().countersReader();
                    this.recordingPositionCounterId = RecordingPos.findCounterIdByRecording((CountersReader)counters, (long)recordingId);
                    break;
                }
                case DELETE: {
                    throw new ClusterException("recording was deleted during replication: " + this);
                }
                case STOP: {
                    this.isStopped = true;
                }
            }
            this.recordingId = recordingId;
            this.lastRecordingSignal = signal;
            if (-1L != position) {
                this.position = position;
            }
        }
    }

    public String toString() {
        return "LogReplication{replicationId=" + this.replicationId + ", recordingPositionCounterId=" + this.recordingPositionCounterId + ", recordingId=" + this.recordingId + ", position=" + this.position + ", stopPosition=" + this.stopPosition + ", stopped=" + this.isStopped + ", lastRecordingSignal=" + this.lastRecordingSignal + ", progressDeadlineNs=" + this.progressDeadlineNs + ", progressCheckDeadlineNs=" + this.progressCheckDeadlineNs + ", progressCheckTimeoutNs=" + this.progressCheckTimeoutNs + ", progressCheckIntervalNs=" + this.progressCheckIntervalNs + '}';
    }
}

