/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.CommonContext;
import io.aeron.RethrowingErrorHandler;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.agrona.CloseHelper;
import org.agrona.DelegatingErrorHandler;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.StatusIndicator;

public final class ClusteredServiceContainer
implements AutoCloseable {
    private final Context ctx;
    private final AgentRunner serviceAgentRunner;

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        try (ClusteredServiceContainer container = ClusteredServiceContainer.launch();){
            container.context().shutdownSignalBarrier().await();
            System.out.println("Shutdown ClusteredServiceContainer...");
        }
    }

    private ClusteredServiceContainer(Context ctx) {
        this.ctx = ctx;
        try {
            ctx.conclude();
        }
        catch (Exception ex) {
            if (null != ctx.markFile) {
                ctx.markFile.signalFailedStart();
            }
            ctx.close();
            throw ex;
        }
        ClusteredServiceAgent agent = new ClusteredServiceAgent(ctx);
        this.serviceAgentRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), (Agent)agent);
    }

    public static ClusteredServiceContainer launch() {
        return ClusteredServiceContainer.launch(new Context());
    }

    public static ClusteredServiceContainer launch(Context ctx) {
        ClusteredServiceContainer clusteredServiceContainer = new ClusteredServiceContainer(ctx);
        AgentRunner.startOnThread((AgentRunner)clusteredServiceContainer.serviceAgentRunner, (ThreadFactory)ctx.threadFactory());
        return clusteredServiceContainer;
    }

    public Context context() {
        return this.ctx;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.serviceAgentRunner);
    }

    public static final class Context
    implements Cloneable {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private int appVersion = SemanticVersion.compose((int)0, (int)0, (int)1);
        private int clusterId = Configuration.clusterId();
        private int serviceId = Configuration.serviceId();
        private String serviceName = Configuration.serviceName();
        private String replayChannel = Configuration.replayChannel();
        private int replayStreamId = Configuration.replayStreamId();
        private String controlChannel = Configuration.controlChannel();
        private int consensusModuleStreamId = Configuration.consensusModuleStreamId();
        private int serviceStreamId = Configuration.serviceStreamId();
        private String snapshotChannel = Configuration.snapshotChannel();
        private int snapshotStreamId = Configuration.snapshotStreamId();
        private int errorBufferLength = Configuration.errorBufferLength();
        private boolean isRespondingService = Configuration.isRespondingService();
        private int logFragmentLimit = Configuration.logFragmentLimit();
        private long cycleThresholdNs = Configuration.cycleThresholdNs();
        private CountDownLatch abortLatch;
        private ThreadFactory threadFactory;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private DelegatingErrorHandler delegatingErrorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private AeronArchive.Context archiveContext;
        private String clusterDirectoryName = Configuration.clusterDirName();
        private File clusterDir;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private DutyCycleTracker dutyCycleTracker;
        private boolean ownsAeronClient;
        private ClusteredService clusteredService;
        private ShutdownSignalBarrier shutdownSignalBarrier;
        private Runnable terminationHook;
        private ClusterMarkFile markFile;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            if (this.serviceId < 0 || this.serviceId > 127) {
                throw new ConfigurationException("service id outside allowed range (0-127): " + this.serviceId);
            }
            if (null == this.threadFactory) {
                this.threadFactory = Thread::new;
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = Configuration.idleStrategySupplier(null);
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null == this.clusterDir) {
                this.clusterDir = new File(this.clusterDirectoryName);
            }
            if (!this.clusterDir.exists() && !this.clusterDir.mkdirs()) {
                throw new ClusterException("failed to create cluster dir: " + this.clusterDir.getAbsolutePath());
            }
            if (null == this.markFile) {
                this.markFile = new ClusterMarkFile(new File(this.clusterDir, ClusterMarkFile.markFilenameForService(this.serviceId)), ClusterComponentType.CONTAINER, this.errorBufferLength, this.epochClock, 0L);
            }
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII);
            }
            this.errorHandler = CommonContext.setupErrorHandler((ErrorHandler)this.errorHandler, (DistinctErrorLog)this.errorLog);
            if (null == this.delegatingErrorHandler) {
                this.delegatingErrorHandler = Configuration.newDelegatingErrorHandler();
                if (null != this.delegatingErrorHandler) {
                    this.delegatingErrorHandler.next(this.errorHandler);
                    this.errorHandler = this.delegatingErrorHandler;
                }
            } else {
                this.delegatingErrorHandler.next(this.errorHandler);
                this.errorHandler = this.delegatingErrorHandler;
            }
            if (null == this.aeron) {
                this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).subscriberErrorHandler((ErrorHandler)RethrowingErrorHandler.INSTANCE).awaitingIdleStrategy((IdleStrategy)YieldingIdleStrategy.INSTANCE).epochClock(this.epochClock));
                this.ownsAeronClient = true;
            }
            if (!(this.aeron.context().subscriberErrorHandler() instanceof RethrowingErrorHandler)) {
                throw new ClusterException("Aeron client must use a RethrowingErrorHandler");
            }
            if (null == this.errorCounter) {
                String label = "Cluster Container Errors - clusterId=" + this.clusterId + " serviceId=" + this.serviceId;
                this.errorCounter = this.aeron.addCounter(215, label);
            }
            if (null == this.countedErrorHandler) {
                this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                if (this.ownsAeronClient) {
                    this.aeron.context().errorHandler((ErrorHandler)this.countedErrorHandler);
                }
            }
            if (null == this.dutyCycleTracker) {
                this.dutyCycleTracker = new DutyCycleStallTracker((AtomicCounter)this.aeron.addCounter(218, "Cluster container max cycle time (ns) - clusterId=" + this.clusterId + " serviceId=" + this.serviceId), (AtomicCounter)this.aeron.addCounter(219, "Cluster container work cycle time exceeded count: threshold=" + this.cycleThresholdNs + "ns - clusterId=" + this.clusterId + " serviceId=" + this.serviceId), this.cycleThresholdNs);
            }
            if (null == this.archiveContext) {
                this.archiveContext = new AeronArchive.Context().controlRequestChannel(AeronArchive.Configuration.localControlChannel()).controlResponseChannel(AeronArchive.Configuration.localControlChannel()).controlRequestStreamId(AeronArchive.Configuration.localControlStreamId());
            }
            if (!this.archiveContext.controlRequestChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            if (!this.archiveContext.controlResponseChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            this.archiveContext.aeron(this.aeron).ownsAeronClient(false).lock((Lock)NoOpLock.INSTANCE).errorHandler((ErrorHandler)this.countedErrorHandler);
            if (null == this.shutdownSignalBarrier) {
                this.shutdownSignalBarrier = new ShutdownSignalBarrier();
            }
            if (null == this.terminationHook) {
                this.terminationHook = () -> this.shutdownSignalBarrier.signalAll();
            }
            if (null == this.clusteredService) {
                this.clusteredService = Configuration.newClusteredService();
            }
            this.abortLatch = new CountDownLatch(this.aeron.conductorAgentInvoker() == null ? 1 : 0);
            this.concludeMarkFile();
        }

        public Context appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public int appVersion() {
            return this.appVersion;
        }

        public Context clusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int clusterId() {
            return this.clusterId;
        }

        public Context serviceId(int serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public int serviceId() {
            return this.serviceId;
        }

        public Context serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public Context replayChannel(String channel) {
            this.replayChannel = channel;
            return this;
        }

        public String replayChannel() {
            return this.replayChannel;
        }

        public Context replayStreamId(int streamId) {
            this.replayStreamId = streamId;
            return this;
        }

        public int replayStreamId() {
            return this.replayStreamId;
        }

        public Context controlChannel(String channel) {
            this.controlChannel = channel;
            return this;
        }

        public String controlChannel() {
            return this.controlChannel;
        }

        public Context serviceStreamId(int streamId) {
            this.serviceStreamId = streamId;
            return this;
        }

        public int serviceStreamId() {
            return this.serviceStreamId;
        }

        public Context consensusModuleStreamId(int streamId) {
            this.consensusModuleStreamId = streamId;
            return this;
        }

        public int consensusModuleStreamId() {
            return this.consensusModuleStreamId;
        }

        public Context snapshotChannel(String channel) {
            this.snapshotChannel = channel;
            return this;
        }

        public String snapshotChannel() {
            return this.snapshotChannel;
        }

        public Context snapshotStreamId(int streamId) {
            this.snapshotStreamId = streamId;
            return this;
        }

        public int snapshotStreamId() {
            return this.snapshotStreamId;
        }

        public Context isRespondingService(boolean isRespondingService) {
            this.isRespondingService = isRespondingService;
            return this;
        }

        public Context logFragmentLimit(int logFragmentLimit) {
            this.logFragmentLimit = logFragmentLimit;
            return this;
        }

        public int logFragmentLimit() {
            return this.logFragmentLimit;
        }

        public boolean isRespondingService() {
            return this.isRespondingService;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DelegatingErrorHandler delegatingErrorHandler() {
            return this.delegatingErrorHandler;
        }

        public Context delegatingErrorHandler(DelegatingErrorHandler delegatingErrorHandler) {
            this.delegatingErrorHandler = delegatingErrorHandler;
            return this;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public ClusteredService clusteredService() {
            return this.clusteredService;
        }

        public Context clusteredService(ClusteredService clusteredService) {
            this.clusteredService = clusteredService;
            return this;
        }

        public Context archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveContext() {
            return this.archiveContext;
        }

        public Context clusterDirectoryName(String clusterDirectoryName) {
            this.clusterDirectoryName = clusterDirectoryName;
            return this;
        }

        public String clusterDirectoryName() {
            return this.clusterDirectoryName;
        }

        public Context clusterDir(File clusterDir) {
            this.clusterDir = clusterDir;
            return this;
        }

        public File clusterDir() {
            return this.clusterDir;
        }

        public Context shutdownSignalBarrier(ShutdownSignalBarrier barrier) {
            this.shutdownSignalBarrier = barrier;
            return this;
        }

        public ShutdownSignalBarrier shutdownSignalBarrier() {
            return this.shutdownSignalBarrier;
        }

        public Context terminationHook(Runnable terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context clusterMarkFile(ClusterMarkFile markFile) {
            this.markFile = markFile;
            return this;
        }

        public ClusterMarkFile clusterMarkFile() {
            return this.markFile;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public Context cycleThresholdNs(long thresholdNs) {
            this.cycleThresholdNs = thresholdNs;
            return this;
        }

        public long cycleThresholdNs() {
            return this.cycleThresholdNs;
        }

        public Context dutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.dutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker dutyCycleTracker() {
            return this.dutyCycleTracker;
        }

        public void deleteDirectory() {
            if (null != this.clusterDir) {
                IoUtil.delete((File)this.clusterDir, (boolean)false);
            }
        }

        public void close() {
            CountedErrorHandler errorHandler = this.countedErrorHandler();
            if (this.ownsAeronClient) {
                CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.aeron);
            }
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.markFile);
        }

        CountDownLatch abortLatch() {
            return this.abortLatch;
        }

        private void concludeMarkFile() {
            ClusterMarkFile.checkHeaderLength(this.aeron.context().aeronDirectoryName(), this.controlChannel(), null, this.serviceName, null);
            MarkFileHeaderEncoder encoder = this.markFile.encoder();
            encoder.archiveStreamId(this.archiveContext.controlRequestStreamId()).serviceStreamId(this.serviceStreamId).consensusModuleStreamId(this.consensusModuleStreamId).ingressStreamId(-1).memberId(-1).serviceId(this.serviceId).clusterId(this.clusterId).aeronDirectory(this.aeron.context().aeronDirectoryName()).controlChannel(this.controlChannel).ingressChannel(null).serviceName(this.serviceName).authenticator(null);
            this.markFile.updateActivityTimestamp(this.epochClock.time());
            this.markFile.signalReady();
        }

        public String toString() {
            return "ClusteredServiceContainer.Context\n{\n    isConcluded=" + (1 == this.isConcluded) + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + '\'' + "\n    aeron=" + this.aeron + "\n    archiveContext=" + this.archiveContext + "\n    clusterDirectoryName='" + this.clusterDirectoryName + '\'' + "\n    clusterDir=" + this.clusterDir + "\n    appVersion=" + this.appVersion + "\n    clusterId=" + this.clusterId + "\n    serviceId=" + this.serviceId + "\n    serviceName='" + this.serviceName + '\'' + "\n    replayChannel='" + this.replayChannel + '\'' + "\n    replayStreamId=" + this.replayStreamId + "\n    controlChannel='" + this.controlChannel + '\'' + "\n    consensusModuleStreamId=" + this.consensusModuleStreamId + "\n    serviceStreamId=" + this.serviceStreamId + "\n    snapshotChannel='" + this.snapshotChannel + '\'' + "\n    snapshotStreamId=" + this.snapshotStreamId + "\n    errorBufferLength=" + this.errorBufferLength + "\n    isRespondingService=" + this.isRespondingService + "\n    logFragmentLimit=" + this.logFragmentLimit + "\n    abortLatch=" + this.abortLatch + "\n    threadFactory=" + this.threadFactory + "\n    idleStrategySupplier=" + this.idleStrategySupplier + "\n    epochClock=" + this.epochClock + "\n    errorLog=" + this.errorLog + "\n    errorHandler=" + this.errorHandler + "\n    delegatingErrorHandler=" + this.delegatingErrorHandler + "\n    errorCounter=" + this.errorCounter + "\n    countedErrorHandler=" + this.countedErrorHandler + "\n    clusteredService=" + this.clusteredService + "\n    shutdownSignalBarrier=" + this.shutdownSignalBarrier + "\n    terminationHook=" + this.terminationHook + "\n    cycleThresholdNs=" + this.cycleThresholdNs + "\n    dutyCyleTracker=" + this.dutyCycleTracker + "\n    markFile=" + this.markFile + "\n}";
        }
    }

    public static final class Configuration {
        public static final long SNAPSHOT_TYPE_ID = 2L;
        public static final long MARK_FILE_UPDATE_INTERVAL_NS = TimeUnit.SECONDS.toNanos(1L);
        public static final String CLUSTER_ID_PROP_NAME = "aeron.cluster.id";
        public static final int CLUSTER_ID_DEFAULT = 0;
        public static final String SERVICE_ID_PROP_NAME = "aeron.cluster.service.id";
        public static final int SERVICE_ID_DEFAULT = 0;
        public static final String SERVICE_NAME_PROP_NAME = "aeron.cluster.service.name";
        public static final String SERVICE_NAME_DEFAULT = "clustered-service";
        public static final String SERVICE_CLASS_NAME_PROP_NAME = "aeron.cluster.service.class.name";
        public static final String REPLAY_CHANNEL_PROP_NAME = "aeron.cluster.replay.channel";
        public static final String REPLAY_CHANNEL_DEFAULT = "aeron:ipc";
        public static final String REPLAY_STREAM_ID_PROP_NAME = "aeron.cluster.replay.stream.id";
        public static final int REPLAY_STREAM_ID_DEFAULT = 103;
        public static final String CONTROL_CHANNEL_PROP_NAME = "aeron.cluster.control.channel";
        public static final String CONTROL_CHANNEL_DEFAULT = "aeron:ipc?term-length=128k";
        public static final String SERVICE_STREAM_ID_PROP_NAME = "aeron.cluster.service.stream.id";
        public static final int SERVICE_STREAM_ID_DEFAULT = 104;
        public static final String CONSENSUS_MODULE_STREAM_ID_PROP_NAME = "aeron.cluster.consensus.module.stream.id";
        public static final int CONSENSUS_MODULE_STREAM_ID_DEFAULT = 105;
        public static final String SNAPSHOT_CHANNEL_PROP_NAME = "aeron.cluster.snapshot.channel";
        public static final String SNAPSHOT_CHANNEL_DEFAULT = "aeron:ipc?alias=snapshot";
        public static final String SNAPSHOT_STREAM_ID_PROP_NAME = "aeron.cluster.snapshot.stream.id";
        public static final int SNAPSHOT_STREAM_ID_DEFAULT = 106;
        public static final String CLUSTER_DIR_PROP_NAME = "aeron.cluster.dir";
        public static final String CLUSTER_DIR_DEFAULT = "aeron-cluster";
        public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.cluster.service.error.buffer.length";
        public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
        public static final String RESPONDER_SERVICE_PROP_NAME = "aeron.cluster.service.responder";
        public static final boolean RESPONDER_SERVICE_DEFAULT = true;
        public static final String LOG_FRAGMENT_LIMIT_PROP_NAME = "aeron.cluster.log.fragment.limit";
        public static final int LOG_FRAGMENT_LIMIT_DEFAULT = 50;
        public static final String DELEGATING_ERROR_HANDLER_PROP_NAME = "aeron.cluster.service.delegating.error.handler";
        public static final String CYCLE_THRESHOLD_PROP_NAME = "aeron.cluster.service.cycle.threshold";
        public static final long CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
        public static final int CLUSTER_NODE_ROLE_TYPE_ID = 201;
        public static final int COMMIT_POSITION_TYPE_ID = 203;
        public static final int CLUSTERED_SERVICE_ERROR_COUNT_TYPE_ID = 215;
        public static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
        public static final String CLUSTER_IDLE_STRATEGY_PROP_NAME = "aeron.cluster.idle.strategy";

        public static int clusterId() {
            return Integer.getInteger(CLUSTER_ID_PROP_NAME, 0);
        }

        public static int serviceId() {
            return Integer.getInteger(SERVICE_ID_PROP_NAME, 0);
        }

        public static String serviceName() {
            return System.getProperty(SERVICE_NAME_PROP_NAME, SERVICE_NAME_DEFAULT);
        }

        public static String replayChannel() {
            return System.getProperty(REPLAY_CHANNEL_PROP_NAME, REPLAY_CHANNEL_DEFAULT);
        }

        public static int replayStreamId() {
            return Integer.getInteger(REPLAY_STREAM_ID_PROP_NAME, 103);
        }

        public static String controlChannel() {
            return System.getProperty(CONTROL_CHANNEL_PROP_NAME, CONTROL_CHANNEL_DEFAULT);
        }

        public static int consensusModuleStreamId() {
            return Integer.getInteger(CONSENSUS_MODULE_STREAM_ID_PROP_NAME, 105);
        }

        public static int serviceStreamId() {
            return Integer.getInteger(SERVICE_STREAM_ID_PROP_NAME, 104);
        }

        public static String snapshotChannel() {
            return System.getProperty(SNAPSHOT_CHANNEL_PROP_NAME, SNAPSHOT_CHANNEL_DEFAULT);
        }

        public static int snapshotStreamId() {
            return Integer.getInteger(SNAPSHOT_STREAM_ID_PROP_NAME, 106);
        }

        public static Supplier<IdleStrategy> idleStrategySupplier(StatusIndicator controllableStatus) {
            return () -> {
                String name = System.getProperty(CLUSTER_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY);
                return io.aeron.driver.Configuration.agentIdleStrategy((String)name, (StatusIndicator)controllableStatus);
            };
        }

        public static String clusterDirName() {
            return System.getProperty(CLUSTER_DIR_PROP_NAME, CLUSTER_DIR_DEFAULT);
        }

        public static int errorBufferLength() {
            return SystemUtil.getSizeAsInt((String)ERROR_BUFFER_LENGTH_PROP_NAME, (int)0x100000);
        }

        public static boolean isRespondingService() {
            String property = System.getProperty(RESPONDER_SERVICE_PROP_NAME);
            if (null == property) {
                return true;
            }
            return "true".equals(property);
        }

        public static int logFragmentLimit() {
            return Integer.getInteger(LOG_FRAGMENT_LIMIT_PROP_NAME, 50);
        }

        public static long cycleThresholdNs() {
            return SystemUtil.getDurationInNanos((String)CYCLE_THRESHOLD_PROP_NAME, (long)CYCLE_THRESHOLD_DEFAULT_NS);
        }

        public static ClusteredService newClusteredService() {
            String className = System.getProperty(SERVICE_CLASS_NAME_PROP_NAME);
            if (null == className) {
                throw new ClusterException("either a instance or class name for the service must be provided");
            }
            try {
                return (ClusteredService)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
                return null;
            }
        }

        public static DelegatingErrorHandler newDelegatingErrorHandler() {
            String className = System.getProperty(DELEGATING_ERROR_HANDLER_PROP_NAME);
            if (null != className) {
                try {
                    return (DelegatingErrorHandler)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            }
            return null;
        }
    }
}

