/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.SnapshotReplication;
import java.util.ArrayList;
import java.util.List;

class MultiSnapshotReplication
implements AutoCloseable {
    private final AeronArchive archive;
    private final int srcControlStreamId;
    private final String srcControlChannel;
    private final String replicationChannel;
    private final ArrayList<RecordingLog.Snapshot> snapshotsPending = new ArrayList();
    private final ArrayList<RecordingLog.Snapshot> snapshotsRetrieved = new ArrayList();
    private int snapshotCursor = 0;
    private SnapshotReplication snapshotReplication = null;

    MultiSnapshotReplication(AeronArchive archive, int srcControlStreamId, String srcControlChannel, String replicationChannel) {
        this.archive = archive;
        this.srcControlStreamId = srcControlStreamId;
        this.srcControlChannel = srcControlChannel;
        this.replicationChannel = replicationChannel;
    }

    void addSnapshot(RecordingLog.Snapshot snapshot) {
        this.snapshotsPending.add(snapshot);
    }

    int poll() {
        if (this.isComplete()) {
            return 0;
        }
        int workDone = 0;
        if (null == this.snapshotReplication) {
            this.replicateCurrentSnapshot(true);
            ++workDone;
        } else if (this.snapshotReplication.isDone()) {
            if (this.snapshotReplication.isComplete()) {
                RecordingLog.Snapshot pending = this.snapshotsPending.get(this.snapshotCursor);
                this.snapshotsRetrieved.add(MultiSnapshotReplication.retrievedSnapshot(pending, this.snapshotReplication.recordingId()));
                ++this.snapshotCursor;
                this.snapshotReplication = null;
            } else {
                this.replicateCurrentSnapshot(false);
            }
            ++workDone;
        }
        return workDone;
    }

    void onSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (null != this.snapshotReplication) {
            this.snapshotReplication.onSignal(correlationId, recordingId, position, signal);
        }
    }

    boolean isComplete() {
        return this.snapshotCursor >= this.snapshotsPending.size();
    }

    List<RecordingLog.Snapshot> snapshotsRetrieved() {
        return this.snapshotsRetrieved;
    }

    static RecordingLog.Snapshot retrievedSnapshot(RecordingLog.Snapshot pending, long recordingId) {
        return new RecordingLog.Snapshot(recordingId, pending.leadershipTermId, pending.termBaseLogPosition, pending.logPosition, pending.timestamp, pending.serviceId);
    }

    @Override
    public void close() {
        if (null != this.snapshotReplication) {
            this.snapshotReplication.close(this.archive);
            this.snapshotReplication = null;
        }
    }

    private void replicateCurrentSnapshot(boolean isNew) {
        long replicationId = this.archive.replicate(this.snapshotsPending.get((int)this.snapshotCursor).recordingId, -1L, -1L, this.srcControlStreamId, this.srcControlChannel, null, this.replicationChannel);
        this.snapshotReplication = new SnapshotReplication(replicationId, isNew);
    }
}

