/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Publication;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.ClusterMembersExtendedResponseEncoder;
import io.aeron.cluster.codecs.ClusterMembersResponseEncoder;
import io.aeron.cluster.codecs.JoinLogEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.ServiceTerminationPositionEncoder;
import io.aeron.cluster.service.Cluster;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

final class ServiceProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 5;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final JoinLogEncoder joinLogEncoder = new JoinLogEncoder();
    private final ClusterMembersResponseEncoder clusterMembersResponseEncoder = new ClusterMembersResponseEncoder();
    private final ServiceTerminationPositionEncoder serviceTerminationPositionEncoder = new ServiceTerminationPositionEncoder();
    private final ClusterMembersExtendedResponseEncoder clusterMembersExtendedResponseEncoder = new ClusterMembersExtendedResponseEncoder();
    private final ExpandableArrayBuffer expandableArrayBuffer = new ExpandableArrayBuffer();
    private final Publication publication;

    ServiceProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.publication);
    }

    void joinLog(long logPosition, long maxLogPosition, int memberId, int logSessionId, int logStreamId, boolean isStartup, Cluster.Role role, String channel) {
        long result;
        int length = 44 + JoinLogEncoder.logChannelHeaderLength() + channel.length();
        int attempts = 5;
        do {
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.joinLogEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition).maxLogPosition(maxLogPosition).memberId(memberId).logSessionId(logSessionId).logStreamId(logStreamId).isStartup(isStartup ? BooleanType.TRUE : BooleanType.FALSE).role(role.code()).logChannel(channel);
                this.bufferClaim.commit();
                return;
            }
            ServiceProxy.checkResult(result);
            if (-2L != result) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send join log request: result=" + result);
    }

    void clusterMembersResponse(long correlationId, int leaderMemberId, String activeMembers, String passiveFollowers) {
        long result;
        int length = 20 + ClusterMembersResponseEncoder.activeMembersHeaderLength() + activeMembers.length() + ClusterMembersResponseEncoder.passiveFollowersHeaderLength() + passiveFollowers.length();
        int attempts = 5;
        do {
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.clusterMembersResponseEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).leaderMemberId(leaderMemberId).activeMembers(activeMembers).passiveFollowers(passiveFollowers);
                this.bufferClaim.commit();
                return;
            }
            if (-2L != result) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send cluster members response: result=" + result);
    }

    void clusterMembersExtendedResponse(long correlationId, long currentTimeNs, int leaderMemberId, int memberId, ClusterMember[] activeMembers, ClusterMember[] passiveMembers) {
        long result;
        this.clusterMembersExtendedResponseEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.expandableArrayBuffer, 0, this.messageHeaderEncoder).correlationId(correlationId).currentTimeNs(currentTimeNs).leaderMemberId(leaderMemberId).memberId(memberId);
        ClusterMembersExtendedResponseEncoder.ActiveMembersEncoder activeMembersEncoder = this.clusterMembersExtendedResponseEncoder.activeMembersCount(activeMembers.length);
        for (ClusterMember member : activeMembers) {
            activeMembersEncoder.next().leadershipTermId(member.leadershipTermId()).logPosition(member.logPosition()).timeOfLastAppendNs(member.timeOfLastAppendPositionNs()).memberId(member.id()).ingressEndpoint(member.ingressEndpoint()).consensusEndpoint(member.consensusEndpoint()).logEndpoint(member.logEndpoint()).catchupEndpoint(member.catchupEndpoint()).archiveEndpoint(member.archiveEndpoint());
        }
        ClusterMembersExtendedResponseEncoder.PassiveMembersEncoder passiveMembersEncoder = this.clusterMembersExtendedResponseEncoder.passiveMembersCount(passiveMembers.length);
        for (ClusterMember member : passiveMembers) {
            passiveMembersEncoder.next().leadershipTermId(member.leadershipTermId()).logPosition(member.logPosition()).timeOfLastAppendNs(member.timeOfLastAppendPositionNs()).memberId(member.id()).ingressEndpoint(member.ingressEndpoint()).consensusEndpoint(member.consensusEndpoint()).logEndpoint(member.logEndpoint()).catchupEndpoint(member.catchupEndpoint()).archiveEndpoint(member.archiveEndpoint());
        }
        int length = 8 + this.clusterMembersExtendedResponseEncoder.encodedLength();
        int attempts = 5;
        do {
            if ((result = this.publication.offer((DirectBuffer)this.expandableArrayBuffer, 0, length, null)) > 0L) {
                return;
            }
            if (-2L != result) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send cluster members extended response: result=" + result);
    }

    void terminationPosition(long logPosition, ErrorHandler errorHandler) {
        if (!this.publication.isClosed()) {
            long result;
            int length = 16;
            int attempts = 5;
            do {
                if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                    this.serviceTerminationPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition);
                    this.bufferClaim.commit();
                    return;
                }
                if (-2L != result) continue;
                Thread.yield();
            } while (--attempts > 0);
            errorHandler.onError((Throwable)((Object)new ClusterException("failed to send service termination position: result=" + result, AeronException.Category.WARN)));
        }
    }

    private static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new ClusterException("unexpected publication state: " + result);
        }
    }
}

