/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.SessionCloseEventDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class SessionCloseEventEncoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 22;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 9;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SessionCloseEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 22;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 9;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SessionCloseEventEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 28);
        return this;
    }

    public SessionCloseEventEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(22).schemaId(111).version(9);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionCloseEventEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int clusterSessionIdId() {
        return 2;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 8;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionCloseEventEncoder clusterSessionId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 3;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public SessionCloseEventEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int closeReasonId() {
        return 4;
    }

    public static int closeReasonSinceVersion() {
        return 0;
    }

    public static int closeReasonEncodingOffset() {
        return 24;
    }

    public static int closeReasonEncodingLength() {
        return 4;
    }

    public static String closeReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public SessionCloseEventEncoder closeReason(CloseReason value) {
        this.buffer.putInt(this.offset + 24, value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SessionCloseEventDecoder decoder = new SessionCloseEventDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 28, 9);
        return decoder.appendTo(builder);
    }
}

