/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.BufferBuilder;
import io.aeron.Image;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterActionRequestDecoder;
import io.aeron.cluster.codecs.MembershipChangeEventDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import io.aeron.cluster.codecs.SessionCloseEventDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionOpenEventDecoder;
import io.aeron.cluster.codecs.TimerEventDecoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

final class BoundedLogAdapter
implements ControlledFragmentHandler,
AutoCloseable {
    private final int fragmentLimit;
    private long maxLogPosition;
    private Image image;
    private final ClusteredServiceAgent agent;
    private final BufferBuilder builder = new BufferBuilder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionMessageHeaderDecoder sessionHeaderDecoder = new SessionMessageHeaderDecoder();
    private final TimerEventDecoder timerEventDecoder = new TimerEventDecoder();
    private final SessionOpenEventDecoder openEventDecoder = new SessionOpenEventDecoder();
    private final SessionCloseEventDecoder closeEventDecoder = new SessionCloseEventDecoder();
    private final ClusterActionRequestDecoder actionRequestDecoder = new ClusterActionRequestDecoder();
    private final NewLeadershipTermEventDecoder newLeadershipTermEventDecoder = new NewLeadershipTermEventDecoder();
    private final MembershipChangeEventDecoder membershipChangeEventDecoder = new MembershipChangeEventDecoder();

    BoundedLogAdapter(ClusteredServiceAgent agent, int fragmentLimit) {
        this.agent = agent;
        this.fragmentLimit = fragmentLimit;
    }

    @Override
    public void close() {
        if (null != this.image) {
            CloseHelper.close((AutoCloseable)this.image.subscription());
            this.image = null;
        }
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.onMessage(buffer, offset, length, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            this.builder.reset().append(buffer, offset, length).nextTermOffset(BitUtil.align((int)(offset + length + 32), (int)32));
        } else if (offset == this.builder.nextTermOffset()) {
            int limit = this.builder.limit();
            this.builder.append(buffer, offset, length);
            if ((flags & 0x40) == 64) {
                action = this.onMessage((DirectBuffer)this.builder.buffer(), 0, this.builder.limit(), header);
                if (ControlledFragmentHandler.Action.ABORT == action) {
                    this.builder.limit(limit);
                } else {
                    this.builder.reset();
                }
            } else {
                this.builder.nextTermOffset(BitUtil.align((int)(offset + length + 32), (int)32));
            }
        } else {
            this.builder.reset();
        }
        return action;
    }

    void maxLogPosition(long position) {
        this.maxLogPosition = position;
    }

    boolean isDone() {
        return this.image.position() >= this.maxLogPosition || this.image.isEndOfStream() || this.image.isClosed();
    }

    void image(Image image) {
        this.image = image;
    }

    Image image() {
        return this.image;
    }

    int poll(long limit) {
        return this.image.boundedControlledPoll((ControlledFragmentHandler)this, limit, this.fragmentLimit);
    }

    private ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 1) {
            this.sessionHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.agent.onSessionMessage(header.position(), this.sessionHeaderDecoder.clusterSessionId(), this.sessionHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        switch (templateId) {
            case 20: {
                this.timerEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onTimerEvent(header.position(), this.timerEventDecoder.correlationId(), this.timerEventDecoder.timestamp());
                break;
            }
            case 21: {
                this.openEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.openEventDecoder.responseChannel();
                byte[] encodedPrincipal = new byte[this.openEventDecoder.encodedPrincipalLength()];
                this.openEventDecoder.getEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
                this.agent.onSessionOpen(this.openEventDecoder.leadershipTermId(), header.position(), this.openEventDecoder.clusterSessionId(), this.openEventDecoder.timestamp(), this.openEventDecoder.responseStreamId(), responseChannel, encodedPrincipal);
                break;
            }
            case 22: {
                this.closeEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onSessionClose(this.closeEventDecoder.leadershipTermId(), header.position(), this.closeEventDecoder.clusterSessionId(), this.closeEventDecoder.timestamp(), this.closeEventDecoder.closeReason());
                break;
            }
            case 23: {
                this.actionRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onServiceAction(this.actionRequestDecoder.leadershipTermId(), this.actionRequestDecoder.logPosition(), this.actionRequestDecoder.timestamp(), this.actionRequestDecoder.action());
                break;
            }
            case 24: {
                this.newLeadershipTermEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onNewLeadershipTermEvent(this.newLeadershipTermEventDecoder.leadershipTermId(), this.newLeadershipTermEventDecoder.logPosition(), this.newLeadershipTermEventDecoder.timestamp(), this.newLeadershipTermEventDecoder.termBaseLogPosition(), this.newLeadershipTermEventDecoder.leaderMemberId(), this.newLeadershipTermEventDecoder.logSessionId(), ClusterClock.map(this.newLeadershipTermEventDecoder.timeUnit()), this.newLeadershipTermEventDecoder.appVersion());
                break;
            }
            case 25: {
                this.membershipChangeEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onMembershipChange(this.membershipChangeEventDecoder.logPosition(), this.membershipChangeEventDecoder.timestamp(), this.membershipChangeEventDecoder.changeType(), this.membershipChangeEventDecoder.memberId());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

