/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ClusterControl;
import io.aeron.cluster.ClusterControlAdapter;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ClusterMembership;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleSnapshotAdapter;
import io.aeron.cluster.ConsensusModuleSnapshotPrinter;
import io.aeron.cluster.ElectionState;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.ToggleApplication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.cluster.service.Cluster;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusterNodeControlProperties;
import io.aeron.cluster.service.ConsensusModuleProxy;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.collections.MutableBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class ClusterTool {
    public static final String AERON_CLUSTER_TOOL_TIMEOUT_PROP_NAME = "aeron.cluster.tool.timeout";
    public static final String AERON_CLUSTER_TOOL_DELAY_PROP_NAME = "aeron.cluster.tool.delay";
    public static final String AERON_CLUSTER_TOOL_REPLAY_CHANNEL_PROP_NAME = "aeron.cluster.tool.replay.channel";
    public static final String AERON_CLUSTER_TOOL_REPLAY_CHANNEL_DEFAULT = "aeron:ipc";
    public static final String AERON_CLUSTER_TOOL_REPLAY_CHANNEL = SystemUtil.getProperty((String)"aeron.cluster.tool.replay.channel", (String)"aeron:ipc");
    public static final String AERON_CLUSTER_TOOL_REPLAY_STREAM_ID_PROP_NAME = "aeron.cluster.tool.replay.stream.id";
    public static final int AERON_CLUSTER_TOOL_REPLAY_STREAM_ID_DEFAULT = 103;
    public static final int AERON_CLUSTER_TOOL_REPLAY_STREAM_ID = Integer.getInteger("aeron.cluster.tool.replay.stream.id", 103);
    static final long TIMEOUT_MS = TimeUnit.NANOSECONDS.toMillis(SystemUtil.getDurationInNanos((String)"aeron.cluster.tool.timeout", (long)0L));
    private static final int MARK_FILE_VERSION_WITH_CLUSTER_SERVICES_DIR = 1;

    public static void main(String[] args) {
        File clusterDir;
        if (args.length < 2) {
            ClusterTool.printHelp();
            System.exit(-1);
        }
        if (!(clusterDir = new File(args[0])).exists()) {
            System.err.println("ERR: cluster directory not found: " + clusterDir.getAbsolutePath());
            ClusterTool.printHelp();
            System.exit(-1);
        }
        switch (args[1]) {
            case "describe": {
                ClusterTool.describe(System.out, clusterDir);
                break;
            }
            case "pid": {
                ClusterTool.pid(System.out, clusterDir);
                break;
            }
            case "recovery-plan": {
                if (args.length < 3) {
                    ClusterTool.printHelp();
                    System.exit(-1);
                }
                ClusterTool.recoveryPlan(System.out, clusterDir, Integer.parseInt(args[2]));
                break;
            }
            case "recording-log": {
                ClusterTool.recordingLog(System.out, clusterDir);
                break;
            }
            case "sort-recording-log": {
                ClusterTool.sortRecordingLog(clusterDir);
                break;
            }
            case "seed-recording-log-from-snapshot": {
                ClusterTool.seedRecordingLogFromSnapshot(clusterDir);
                break;
            }
            case "errors": {
                ClusterTool.errors(System.out, clusterDir);
                break;
            }
            case "list-members": {
                ClusterTool.listMembers(System.out, clusterDir);
                break;
            }
            case "backup-query": {
                if (args.length < 3) {
                    ClusterTool.printNextBackupQuery(System.out, clusterDir);
                    break;
                }
                ClusterTool.nextBackupQuery(System.out, clusterDir, TimeUnit.NANOSECONDS.toMillis(SystemUtil.parseDuration((String)AERON_CLUSTER_TOOL_DELAY_PROP_NAME, (String)args[2])));
                break;
            }
            case "invalidate-latest-snapshot": {
                ClusterTool.invalidateLatestSnapshot(System.out, clusterDir);
                break;
            }
            case "is-leader": {
                System.exit(ClusterTool.isLeader(System.out, clusterDir));
                break;
            }
            case "snapshot": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.snapshot(clusterDir, System.out));
                break;
            }
            case "suspend": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.suspend(clusterDir, System.out));
                break;
            }
            case "resume": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.resume(clusterDir, System.out));
                break;
            }
            case "shutdown": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.shutdown(clusterDir, System.out));
                break;
            }
            case "abort": {
                ClusterTool.exitWithErrorOnFailure(ClusterTool.abort(clusterDir, System.out));
                break;
            }
            case "describe-latest-cm-snapshot": {
                ClusterTool.describeLatestConsensusModuleSnapshot(System.out, clusterDir);
                break;
            }
            default: {
                System.out.println("Unknown command: " + args[1]);
                ClusterTool.printHelp();
                System.exit(-1);
            }
        }
    }

    public static void describe(PrintStream out, File clusterDir) {
        ClusterTool.describeClusterMarkFile(clusterDir, out);
    }

    static boolean describeClusterMarkFile(File clusterDir, PrintStream out) {
        File clusterServicesDir;
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                MarkFileHeaderDecoder decoder = markFile.decoder();
                ClusterTool.printTypeAndActivityTimestamp(out, markFile);
                out.println(decoder);
                clusterServicesDir = ClusterTool.resolveClusterServicesDir(clusterDir, decoder);
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
            return false;
        }
        ClusterMarkFile[] serviceMarkFiles = ClusterTool.openServiceMarkFiles(clusterServicesDir, out::println);
        ClusterTool.describe(out, serviceMarkFiles);
        return true;
    }

    static File resolveClusterServicesDir(File clusterDir, MarkFileHeaderDecoder decoder) {
        File clusterServicesDir;
        if (1 <= decoder.sbeSchemaVersion()) {
            decoder.sbeRewind();
            decoder.skipAeronDirectory();
            decoder.skipControlChannel();
            decoder.skipIngressChannel();
            decoder.skipServiceName();
            decoder.skipAuthenticator();
            String servicesClusterDir = decoder.servicesClusterDir();
            clusterServicesDir = Strings.isEmpty((String)servicesClusterDir) ? clusterDir : new File(servicesClusterDir);
        } else {
            clusterServicesDir = clusterDir;
        }
        return clusterServicesDir;
    }

    public static void pid(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                out.println(markFile.decoder().pid());
            }
        } else {
            System.exit(-1);
        }
    }

    public static void recoveryPlan(PrintStream out, File clusterDir, int serviceCount) {
        try (AeronArchive archive = AeronArchive.connect();
             RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            out.println(recordingLog.createRecoveryPlan(archive, serviceCount, -1L));
        }
    }

    public static void recordingLog(PrintStream out, File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            out.println(recordingLog);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sortRecordingLog(File clusterDir) {
        List<RecordingLog.Entry> entries;
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            entries = recordingLog.entries();
            if (ClusterTool.isRecordingLogSorted(entries)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (RuntimeException ex) {
            return false;
        }
        ClusterTool.updateRecordingLog(clusterDir, entries);
        return true;
    }

    public static void seedRecordingLogFromSnapshot(File clusterDir) {
        List<RecordingLog.Entry> entries;
        int snapshotIndex = -1;
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            entries = recordingLog.entries();
            for (int i = entries.size() - 1; i >= 0; --i) {
                RecordingLog.Entry entry = entries.get(i);
                if (!RecordingLog.isValidSnapshot(entry) || -1 != entry.serviceId) continue;
                snapshotIndex = i;
                break;
            }
        }
        Path recordingLogBackup = clusterDir.toPath().resolve("recording.log.bak");
        try {
            Files.copy(clusterDir.toPath().resolve("recording.log"), recordingLogBackup, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (-1 == snapshotIndex) {
            ClusterTool.updateRecordingLog(clusterDir, Collections.emptyList());
        } else {
            RecordingLog.Entry entry;
            ArrayList<RecordingLog.Entry> truncatedEntries = new ArrayList<RecordingLog.Entry>();
            int serviceId = -1;
            for (int i = snapshotIndex; i >= 0 && RecordingLog.isValidSnapshot(entry = entries.get(i)) && entry.serviceId == serviceId; ++serviceId, --i) {
                truncatedEntries.add(new RecordingLog.Entry(entry.recordingId, entry.leadershipTermId, 0L, 0L, entry.timestamp, entry.serviceId, entry.type, null, entry.isValid, -1));
            }
            Collections.reverse(truncatedEntries);
            ClusterTool.updateRecordingLog(clusterDir, truncatedEntries);
        }
    }

    public static void errors(PrintStream out, File clusterDir) {
        ClusterMarkFile[] serviceMarkFiles;
        File clusterServicesDir = clusterDir;
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            ClusterMarkFile[] clusterMarkFileArray = null;
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                ClusterTool.printTypeAndActivityTimestamp(out, markFile);
                ClusterTool.printErrors(out, markFile);
                String aeronDirectory = markFile.decoder().aeronDirectory();
                out.println();
                ClusterTool.printDriverErrors(out, aeronDirectory);
                clusterServicesDir = ClusterTool.resolveClusterServicesDir(clusterDir, markFile.decoder());
            }
            catch (Throwable object) {
                clusterMarkFileArray = object;
                throw object;
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles = ClusterTool.openServiceMarkFiles(clusterServicesDir, out::println)) {
            ClusterTool.printTypeAndActivityTimestamp(out, serviceMarkFile);
            ClusterTool.printErrors(out, serviceMarkFile);
            serviceMarkFile.close();
        }
    }

    public static void listMembers(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                ClusterMembership clusterMembership = new ClusterMembership();
                long timeoutMs = Math.max(TimeUnit.SECONDS.toMillis(1L), TIMEOUT_MS);
                if (ClusterTool.queryClusterMembers(markFile, timeoutMs, clusterMembership)) {
                    out.println("currentTimeNs=" + clusterMembership.currentTimeNs + ", leaderMemberId=" + clusterMembership.leaderMemberId + ", memberId=" + clusterMembership.memberId + ", activeMembers=" + clusterMembership.activeMembers + ", passiveMembers=" + clusterMembership.passiveMembers);
                }
                out.println("timeout waiting for response from node");
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
    }

    public static void printNextBackupQuery(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                if (markFile.decoder().componentType() != ClusterComponentType.BACKUP) {
                    out.println("not a cluster backup node");
                }
                out.format("%2$tF %1$tH:%1$tM:%1$tS next: %2$tF %2$tH:%2$tM:%2$tS%n", new Date(), new Date(ClusterTool.nextBackupQueryDeadlineMs(markFile)));
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
    }

    public static void nextBackupQuery(PrintStream out, File clusterDir, long delayMs) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                if (markFile.decoder().componentType() != ClusterComponentType.BACKUP) {
                    out.println("not a cluster backup node");
                }
                SystemEpochClock epochClock = SystemEpochClock.INSTANCE;
                ClusterTool.nextBackupQueryDeadlineMs(markFile, epochClock.time() + delayMs);
                out.format("%2$tF %1$tH:%1$tM:%1$tS setting next: %2$tF %2$tH:%2$tM:%2$tS%n", new Date(), new Date(ClusterTool.nextBackupQueryDeadlineMs(markFile)));
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
    }

    public static void describe(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles) {
            ClusterTool.printTypeAndActivityTimestamp(out, serviceMarkFile);
            out.println(serviceMarkFile.decoder());
            serviceMarkFile.close();
        }
    }

    public static int isLeader(PrintStream out, File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir)) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                String aeronDirectoryName = markFile.decoder().aeronDirectory();
                MutableLong nodeRoleCounter = new MutableLong(-1L);
                MutableLong electionStateCounter = new MutableLong(-1L);
                MutableLong moduleStateCounter = new MutableLong(-1L);
                try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
                    CountersReader countersReader = aeron.countersReader();
                    countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
                        if (201 == typeId) {
                            nodeRoleCounter.set(countersReader.getCounterValue(counterId));
                        } else if (207 == typeId) {
                            electionStateCounter.set(countersReader.getCounterValue(counterId));
                        } else if (200 == typeId) {
                            moduleStateCounter.set(countersReader.getCounterValue(counterId));
                        }
                    });
                }
                if (nodeRoleCounter.get() == (long)Cluster.Role.LEADER.code() && electionStateCounter.get() == (long)ElectionState.CLOSED.code() && moduleStateCounter.get() == (long)ConsensusModule.State.ACTIVE.code()) {
                    int n = 0;
                    return n;
                }
                int n = 1;
                return n;
            }
        }
        out.println("cluster-mark.dat does not exist.");
        return -1;
    }

    public static boolean markFileExists(File clusterDir) {
        File markFileDir = ClusterTool.resolveClusterMarkFileDir(clusterDir);
        File markFile = new File(markFileDir, "cluster-mark.dat");
        return markFile.exists();
    }

    public static boolean listMembers(ClusterMembership clusterMembership, File clusterDir, long timeoutMs) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                boolean bl = ClusterTool.queryClusterMembers(markFile, timeoutMs, clusterMembership);
                return bl;
            }
        }
        return false;
    }

    public static boolean queryClusterMembers(ClusterMarkFile markFile, long timeoutMs, ClusterMembership clusterMembership) {
        return ClusterTool.queryClusterMembers(markFile.loadControlProperties(), timeoutMs, clusterMembership);
    }

    public static boolean queryClusterMembers(ClusterNodeControlProperties controlProperties, long timeoutMs, final ClusterMembership clusterMembership) {
        final MutableLong id = new MutableLong(-1L);
        ClusterControlAdapter.Listener listener = new ClusterControlAdapter.Listener(){

            @Override
            public void onClusterMembersResponse(long correlationId, int leaderMemberId, String activeMembers, String passiveMembers) {
                if (correlationId == id.get()) {
                    clusterMembership.leaderMemberId = leaderMemberId;
                    clusterMembership.activeMembersStr = activeMembers;
                    clusterMembership.passiveMembersStr = passiveMembers;
                    id.set(-1L);
                }
            }

            @Override
            public void onClusterMembersExtendedResponse(long correlationId, long currentTimeNs, int leaderMemberId, int memberId, List<ClusterMember> activeMembers, List<ClusterMember> passiveMembers) {
                if (correlationId == id.get()) {
                    clusterMembership.currentTimeNs = currentTimeNs;
                    clusterMembership.leaderMemberId = leaderMemberId;
                    clusterMembership.memberId = memberId;
                    clusterMembership.activeMembers = activeMembers;
                    clusterMembership.passiveMembers = passiveMembers;
                    clusterMembership.activeMembersStr = ClusterMember.encodeAsString(activeMembers);
                    clusterMembership.passiveMembersStr = ClusterMember.encodeAsString(passiveMembers);
                    id.set(-1L);
                }
            }
        };
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(controlProperties.aeronDirectoryName));
             ConcurrentPublication publication = aeron.addPublication(controlProperties.controlChannel, controlProperties.consensusModuleStreamId);
             ConsensusModuleProxy consensusModuleProxy = new ConsensusModuleProxy((Publication)publication);
             ClusterControlAdapter clusterControlAdapter = new ClusterControlAdapter(aeron.addSubscription(controlProperties.controlChannel, controlProperties.serviceStreamId), listener);){
            long deadlineMs = System.currentTimeMillis() + timeoutMs;
            long correlationId = aeron.nextCorrelationId();
            id.set(correlationId);
            while (!publication.isConnected() && System.currentTimeMillis() <= deadlineMs) {
                Thread.yield();
            }
            while (!consensusModuleProxy.clusterMembersQuery(correlationId) && System.currentTimeMillis() <= deadlineMs) {
                Thread.yield();
            }
            while (-1L != id.get()) {
                if (0 != clusterControlAdapter.poll()) continue;
                if (System.currentTimeMillis() > deadlineMs) {
                    break;
                }
                Thread.yield();
            }
        }
        return true;
    }

    public static long nextBackupQueryDeadlineMs(File clusterDir) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                long l = ClusterTool.nextBackupQueryDeadlineMs(markFile);
                return l;
            }
        }
        return -1L;
    }

    public static long nextBackupQueryDeadlineMs(ClusterMarkFile markFile) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        MutableLong nextQueryMs = new MutableLong(-1L);
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
            aeron.countersReader().forEach((counterId, typeId, keyBuffer, label) -> {
                if (210 == typeId) {
                    nextQueryMs.set(aeron.countersReader().getCounterValue(counterId));
                }
            });
        }
        return nextQueryMs.get();
    }

    public static boolean nextBackupQueryDeadlineMs(File clusterDir, long timeMs) {
        if (ClusterTool.markFileExists(clusterDir) || TIMEOUT_MS > 0L) {
            try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
                boolean bl = ClusterTool.nextBackupQueryDeadlineMs(markFile, timeMs);
                return bl;
            }
        }
        return false;
    }

    public static boolean nextBackupQueryDeadlineMs(ClusterMarkFile markFile, long timeMs) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        MutableBoolean result = new MutableBoolean(false);
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
            CountersReader countersReader = aeron.countersReader();
            countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
                if (210 == typeId) {
                    AtomicCounter atomicCounter = new AtomicCounter(countersReader.valuesBuffer(), counterId, null);
                    atomicCounter.setOrdered(timeMs);
                    result.value = true;
                }
            });
        }
        return result.value;
    }

    public static boolean invalidateLatestSnapshot(PrintStream out, File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            boolean result = recordingLog.invalidateLatestSnapshot();
            out.println(" invalidate latest snapshot: " + result);
            boolean bl = result;
            return bl;
        }
    }

    public static void describeLatestConsensusModuleSnapshot(PrintStream out, File clusterDir) {
        RecordingLog.Entry entry = ClusterTool.findLatestValidSnapshot(clusterDir);
        if (null == entry) {
            out.println("Snapshot not found");
            return;
        }
        ClusterNodeControlProperties properties = ClusterTool.loadControlProperties(clusterDir);
        AeronArchive.Context archiveCtx = new AeronArchive.Context().controlRequestChannel(AERON_CLUSTER_TOOL_REPLAY_CHANNEL_DEFAULT).controlResponseChannel(AERON_CLUSTER_TOOL_REPLAY_CHANNEL_DEFAULT);
        try (Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(properties.aeronDirectoryName));
             AeronArchive archive = AeronArchive.connect((AeronArchive.Context)archiveCtx.aeron(aeron));){
            String channel = AERON_CLUSTER_TOOL_REPLAY_CHANNEL;
            int streamId = AERON_CLUSTER_TOOL_REPLAY_STREAM_ID;
            int sessionId = (int)archive.startReplay(entry.recordingId, 0L, -1L, channel, streamId);
            String replayChannel = ChannelUri.addSessionId((String)channel, (int)sessionId);
            try (Subscription subscription = aeron.addSubscription(replayChannel, streamId);){
                Image image;
                while ((image = subscription.imageBySessionId(sessionId)) == null) {
                    archive.checkForErrorResponse();
                    Thread.yield();
                }
                ConsensusModuleSnapshotAdapter adapter = new ConsensusModuleSnapshotAdapter(image, new ConsensusModuleSnapshotPrinter(out));
                while (true) {
                    int fragments;
                    if (0 != (fragments = adapter.poll())) {
                        continue;
                    }
                    if (adapter.isDone()) break;
                    if (image.isClosed()) {
                        throw new ClusterException("snapshot ended unexpectedly: " + image);
                    }
                    archive.checkForErrorResponse();
                    Thread.yield();
                }
                out.println("Consensus Module Snapshot End: memberId=" + properties.memberId + " recordingId=" + entry.recordingId + " length=" + image.position());
            }
        }
    }

    public static boolean snapshot(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SNAPSHOT, true, TimeUnit.SECONDS.toMillis(30L));
    }

    public static boolean suspend(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SUSPEND, false, TimeUnit.SECONDS.toMillis(1L));
    }

    public static boolean resume(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.SUSPENDED, ClusterControl.ToggleState.RESUME, true, TimeUnit.SECONDS.toMillis(1L));
    }

    public static boolean shutdown(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SHUTDOWN, false, TimeUnit.SECONDS.toMillis(1L));
    }

    public static boolean abort(File clusterDir, PrintStream out) {
        return ClusterTool.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.ABORT, false, TimeUnit.SECONDS.toMillis(1L));
    }

    static RecordingLog.Entry findLatestValidSnapshot(File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            RecordingLog.Entry entry = recordingLog.getLatestSnapshot(-1);
            return entry;
        }
    }

    static ClusterNodeControlProperties loadControlProperties(File clusterDir) {
        ClusterNodeControlProperties properties;
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
            properties = markFile.loadControlProperties();
        }
        return properties;
    }

    static boolean toggleClusterState(PrintStream out, File clusterDir, ConsensusModule.State expectedState, ClusterControl.ToggleState toggleState, boolean waitForToggleToComplete, long defaultTimeoutMs) {
        return ClusterTool.toggleState(out, clusterDir, true, expectedState, toggleState, ToggleApplication.CLUSTER_CONTROL, waitForToggleToComplete, defaultTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends Enum<T>> boolean toggleState(PrintStream out, File clusterDir, boolean isLeaderRequired, ConsensusModule.State expectedState, T targetState, ToggleApplication<T> toggleApplication, boolean waitForToggleToComplete, long defaultTimeoutMs) {
        ClusterNodeControlProperties clusterNodeControlProperties;
        int clusterId;
        if (!ClusterTool.markFileExists(clusterDir) && TIMEOUT_MS <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return false;
        }
        try (ClusterMarkFile markFile = ClusterTool.openMarkFile(clusterDir);){
            clusterId = markFile.clusterId();
            clusterNodeControlProperties = markFile.loadControlProperties();
        }
        ClusterMembership clusterMembership = new ClusterMembership();
        long queryTimeoutMs = Math.max(TimeUnit.SECONDS.toMillis(1L), TIMEOUT_MS);
        if (!ClusterTool.queryClusterMembers(clusterNodeControlProperties, queryTimeoutMs, clusterMembership)) {
            out.println("Timed out querying cluster.");
            return false;
        }
        String prefix = "Member [" + clusterMembership.memberId + "]: ";
        if (isLeaderRequired && clusterMembership.leaderMemberId != clusterMembership.memberId) {
            out.println(prefix + "Current node is not the leader (leaderMemberId = " + clusterMembership.leaderMemberId + "), unable to " + targetState);
            return false;
        }
        File cncFile = new File(clusterNodeControlProperties.aeronDirectoryName, "cnc.dat");
        if (!cncFile.exists()) {
            out.println(prefix + "Unable to locate media driver. C`n`C file [" + cncFile.getAbsolutePath() + "] does not exist.");
            return false;
        }
        CountersReader countersReader = ClusterControl.mapCounters(cncFile);
        try {
            ConsensusModule.State moduleState = ConsensusModule.State.find(countersReader, clusterId);
            if (null == moduleState) {
                out.println(prefix + "Unable to resolve state of consensus module.");
                boolean bl = false;
                return bl;
            }
            if (expectedState != moduleState) {
                out.println(prefix + "Unable to " + targetState + " as the state of the consensus module is " + (Object)((Object)moduleState) + ", but needs to be " + (Object)((Object)expectedState));
                boolean bl = false;
                return bl;
            }
            AtomicCounter controlToggle = toggleApplication.find(countersReader, clusterId);
            if (null == controlToggle) {
                out.println(prefix + "Failed to find control toggle");
                boolean bl = false;
                return bl;
            }
            if (!toggleApplication.apply(controlToggle, targetState)) {
                out.println(prefix + "Failed to apply " + targetState + ", current toggle value = " + (Object)((Object)ClusterControl.ToggleState.get(controlToggle)));
                boolean bl = false;
                return bl;
            }
            if (waitForToggleToComplete) {
                long toggleTimeoutMs = Math.max(defaultTimeoutMs, TIMEOUT_MS);
                long deadlineMs = System.currentTimeMillis() + toggleTimeoutMs;
                Object currentState = null;
                do {
                    Thread.yield();
                } while (System.currentTimeMillis() <= deadlineMs && !toggleApplication.isNeutral(currentState = (Object)toggleApplication.get(controlToggle)));
                if (!toggleApplication.isNeutral(currentState)) {
                    out.println(prefix + "Timed out after " + toggleTimeoutMs + "ms waiting for " + targetState + " to complete.");
                }
            }
            out.println(prefix + targetState + " applied successfully");
            boolean bl = true;
            return bl;
        }
        finally {
            IoUtil.unmap((ByteBuffer)countersReader.valuesBuffer().byteBuffer());
        }
    }

    static ClusterMarkFile openMarkFile(File clusterDir) {
        File markFileDir = ClusterTool.resolveClusterMarkFileDir(clusterDir);
        return new ClusterMarkFile(markFileDir, "cluster-mark.dat", System::currentTimeMillis, TIMEOUT_MS, null);
    }

    private static ClusterMarkFile[] openServiceMarkFiles(File clusterDir, Consumer<String> logger) {
        File[] clusterMarkFileNames = clusterDir.listFiles((dir, name) -> name.startsWith("cluster-mark-service-") && (name.endsWith(".dat") || name.endsWith(".lnk")));
        if (null == clusterMarkFileNames) {
            clusterMarkFileNames = new File[]{};
        }
        ArrayList<File> resolvedMarkFileNames = new ArrayList<File>();
        ClusterTool.resolveServiceMarkFileNames(clusterMarkFileNames, resolvedMarkFileNames);
        ClusterMarkFile[] clusterMarkFiles = new ClusterMarkFile[clusterMarkFileNames.length];
        int n = resolvedMarkFileNames.size();
        for (int i = 0; i < n; ++i) {
            File resolvedMarkFile = resolvedMarkFileNames.get(i);
            clusterMarkFiles[i] = new ClusterMarkFile(resolvedMarkFile.getParentFile(), resolvedMarkFile.getName(), System::currentTimeMillis, TIMEOUT_MS, logger);
        }
        return clusterMarkFiles;
    }

    private static void resolveServiceMarkFileNames(File[] clusterMarkFiles, ArrayList<File> resolvedFiles) {
        String name;
        String filename;
        HashSet<String> resolvedServices = new HashSet<String>();
        for (File clusterMarkFile : clusterMarkFiles) {
            filename = clusterMarkFile.getName();
            if (!filename.endsWith(".lnk")) continue;
            name = filename.substring(0, filename.length() - ".lnk".length());
            File markFileDir = ClusterTool.resolveDirectoryFromLinkFile(clusterMarkFile);
            resolvedFiles.add(new File(markFileDir, name + ".dat"));
            resolvedServices.add(name);
        }
        for (File clusterMarkFile : clusterMarkFiles) {
            filename = clusterMarkFile.getName();
            if (!filename.endsWith(".dat") || resolvedServices.contains(name = filename.substring(0, filename.length() - ".dat".length()))) continue;
            resolvedFiles.add(clusterMarkFile);
            resolvedServices.add(name);
        }
    }

    static void printTypeAndActivityTimestamp(PrintStream out, ClusterMarkFile markFile) {
        ClusterTool.printTypeAndActivityTimestamp(out, markFile.decoder().componentType().toString(), markFile.decoder().startTimestamp(), markFile.activityTimestampVolatile());
    }

    static void printTypeAndActivityTimestamp(PrintStream out, String clusterComponentType, long startTimestampMs, long activityTimestampMs) {
        out.print("Type: " + clusterComponentType + " ");
        out.format("%1$tH:%1$tM:%1$tS (start: %2$tF %2$tH:%2$tM:%2$tS, activity: %3$tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(startTimestampMs), new Date(activityTimestampMs));
    }

    private static void printErrors(PrintStream out, ClusterMarkFile markFile) {
        ClusterTool.printErrors(out, markFile::errorBuffer, "Cluster");
    }

    static void printErrors(PrintStream out, Supplier<AtomicBuffer> errorBuffer, String name) {
        out.println(name + " component error log:");
        CommonContext.printErrorLog((AtomicBuffer)errorBuffer.get(), (PrintStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printDriverErrors(PrintStream out, String aeronDirectory) {
        out.println("Aeron driver error log (directory: " + aeronDirectory + "):");
        File cncFile = new File(aeronDirectory, "cnc.dat");
        MappedByteBuffer cncByteBuffer = null;
        try {
            cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY, (String)"cnc");
            UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
            int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset((int)0));
            CncFileDescriptor.checkVersion((int)cncVersion);
            CommonContext.printErrorLog((AtomicBuffer)CncFileDescriptor.createErrorLogBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaDataBuffer), (PrintStream)out);
        }
        finally {
            if (null != cncByteBuffer) {
                IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
            }
        }
    }

    private static boolean isRecordingLogSorted(List<RecordingLog.Entry> entries) {
        for (int i = entries.size() - 1; i >= 0; --i) {
            if (entries.get((int)i).entryIndex == i) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRecordingLog(File clusterDir, List<RecordingLog.Entry> entries) {
        block20: {
            Path recordingLog = clusterDir.toPath().resolve("recording.log");
            try {
                if (entries.isEmpty()) {
                    Files.delete(recordingLog);
                    break block20;
                }
                Path newRecordingLog = clusterDir.toPath().resolve("recording.log.tmp");
                Files.deleteIfExists(newRecordingLog);
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096).order(ByteOrder.LITTLE_ENDIAN);
                UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
                try (FileChannel fileChannel = FileChannel.open(newRecordingLog, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    long position = 0L;
                    for (RecordingLog.Entry e : entries) {
                        RecordingLog.writeEntryToBuffer(e, buffer);
                        byteBuffer.limit(e.length()).position(0);
                        if (e.length() != fileChannel.write(byteBuffer, position)) {
                            throw new ClusterException("failed to write recording");
                        }
                        position += (long)e.length();
                    }
                }
                finally {
                    BufferUtil.free((ByteBuffer)byteBuffer);
                }
                Files.delete(recordingLog);
                Files.move(newRecordingLog, recordingLog, new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    static File resolveClusterMarkFileDir(File dir) {
        File linkFile = new File(dir, "cluster-mark.lnk");
        return linkFile.exists() ? ClusterTool.resolveDirectoryFromLinkFile(linkFile) : dir;
    }

    static File resolveDirectoryFromLinkFile(File linkFile) {
        File markFileDir;
        try {
            byte[] bytes = Files.readAllBytes(linkFile.toPath());
            String markFileDirPath = new String(bytes, StandardCharsets.US_ASCII).trim();
            markFileDir = new File(markFileDirPath);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read link file=" + linkFile, ex);
        }
        return markFileDir;
    }

    static void exitWithErrorOnFailure(boolean success) {
        if (!success) {
            System.exit(-1);
        }
    }

    static void printHelp() {
        System.out.format("Usage: <cluster-dir> <command> [options]%n                         describe: prints out all descriptors in the mark file.%n                              pid: prints PID of cluster component.%n                    recovery-plan: [service count] prints recovery plan of cluster component.%n                    recording-log: prints recording log of cluster component.%n               sort-recording-log: reorders entries in the recording log to match the order in memory.%n seed-recording-log-from-snapshot: creates a new recording log based on the latest valid snapshot.%n                           errors: prints Aeron and cluster component error logs.%n                     list-members: prints leader memberId, active members and passive members lists.%n                     backup-query: [delay] get, or set, time of next backup query.%n       invalidate-latest-snapshot: marks the latest snapshot as a invalid so the previous is loaded.%n                         snapshot: triggers a snapshot on the leader.%n                          suspend: suspends appending to the log.%n                           resume: resumes appending to the log.%n                         shutdown: initiates an orderly stop of the cluster with a snapshot.%n                            abort: stops the cluster without a snapshot.%n      describe-latest-cm-snapshot: prints the contents of the latest valid consensus module snapshot.%n                        is-leader: returns zero if the cluster node is leader, non-zero if not.%n", new Object[0]);
        System.out.flush();
    }
}

