/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import org.agrona.concurrent.status.AtomicCounter;

public class SnapshotDurationTracker {
    private final AtomicCounter maxSnapshotDuration;
    private final AtomicCounter snapshotDurationThresholdExceededCount;
    private final long durationThresholdNs;
    private long snapshotStartTimeNs = Long.MIN_VALUE;

    public SnapshotDurationTracker(AtomicCounter maxSnapshotDuration, AtomicCounter snapshotDurationThresholdExceededCount, long durationThresholdNs) {
        this.maxSnapshotDuration = maxSnapshotDuration;
        this.snapshotDurationThresholdExceededCount = snapshotDurationThresholdExceededCount;
        this.durationThresholdNs = durationThresholdNs;
    }

    public AtomicCounter maxSnapshotDuration() {
        return this.maxSnapshotDuration;
    }

    public AtomicCounter snapshotDurationThresholdExceededCount() {
        return this.snapshotDurationThresholdExceededCount;
    }

    public void onSnapshotBegin(long timeNanos) {
        this.snapshotStartTimeNs = timeNanos;
    }

    public void onSnapshotEnd(long timeNanos) {
        if (this.snapshotStartTimeNs != Long.MIN_VALUE) {
            long snapshotDurationNs = timeNanos - this.snapshotStartTimeNs;
            if (snapshotDurationNs > this.durationThresholdNs) {
                this.snapshotDurationThresholdExceededCount.increment();
            }
            this.maxSnapshotDuration.proposeMax(snapshotDurationNs);
        }
    }

    public String toString() {
        return "SnapshotDurationTracker{maxSnapshotDuration=" + this.maxSnapshotDuration + ", snapshotDurationThresholdExceededCount=" + this.snapshotDurationThresholdExceededCount + ", durationThresholdNs=" + this.durationThresholdNs + '}';
    }
}

