/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ExclusivePublication;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.PendingServiceMessageTracker;
import io.aeron.cluster.TimerService;
import io.aeron.cluster.codecs.ClusterSessionEncoder;
import io.aeron.cluster.codecs.ConsensusModuleEncoder;
import io.aeron.cluster.codecs.PendingMessageTrackerEncoder;
import io.aeron.cluster.codecs.TimerEncoder;
import io.aeron.cluster.service.SnapshotTaker;
import io.aeron.exceptions.AeronEvent;
import io.aeron.exceptions.AeronException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.ExpandableRingBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;

class ConsensusModuleSnapshotTaker
extends SnapshotTaker
implements ExpandableRingBuffer.MessageConsumer,
TimerService.TimerSnapshotTaker {
    private static final int ENCODED_TIMER_LENGTH = 24;
    private final ExpandableArrayBuffer offerBuffer = new ExpandableArrayBuffer(1024);
    private final ClusterSessionEncoder clusterSessionEncoder = new ClusterSessionEncoder();
    private final TimerEncoder timerEncoder = new TimerEncoder();
    private final ConsensusModuleEncoder consensusModuleEncoder = new ConsensusModuleEncoder();
    private final PendingMessageTrackerEncoder pendingMessageTrackerEncoder = new PendingMessageTrackerEncoder();

    ConsensusModuleSnapshotTaker(ExclusivePublication publication, IdleStrategy idleStrategy, AgentInvoker aeronClientInvoker) {
        super(publication, idleStrategy, aeronClientInvoker);
    }

    public boolean onMessage(MutableDirectBuffer buffer, int offset, int length, int headOffset) {
        this.offer((DirectBuffer)buffer, offset, length);
        return true;
    }

    void snapshotConsensusModuleState(long nextSessionId, long nextServiceSessionId, long logServiceSessionId, int pendingMessageCapacity) {
        int length = 36;
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(36, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.consensusModuleEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).nextSessionId(nextSessionId).nextServiceSessionId(nextServiceSessionId).logServiceSessionId(logServiceSessionId).pendingMessageCapacity(pendingMessageCapacity);
        this.bufferClaim.commit();
    }

    void snapshotSession(ClusterSession session) {
        block3: {
            String responseChannel = session.responseChannel();
            int length = 48 + ClusterSessionEncoder.responseChannelHeaderLength() + responseChannel.length();
            if (length <= this.publication.maxPayloadLength()) {
                this.idleStrategy.reset();
                while (true) {
                    long result;
                    if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                        this.encodeSession(session, responseChannel, this.bufferClaim.buffer(), this.bufferClaim.offset());
                        this.bufferClaim.commit();
                        break block3;
                    }
                    this.checkResultAndIdle(result);
                }
            }
            boolean offset = false;
            this.encodeSession(session, responseChannel, (MutableDirectBuffer)this.offerBuffer, 0);
            this.offer((DirectBuffer)this.offerBuffer, 0, length);
        }
    }

    @Override
    public void snapshotTimer(long correlationId, long deadline) {
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.timerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).deadline(deadline);
        this.bufferClaim.commit();
    }

    void snapshot(PendingServiceMessageTracker tracker, ErrorHandler errorHandler) {
        int length = 32;
        long nextServiceSessionId = ConsensusModuleSnapshotTaker.correctNextServiceSessionId(tracker, errorHandler);
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(32, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.pendingMessageTrackerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).nextServiceSessionId(nextServiceSessionId).logServiceSessionId(tracker.logServiceSessionId()).pendingMessageCapacity(tracker.pendingMessages().size()).serviceId(tracker.serviceId());
        this.bufferClaim.commit();
        tracker.pendingMessages().forEach((ExpandableRingBuffer.MessageConsumer)this, Integer.MAX_VALUE);
    }

    private void encodeSession(ClusterSession session, String responseChannel, MutableDirectBuffer buffer, int offset) {
        this.clusterSessionEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).clusterSessionId(session.id()).correlationId(session.correlationId()).openedLogPosition(session.openedLogPosition()).timeOfLastActivity(-1L).closeReason(session.closeReason()).responseStreamId(session.responseStreamId()).responseChannel(responseChannel);
    }

    private static long correctNextServiceSessionId(PendingServiceMessageTracker tracker, ErrorHandler errorHandler) {
        long nextServiceSessionId = tracker.pendingMessages().isEmpty() ? tracker.logServiceSessionId() + 1L : tracker.nextServiceSessionId();
        long missedServiceMessageCount = nextServiceSessionId - tracker.nextServiceSessionId();
        if (0L < missedServiceMessageCount) {
            String message = "Follower has missed " + missedServiceMessageCount + " service message(s).  Please check service (id=" + tracker.serviceId() + ") determinism around the use of Cluster::offer";
            errorHandler.onError((Throwable)new AeronEvent(message, AeronException.Category.ERROR));
        }
        return nextServiceSessionId;
    }
}

