/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.Publication;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.CloseHelper;

class PublicationGroup<P extends Publication>
implements AutoCloseable {
    private final String[] endpoints;
    private final String channelTemplate;
    private final int streamId;
    private final PublicationFactory<P> publicationFactory;
    int cursor = 0;
    private int excludedPublicationCursorValue = -1;
    private P current;

    PublicationGroup(String[] endpoints, String channelTemplate, int streamId, PublicationFactory<P> publicationFactory) {
        this.endpoints = endpoints;
        this.channelTemplate = channelTemplate;
        this.streamId = streamId;
        this.publicationFactory = publicationFactory;
    }

    P next(Aeron aeron) {
        int cursor = this.nextCursor();
        String endpoint = this.endpoints[cursor];
        ChannelUri channelUri = ChannelUri.parse((CharSequence)this.channelTemplate);
        channelUri.put("endpoint", endpoint);
        String channel = channelUri.toString();
        CloseHelper.quietClose(this.current);
        this.current = (Publication)this.publicationFactory.addPublication(aeron, channel, this.streamId);
        return this.current;
    }

    private int nextCursor() {
        do {
            ++this.cursor;
            if (this.endpoints.length > this.cursor) continue;
            this.cursor = 0;
        } while (this.cursor == this.excludedPublicationCursorValue);
        return this.cursor;
    }

    P current() {
        return this.current;
    }

    void clearExclusion() {
        this.excludedPublicationCursorValue = -1;
    }

    void closeAndExcludeCurrent() {
        this.excludedPublicationCursorValue = this.cursor;
        CloseHelper.quietClose(this.current);
    }

    void shuffle() {
        this.close();
        this.clearExclusion();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = this.endpoints.length;
        while (--i > -1) {
            int j = ((Random)random).nextInt(i + 1);
            String tmp = this.endpoints[i];
            this.endpoints[i] = this.endpoints[j];
            this.endpoints[j] = tmp;
        }
    }

    @Override
    public void close() {
        CloseHelper.quietClose(this.current);
    }

    public boolean isConnected() {
        return null != this.current && this.current.isConnected();
    }

    public String toString() {
        return "PublicationGroup{endpoints=" + Arrays.toString(this.endpoints) + ", channelTemplate='" + this.channelTemplate + '\'' + ", streamId=" + this.streamId + ", publicationFactory=" + this.publicationFactory + ", cursor=" + this.cursor + ", excludedPublicationCursorValue=" + this.excludedPublicationCursorValue + ", current=" + this.current + '}';
    }

    static interface PublicationFactory<P> {
        public P addPublication(Aeron var1, String var2, int var3);
    }
}

