/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.ClusterSessionDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ClusterSessionEncoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 103;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ClusterSessionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 103;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ClusterSessionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 40);
        return this;
    }

    public ClusterSessionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(40).templateId(103).schemaId(111).version(12);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int clusterSessionIdId() {
        return 1;
    }

    public static int clusterSessionIdSinceVersion() {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset() {
        return 0;
    }

    public static int clusterSessionIdEncodingLength() {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clusterSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long clusterSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ClusterSessionEncoder clusterSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ClusterSessionEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int openedLogPositionId() {
        return 3;
    }

    public static int openedLogPositionSinceVersion() {
        return 0;
    }

    public static int openedLogPositionEncodingOffset() {
        return 16;
    }

    public static int openedLogPositionEncodingLength() {
        return 8;
    }

    public static String openedLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long openedLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long openedLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long openedLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public ClusterSessionEncoder openedLogPosition(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int timeOfLastActivityId() {
        return 4;
    }

    public static int timeOfLastActivitySinceVersion() {
        return 0;
    }

    public static int timeOfLastActivityEncodingOffset() {
        return 24;
    }

    public static int timeOfLastActivityEncodingLength() {
        return 8;
    }

    public static String timeOfLastActivityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timeOfLastActivityNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timeOfLastActivityMinValue() {
        return -9223372036854775807L;
    }

    public static long timeOfLastActivityMaxValue() {
        return Long.MAX_VALUE;
    }

    public ClusterSessionEncoder timeOfLastActivity(long value) {
        this.buffer.putLong(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public static int closeReasonId() {
        return 5;
    }

    public static int closeReasonSinceVersion() {
        return 0;
    }

    public static int closeReasonEncodingOffset() {
        return 32;
    }

    public static int closeReasonEncodingLength() {
        return 4;
    }

    public static String closeReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ClusterSessionEncoder closeReason(CloseReason value) {
        this.buffer.putInt(this.offset + 32, value.value(), BYTE_ORDER);
        return this;
    }

    public static int responseStreamIdId() {
        return 6;
    }

    public static int responseStreamIdSinceVersion() {
        return 0;
    }

    public static int responseStreamIdEncodingOffset() {
        return 36;
    }

    public static int responseStreamIdEncodingLength() {
        return 4;
    }

    public static String responseStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int responseStreamIdMinValue() {
        return -2147483647;
    }

    public static int responseStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ClusterSessionEncoder responseStreamId(int value) {
        this.buffer.putInt(this.offset + 36, value, BYTE_ORDER);
        return this;
    }

    public static int responseChannelId() {
        return 7;
    }

    public static String responseChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String responseChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int responseChannelHeaderLength() {
        return 4;
    }

    public ClusterSessionEncoder putResponseChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ClusterSessionEncoder putResponseChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ClusterSessionEncoder responseChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public ClusterSessionEncoder responseChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ClusterSessionDecoder decoder = new ClusterSessionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 40, 12);
        return decoder.appendTo(builder);
    }
}

