/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClientSessionDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.SnapshotMarkerDecoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;

final class ServiceSnapshotLoader
implements ControlledFragmentHandler {
    private static final int FRAGMENT_LIMIT = 10;
    private boolean inSnapshot = false;
    private boolean isDone = false;
    private int appVersion;
    private TimeUnit timeUnit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SnapshotMarkerDecoder snapshotMarkerDecoder = new SnapshotMarkerDecoder();
    private final ClientSessionDecoder clientSessionDecoder = new ClientSessionDecoder();
    private final ImageControlledFragmentAssembler fragmentAssembler = new ImageControlledFragmentAssembler((ControlledFragmentHandler)this);
    private final Image image;
    private final ClusteredServiceAgent agent;

    ServiceSnapshotLoader(Image image, ClusteredServiceAgent agent) {
        this.image = image;
        this.agent = agent;
    }

    boolean isDone() {
        return this.isDone;
    }

    int appVersion() {
        return this.appVersion;
    }

    TimeUnit timeUnit() {
        return this.timeUnit;
    }

    int poll() {
        return this.image.controlledPoll((ControlledFragmentHandler)this.fragmentAssembler, 10);
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (111 != schemaId) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 100: {
                this.snapshotMarkerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long typeId = this.snapshotMarkerDecoder.typeId();
                if (2L != typeId) {
                    throw new ClusterException("unexpected snapshot type: " + typeId);
                }
                switch (this.snapshotMarkerDecoder.mark()) {
                    case BEGIN: {
                        if (this.inSnapshot) {
                            throw new ClusterException("already in snapshot");
                        }
                        this.inSnapshot = true;
                        this.appVersion = this.snapshotMarkerDecoder.appVersion();
                        this.timeUnit = ClusterClock.map(this.snapshotMarkerDecoder.timeUnit());
                        return ControlledFragmentHandler.Action.CONTINUE;
                    }
                    case END: {
                        if (!this.inSnapshot) {
                            throw new ClusterException("missing begin snapshot");
                        }
                        this.isDone = true;
                        return ControlledFragmentHandler.Action.BREAK;
                    }
                }
                break;
            }
            case 102: {
                this.clientSessionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.clientSessionDecoder.responseChannel();
                byte[] encodedPrincipal = new byte[this.clientSessionDecoder.encodedPrincipalLength()];
                this.clientSessionDecoder.getEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
                this.agent.addSession(this.clientSessionDecoder.clusterSessionId(), this.clientSessionDecoder.responseStreamId(), responseChannel, encodedPrincipal);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

