/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.cluster.ClusterClientSession;
import io.aeron.cluster.EgressPublisher;
import io.aeron.cluster.LogPublisher;
import io.aeron.cluster.client.ClusterEvent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.logbuffer.BufferClaim;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.errors.DistinctErrorLog;

final class ClusterSession
implements ClusterClientSession {
    static final byte[] NULL_PRINCIPAL = ArrayUtil.EMPTY_BYTE_ARRAY;
    static final int MAX_ENCODED_PRINCIPAL_LENGTH = 4096;
    static final int MAX_ENCODED_MEMBERSHIP_QUERY_LENGTH = 4096;
    private boolean hasNewLeaderEventPending = false;
    private boolean hasOpenEventPending = true;
    private final long id;
    private long correlationId;
    private long openedLogPosition = -1L;
    private long closedLogPosition = -1L;
    private transient long timeOfLastActivityNs;
    private long responsePublicationId = -1L;
    private final int responseStreamId;
    private final String responseChannel;
    private Publication responsePublication;
    private State state;
    private String responseDetail = null;
    private EventCode eventCode = null;
    private CloseReason closeReason = CloseReason.NULL_VAL;
    private byte[] encodedPrincipal = NULL_PRINCIPAL;
    private Action action = Action.CLIENT;
    private Object requestInput = null;

    ClusterSession(long sessionId, int responseStreamId, String responseChannel) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.state(State.INIT);
    }

    public void close(Aeron aeron, ErrorHandler errorHandler) {
        if (null == this.responsePublication) {
            aeron.asyncRemovePublication(this.responsePublicationId);
        } else {
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.responsePublication);
            this.responsePublication = null;
        }
        this.state(State.CLOSED);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    @Override
    public boolean isOpen() {
        return State.OPEN == this.state;
    }

    @Override
    public Publication responsePublication() {
        return this.responsePublication;
    }

    @Override
    public long timeOfLastActivityNs() {
        return this.timeOfLastActivityNs;
    }

    @Override
    public void timeOfLastActivityNs(long timeNs) {
        this.timeOfLastActivityNs = timeNs;
    }

    void loadSnapshotState(long correlationId, long openedLogPosition, long timeOfLastActivityNs, CloseReason closeReason) {
        this.openedLogPosition = openedLogPosition;
        this.timeOfLastActivityNs = timeOfLastActivityNs;
        this.correlationId = correlationId;
        this.closeReason = closeReason;
        if (CloseReason.NULL_VAL != closeReason) {
            this.state(State.CLOSING);
        } else {
            this.state(State.OPEN);
        }
    }

    int responseStreamId() {
        return this.responseStreamId;
    }

    String responseChannel() {
        return this.responseChannel;
    }

    void closing(CloseReason closeReason) {
        this.closeReason = closeReason;
        this.hasOpenEventPending = false;
        this.hasNewLeaderEventPending = false;
        this.timeOfLastActivityNs = 0L;
        this.state(State.CLOSING);
    }

    CloseReason closeReason() {
        return this.closeReason;
    }

    void resetCloseReason() {
        this.closedLogPosition = -1L;
        this.closeReason = CloseReason.NULL_VAL;
    }

    void asyncConnect(Aeron aeron) {
        this.responsePublicationId = aeron.asyncAddPublication(this.responseChannel, this.responseStreamId);
    }

    void connect(ErrorHandler errorHandler, Aeron aeron) {
        if (null != this.responsePublication) {
            throw new ClusterException("response publication already added");
        }
        try {
            this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
        }
        catch (RegistrationException ex) {
            errorHandler.onError((Throwable)((Object)new ClusterException("failed to connect session response publication: " + ex.getMessage(), AeronException.Category.WARN)));
        }
    }

    void disconnect(Aeron aeron, ErrorHandler errorHandler) {
        if (null == this.responsePublication) {
            aeron.asyncRemovePublication(this.responsePublicationId);
        } else {
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.responsePublication);
            this.responsePublication = null;
        }
    }

    boolean isResponsePublicationConnected(Aeron aeron, long nowNs) {
        if (null == this.responsePublication && !aeron.isCommandActive(this.responsePublicationId)) {
            this.responsePublication = aeron.getPublication(this.responsePublicationId);
            if (null != this.responsePublication) {
                this.responsePublicationId = -1L;
                this.timeOfLastActivityNs = nowNs;
                this.state(State.CONNECTING);
            } else {
                this.responsePublicationId = -1L;
                this.state(State.INVALID);
            }
        }
        return null != this.responsePublication && this.responsePublication.isConnected();
    }

    long tryClaim(int length, BufferClaim bufferClaim) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.tryClaim(length, bufferClaim);
    }

    long offer(DirectBuffer buffer, int offset, int length) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.offer(buffer, offset, length);
    }

    State state() {
        return this.state;
    }

    void state(State newState) {
        this.state = newState;
    }

    void authenticate(byte[] encodedPrincipal) {
        if (encodedPrincipal != null) {
            this.encodedPrincipal = encodedPrincipal;
        }
        this.state(State.AUTHENTICATED);
    }

    void open(long openedLogPosition) {
        this.openedLogPosition = openedLogPosition;
        this.state(State.OPEN);
    }

    boolean appendSessionToLogAndSendOpen(LogPublisher logPublisher, EgressPublisher egressPublisher, long leadershipTermId, int memberId, long nowNs, long clusterTimestamp) {
        long resultingPosition;
        if (this.responsePublication.availableWindow() > 0L && (resultingPosition = logPublisher.appendSessionOpen(this, leadershipTermId, clusterTimestamp)) > 0L) {
            this.open(resultingPosition);
            this.timeOfLastActivityNs(nowNs);
            this.sendSessionOpenEvent(egressPublisher, leadershipTermId, memberId);
            return true;
        }
        return false;
    }

    int sendSessionOpenEvent(EgressPublisher egressPublisher, long leadershipTermId, int memberId) {
        if (egressPublisher.sendEvent(this, leadershipTermId, memberId, EventCode.OK, "")) {
            this.clearOpenEventPending();
            return 1;
        }
        return 0;
    }

    void lastActivityNs(long timeNs, long correlationId) {
        this.timeOfLastActivityNs = timeNs;
        this.correlationId = correlationId;
    }

    void reject(EventCode code, String responseDetail, DistinctErrorLog errorLog, int clusterMemberId) {
        this.eventCode = code;
        this.responseDetail = responseDetail;
        this.state(State.REJECTED);
        if (null != errorLog) {
            errorLog.record((Throwable)((Object)new ClusterEvent((Object)((Object)code) + " " + responseDetail + ", clusterMemberId=" + clusterMemberId + ", id=" + this.id)));
        }
    }

    void reject(EventCode code, String responseDetail) {
        this.reject(code, responseDetail, null, -1);
    }

    EventCode eventCode() {
        return this.eventCode;
    }

    String responseDetail() {
        return this.responseDetail;
    }

    long correlationId() {
        return this.correlationId;
    }

    long openedLogPosition() {
        return this.openedLogPosition;
    }

    void closedLogPosition(long closedLogPosition) {
        this.closedLogPosition = closedLogPosition;
    }

    long closedLogPosition() {
        return this.closedLogPosition;
    }

    void hasNewLeaderEventPending(boolean flag) {
        this.hasNewLeaderEventPending = flag;
    }

    boolean hasNewLeaderEventPending() {
        return this.hasNewLeaderEventPending;
    }

    boolean hasOpenEventPending() {
        return this.hasOpenEventPending;
    }

    void clearOpenEventPending() {
        this.hasOpenEventPending = false;
    }

    Action action() {
        return this.action;
    }

    void action(Action action) {
        this.action = action;
    }

    void requestInput(Object requestInput) {
        this.requestInput = requestInput;
    }

    Object requestInput() {
        return this.requestInput;
    }

    static void checkEncodedPrincipalLength(byte[] encodedPrincipal) {
        if (null != encodedPrincipal && encodedPrincipal.length > 4096) {
            throw new ClusterException("encoded principal max length 4096 exceeded: length=" + encodedPrincipal.length);
        }
    }

    public String toString() {
        return "ClusterSession{id=" + this.id + ", correlationId=" + this.correlationId + ", openedLogPosition=" + this.openedLogPosition + ", closedLogPosition=" + this.closedLogPosition + ", timeOfLastActivityNs=" + this.timeOfLastActivityNs + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + '\'' + ", responsePublicationId=" + this.responsePublicationId + ", closeReason=" + (Object)((Object)this.closeReason) + ", state=" + (Object)((Object)this.state) + ", hasNewLeaderEventPending=" + this.hasNewLeaderEventPending + ", hasOpenEventPending=" + this.hasOpenEventPending + ", encodedPrincipal=" + Arrays.toString(this.encodedPrincipal) + '}';
    }

    static enum Action {
        CLIENT,
        BACKUP,
        HEARTBEAT,
        STANDBY_SNAPSHOT;

    }

    static enum State {
        INIT,
        CONNECTING,
        CONNECTED,
        CHALLENGED,
        AUTHENTICATED,
        REJECTED,
        OPEN,
        CLOSING,
        INVALID,
        CLOSED;

    }
}

