/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.node.CandidateTermDecoder;
import io.aeron.cluster.codecs.node.CandidateTermEncoder;
import io.aeron.cluster.codecs.node.MessageHeaderDecoder;
import io.aeron.cluster.codecs.node.MessageHeaderEncoder;
import io.aeron.cluster.codecs.node.NodeStateFooterEncoder;
import io.aeron.cluster.codecs.node.NodeStateHeaderDecoder;
import io.aeron.cluster.codecs.node.NodeStateHeaderEncoder;
import io.aeron.cluster.service.ClusterMarkFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.concurrent.UnsafeBuffer;

public class NodeStateFile
implements AutoCloseable {
    public static final String FILENAME = "node-state.dat";
    private static final int MINIMUM_FILE_LENGTH = 0x100000;
    private final CandidateTerm candidateTerm = new CandidateTerm();
    private final MappedByteBuffer mappedFile;
    private final int fileSyncLevel;
    private final NodeStateHeaderDecoder nodeStateHeaderDecoder = new NodeStateHeaderDecoder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final CandidateTermDecoder candidateTermDecoder = new CandidateTermDecoder();
    private final UnsafeBuffer buffer;
    private int candidateTermIdOffset;

    public NodeStateFile(File clusterDir, boolean createNew, int fileSyncLevel) throws IOException {
        UnsafeBuffer buffer;
        this.fileSyncLevel = fileSyncLevel;
        MappedByteBuffer mappedFile = null;
        try {
            File nodeStateFile = new File(clusterDir, FILENAME);
            if (!nodeStateFile.exists()) {
                if (!createNew) {
                    throw new IOException("NodeStateFile does not exist and createNew=false");
                }
                mappedFile = IoUtil.mapNewFile((File)nodeStateFile, (long)0x100000L);
                buffer = new UnsafeBuffer((ByteBuffer)mappedFile, 0, mappedFile.capacity());
                buffer.verifyAlignment();
                NodeStateFile.initialiseDecodersOnCreation((MutableDirectBuffer)buffer, this.nodeStateHeaderDecoder, this.messageHeaderDecoder, this.candidateTermDecoder);
                this.candidateTermIdOffset = this.calculateAndVerifyCandidateTermIdOffset();
                buffer.putLongVolatile(this.candidateTermIdOffset, -1L);
            } else {
                mappedFile = IoUtil.mapExistingFile((File)nodeStateFile, (String)"NodeState");
                buffer = new UnsafeBuffer((ByteBuffer)mappedFile, 0, mappedFile.capacity());
                this.loadDecodersAndOffsets(buffer);
            }
            this.syncFile(mappedFile);
        }
        catch (IOException | RuntimeException ex) {
            if (null != mappedFile) {
                IoUtil.unmap(mappedFile);
            }
            throw ex;
        }
        this.mappedFile = mappedFile;
        this.buffer = buffer;
    }

    private int calculateAndVerifyCandidateTermIdOffset() {
        int candidateTermIdOffset = this.candidateTermDecoder.offset() + CandidateTermDecoder.candidateTermIdEncodingOffset();
        NodeStateFile.verifyAlignment(candidateTermIdOffset);
        return candidateTermIdOffset;
    }

    private static void verifyAlignment(int offset) {
        if (0 != (offset & 7)) {
            throw new IllegalStateException("offset=" + offset + " is not correctly aligned, it is not divisible by " + 8);
        }
    }

    private static void loadInitialState(MutableDirectBuffer buffer, NodeStateHeaderDecoder nodeStateHeaderDecoder, CandidateTermDecoder candidateTermDecoder, MessageHeaderDecoder messageHeaderDecoder) {
        nodeStateHeaderDecoder.wrap((DirectBuffer)buffer, 0, 8, 10);
        int version = nodeStateHeaderDecoder.version();
        if (0 != SemanticVersion.major((int)version)) {
            throw new ClusterException("mark file major version " + SemanticVersion.major((int)version) + " does not match software: " + 0);
        }
        int footerOffset = NodeStateFile.scanForMessageTypeOffset(nodeStateHeaderDecoder.sbeBlockLength(), 304, (DirectBuffer)buffer, messageHeaderDecoder);
        if (-1 == footerOffset) {
            throw new IllegalStateException("failed to find NodeStateFooter entry, file corrupt?");
        }
        int candidateTermOffset = NodeStateFile.scanForMessageTypeOffset(nodeStateHeaderDecoder.sbeBlockLength(), 301, (DirectBuffer)buffer, messageHeaderDecoder);
        if (-1 == candidateTermOffset) {
            throw new IllegalStateException("failed to find CandidateTerm entry");
        }
        candidateTermDecoder.wrapAndApplyHeader((DirectBuffer)buffer, candidateTermOffset, messageHeaderDecoder);
    }

    private static void initialiseDecodersOnCreation(MutableDirectBuffer buffer, NodeStateHeaderDecoder nodeStateHeaderDecoder, MessageHeaderDecoder messageHeaderDecoder, CandidateTermDecoder candidateTermDecoder) {
        MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        nodeStateHeaderDecoder.wrap((DirectBuffer)buffer, 0, 8, 10);
        new NodeStateHeaderEncoder().wrap(buffer, 0).version(ClusterMarkFile.SEMANTIC_VERSION);
        int candidateTermFrameOffset = 8;
        NodeStateFile.verifyAlignment(8);
        CandidateTermEncoder candidateTermEncoder = new CandidateTermEncoder();
        candidateTermEncoder.wrapAndApplyHeader(buffer, 8, messageHeaderEncoder);
        candidateTermDecoder.wrapAndApplyHeader((DirectBuffer)buffer, 8, messageHeaderDecoder);
        candidateTermEncoder.logPosition(-1L).timestamp(-1L).candidateTermId(-1L);
        messageHeaderEncoder.frameLength(16 + candidateTermEncoder.encodedLength());
        int footerOffset = 8 + BitUtil.align((int)messageHeaderDecoder.frameLength(), (int)8);
        NodeStateFooterEncoder nodeStateFooterEncoder = new NodeStateFooterEncoder();
        nodeStateFooterEncoder.wrapAndApplyHeader(buffer, footerOffset, messageHeaderEncoder);
        messageHeaderEncoder.frameLength(16 + nodeStateFooterEncoder.encodedLength());
    }

    @Override
    public void close() {
        IoUtil.unmap((MappedByteBuffer)this.mappedFile);
    }

    public void updateCandidateTermId(long candidateTermId, long logPosition, long timestampMs) {
        this.buffer.putLong(this.candidateTermDecoder.offset() + CandidateTermDecoder.logPositionEncodingOffset(), logPosition);
        this.buffer.putLong(this.candidateTermDecoder.offset() + CandidateTermDecoder.timestampEncodingOffset(), timestampMs);
        this.buffer.putLongVolatile(this.candidateTermIdOffset, candidateTermId);
        this.syncFile(this.mappedFile);
    }

    public long proposeMaxCandidateTermId(long candidateTermId, long logPosition, long timestampMs) {
        long existingCandidateTermId = this.candidateTerm.candidateTermId();
        if (candidateTermId > existingCandidateTermId) {
            this.updateCandidateTermId(candidateTermId, logPosition, timestampMs);
            return candidateTermId;
        }
        return existingCandidateTermId;
    }

    public CandidateTerm candidateTerm() {
        return this.candidateTerm;
    }

    private void loadDecodersAndOffsets(UnsafeBuffer buffer) {
        NodeStateFile.loadInitialState((MutableDirectBuffer)buffer, this.nodeStateHeaderDecoder, this.candidateTermDecoder, this.messageHeaderDecoder);
        this.candidateTermIdOffset = this.calculateAndVerifyCandidateTermIdOffset();
    }

    private static int scanForMessageTypeOffset(int startPosition, int templateId, DirectBuffer buffer, MessageHeaderDecoder messageHeaderDecoder) {
        int messageLength;
        NodeStateFile.verifyAlignment(startPosition);
        for (int position = startPosition; position < buffer.capacity(); position += BitUtil.align((int)messageLength, (int)8)) {
            messageHeaderDecoder.wrap(buffer, position);
            messageLength = messageHeaderDecoder.frameLength();
            if (templateId == messageHeaderDecoder.templateId()) {
                return position;
            }
            if (304 == messageHeaderDecoder.templateId()) {
                return -1;
            }
            if (messageLength < 0) {
                throw new IllegalStateException("Message length < 0, file corrupt?");
            }
            if (0 != messageLength) continue;
            return -1;
        }
        return -1;
    }

    private void syncFile(MappedByteBuffer mappedFile) {
        if (0 < this.fileSyncLevel) {
            mappedFile.force();
        }
    }

    public final class CandidateTerm {
        private CandidateTerm() {
        }

        public long candidateTermId() {
            return NodeStateFile.this.buffer.getLongVolatile(NodeStateFile.this.candidateTermIdOffset);
        }

        public long timestamp() {
            return NodeStateFile.this.candidateTermDecoder.timestamp();
        }

        public long logPosition() {
            return NodeStateFile.this.candidateTermDecoder.logPosition();
        }
    }
}

