/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.TimerService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.DeadlineTimerWheel;
import org.agrona.collections.Long2LongHashMap;

final class WheelTimerService
extends DeadlineTimerWheel
implements DeadlineTimerWheel.TimerHandler,
TimerService {
    private final TimerService.TimerHandler timerHandler;
    private final Long2LongHashMap timerIdByCorrelationIdMap = new Long2LongHashMap(Long.MAX_VALUE);
    private final Long2LongHashMap correlationIdByTimerIdMap = new Long2LongHashMap(Long.MAX_VALUE);
    private boolean isAbort;

    WheelTimerService(TimerService.TimerHandler timerHandler, TimeUnit timeUnit, long startTime, long tickResolution, int ticksPerWheel) {
        super(timeUnit, startTime, tickResolution, ticksPerWheel);
        this.timerHandler = Objects.requireNonNull(timerHandler);
    }

    @Override
    public int poll(long now) {
        int expired = 0;
        this.isAbort = false;
        while (!this.isAbort && (expired += this.poll(now, this, 20)) < 20 && this.currentTickTime() < now) {
        }
        return expired;
    }

    public boolean onTimerExpiry(TimeUnit timeUnit, long now, long timerId) {
        long correlationId = this.correlationIdByTimerIdMap.get(timerId);
        if (this.timerHandler.onTimerEvent(correlationId)) {
            this.correlationIdByTimerIdMap.remove(timerId);
            this.timerIdByCorrelationIdMap.remove(correlationId);
            return true;
        }
        this.isAbort = true;
        return false;
    }

    @Override
    public void scheduleTimerForCorrelationId(long correlationId, long deadline) {
        this.cancelTimerByCorrelationId(correlationId);
        long timerId = this.scheduleTimer(deadline);
        this.timerIdByCorrelationIdMap.put(correlationId, timerId);
        this.correlationIdByTimerIdMap.put(timerId, correlationId);
    }

    @Override
    public boolean cancelTimerByCorrelationId(long correlationId) {
        long timerId = this.timerIdByCorrelationIdMap.remove(correlationId);
        if (Long.MAX_VALUE != timerId) {
            this.cancelTimer(timerId);
            this.correlationIdByTimerIdMap.remove(timerId);
            return true;
        }
        return false;
    }

    @Override
    public void snapshot(TimerService.TimerSnapshotTaker snapshotTaker) {
        Long2LongHashMap.EntryIterator iter = this.timerIdByCorrelationIdMap.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            long correlationId = iter.getLongKey();
            long deadline = this.deadline(iter.getLongValue());
            snapshotTaker.snapshotTimer(correlationId, deadline);
        }
    }

    @Override
    public void currentTime(long now) {
        this.currentTickTime(now);
    }
}

