/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.CommonContext;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.cluster.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.cluster.codecs.mark.VarAsciiEncodingEncoder;
import io.aeron.cluster.service.ClusterNodeControlProperties;
import java.io.File;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.MarkFile;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public final class ClusterMarkFile
implements AutoCloseable {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 3;
    public static final int PATCH_VERSION = 0;
    public static final int SEMANTIC_VERSION = SemanticVersion.compose((int)0, (int)3, (int)0);
    public static final int HEADER_LENGTH = 8192;
    public static final int VERSION_FAILED = -1;
    public static final int ERROR_BUFFER_MIN_LENGTH = 0x100000;
    public static final int ERROR_BUFFER_MAX_LENGTH = 0x7FFFDFFF;
    public static final String FILE_EXTENSION = ".dat";
    public static final String LINK_FILE_EXTENSION = ".lnk";
    public static final String FILENAME = "cluster-mark.dat";
    public static final String LINK_FILENAME = "cluster-mark.lnk";
    public static final String SERVICE_FILENAME_PREFIX = "cluster-mark-service-";
    private final MarkFileHeaderDecoder headerDecoder = new MarkFileHeaderDecoder();
    private final MarkFileHeaderEncoder headerEncoder = new MarkFileHeaderEncoder();
    private final MarkFile markFile;
    private final UnsafeBuffer buffer;
    private final UnsafeBuffer errorBuffer;

    public ClusterMarkFile(File file, ClusterComponentType type, int errorBufferLength, EpochClock epochClock, long timeoutMs) {
        if (errorBufferLength < 0x100000 || errorBufferLength > 0x7FFFDFFF) {
            throw new IllegalArgumentException("Invalid errorBufferLength: " + errorBufferLength);
        }
        boolean markFileExists = file.exists();
        int totalFileLength = 8192 + errorBufferLength;
        this.markFile = new MarkFile(file, markFileExists, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, version -> {
            if (-1 == version && markFileExists) {
                System.err.println("mark file version -1 indicates error on previous startup.");
            } else if (SemanticVersion.major((int)version) != 0) {
                throw new ClusterException("mark file major version " + SemanticVersion.major((int)version) + " does not match software: 0");
            }
        }, null);
        this.buffer = this.markFile.buffer();
        this.errorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, 8192, errorBufferLength);
        this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, 0);
        this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, 1);
        if (markFileExists) {
            if (this.buffer.capacity() != totalFileLength) {
                throw new ClusterException("ClusterMarkFile capacity=" + this.buffer.capacity() + " < expectedCapacity=" + totalFileLength);
            }
            int existingErrorBufferLength = this.headerDecoder.errorBufferLength();
            UnsafeBuffer existingErrorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, this.headerDecoder.headerLength(), existingErrorBufferLength);
            ClusterMarkFile.saveExistingErrors(file, (AtomicBuffer)existingErrorBuffer, type, CommonContext.fallbackLogger());
            existingErrorBuffer.setMemory(0, existingErrorBufferLength, (byte)0);
        } else {
            this.headerEncoder.candidateTermId(-1L);
        }
        ClusterComponentType existingType = this.headerDecoder.componentType();
        if (existingType != ClusterComponentType.NULL && existingType != type && (existingType != ClusterComponentType.BACKUP || ClusterComponentType.CONSENSUS_MODULE != type)) {
            throw new ClusterException("existing Mark file type " + existingType + " not same as required type " + type);
        }
        this.headerEncoder.componentType(type);
        this.headerEncoder.headerLength(8192);
        this.headerEncoder.errorBufferLength(errorBufferLength);
        this.headerEncoder.pid(SystemUtil.getPid());
        this.headerEncoder.startTimestamp(epochClock.time());
    }

    public ClusterMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        this(new MarkFile(directory, filename, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), timeoutMs, epochClock, version -> {
            if (SemanticVersion.major((int)version) != 0) {
                throw new ClusterException("mark file major version " + SemanticVersion.major((int)version) + " does not match software: 0");
            }
        }, logger));
    }

    ClusterMarkFile(MarkFile markFile) {
        this.markFile = markFile;
        this.buffer = markFile.buffer();
        this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, 1);
        this.errorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, this.headerDecoder.headerLength(), this.headerDecoder.errorBufferLength());
    }

    public File parentDirectory() {
        return this.markFile.parentDirectory();
    }

    public static boolean isServiceMarkFile(Path path, BasicFileAttributes attributes) {
        String fileName = path.getFileName().toString();
        return fileName.startsWith(SERVICE_FILENAME_PREFIX) && fileName.endsWith(FILE_EXTENSION);
    }

    public static boolean isConsensusModuleMarkFile(Path path, BasicFileAttributes attributes) {
        return path.getFileName().toString().equals(FILENAME);
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.markFile);
    }

    public boolean isClosed() {
        return this.markFile.isClosed();
    }

    public long candidateTermId() {
        return this.buffer.getLongVolatile(MarkFileHeaderDecoder.candidateTermIdEncodingOffset());
    }

    public int memberId() {
        return this.buffer.getInt(MarkFileHeaderDecoder.memberIdEncodingOffset());
    }

    public void memberId(int memberId) {
        this.buffer.putInt(MarkFileHeaderEncoder.memberIdEncodingOffset(), memberId);
    }

    public int clusterId() {
        return this.buffer.getInt(MarkFileHeaderDecoder.clusterIdEncodingOffset());
    }

    public void clusterId(int clusterId) {
        this.buffer.putInt(MarkFileHeaderEncoder.clusterIdEncodingOffset(), clusterId);
    }

    public void signalReady() {
        this.markFile.signalReady(SEMANTIC_VERSION);
    }

    public void signalFailedStart() {
        this.markFile.signalReady(-1);
    }

    public void updateActivityTimestamp(long nowMs) {
        if (!this.markFile.isClosed()) {
            this.markFile.timestampOrdered(nowMs);
        }
    }

    public long activityTimestampVolatile() {
        return this.markFile.timestampVolatile();
    }

    public MarkFileHeaderEncoder encoder() {
        return this.headerEncoder;
    }

    public MarkFileHeaderDecoder decoder() {
        return this.headerDecoder;
    }

    public AtomicBuffer errorBuffer() {
        return this.errorBuffer;
    }

    public static void saveExistingErrors(File markFile, AtomicBuffer errorBuffer, ClusterComponentType type, PrintStream logger) {
        CommonContext.saveExistingErrors((File)markFile, (AtomicBuffer)errorBuffer, (PrintStream)logger, (String)type.name());
    }

    public static void checkHeaderLength(String aeronDirectory, String controlChannel, String ingressChannel, String serviceName, String authenticator) {
        int length = 128 + 5 * VarAsciiEncodingEncoder.lengthEncodingLength() + (null == aeronDirectory ? 0 : aeronDirectory.length()) + (null == controlChannel ? 0 : controlChannel.length()) + (null == ingressChannel ? 0 : ingressChannel.length()) + (null == serviceName ? 0 : serviceName.length()) + (null == authenticator ? 0 : authenticator.length());
        if (length > 8192) {
            throw new ClusterException("ClusterMarkFile headerLength=" + length + " > headerLengthCapacity=8192");
        }
    }

    public static String markFilenameForService(int serviceId) {
        return SERVICE_FILENAME_PREFIX + serviceId + FILE_EXTENSION;
    }

    public static String linkFilenameForService(int serviceId) {
        return SERVICE_FILENAME_PREFIX + serviceId + LINK_FILE_EXTENSION;
    }

    public ClusterNodeControlProperties loadControlProperties() {
        MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(this.headerDecoder.buffer(), this.headerDecoder.offset(), 128, 1);
        return new ClusterNodeControlProperties(decoder.memberId(), decoder.serviceStreamId(), decoder.consensusModuleStreamId(), decoder.aeronDirectory(), decoder.controlChannel());
    }

    public void force() {
        if (!this.markFile.isClosed()) {
            MappedByteBuffer mappedByteBuffer = this.markFile.mappedByteBuffer();
            mappedByteBuffer.force();
        }
    }

    public String toString() {
        return "ClusterMarkFile{semanticVersion=" + SemanticVersion.toString((int)SEMANTIC_VERSION) + ", markFile=" + this.markFile.markFile() + "}";
    }
}

