/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.codecs.CloseReason;
import java.util.Collections;
import java.util.List;
import org.agrona.ExpandableRingBuffer;

class ConsensusModuleStateExport {
    final long logRecordingId;
    final long leadershipTermId;
    final long expectedAckPosition;
    final long nextSessionId;
    final long serviceAckId;
    final List<TimerStateExport> timers;
    final List<ClusterSessionStateExport> sessions;
    final List<PendingServiceMessageTrackerStateExport> pendingMessageTrackers;

    ConsensusModuleStateExport(long logRecordingId, long leadershipTermId, long expectedAckPosition, long nextSessionId, long serviceAckId, List<TimerStateExport> timers, List<ClusterSessionStateExport> sessions, List<PendingServiceMessageTrackerStateExport> pendingMessageTrackers) {
        this.logRecordingId = logRecordingId;
        this.leadershipTermId = leadershipTermId;
        this.expectedAckPosition = expectedAckPosition;
        this.nextSessionId = nextSessionId;
        this.serviceAckId = serviceAckId;
        this.timers = Collections.unmodifiableList(timers);
        this.sessions = Collections.unmodifiableList(sessions);
        this.pendingMessageTrackers = Collections.unmodifiableList(pendingMessageTrackers);
    }

    public String toString() {
        return "ConsensusModuleStateExport{logRecordingId=" + this.logRecordingId + ", leadershipTermId=" + this.leadershipTermId + ", expectedAckPosition=" + this.expectedAckPosition + ", nextSessionId=" + this.nextSessionId + ", serviceAckId=" + this.serviceAckId + ", timers=" + this.timers + ", sessions=" + this.sessions + ", pendingMessageTrackers=" + this.pendingMessageTrackers + "}";
    }

    static class PendingServiceMessageTrackerStateExport {
        final long nextServiceSessionId;
        final long logServiceSessionId;
        final int capacity;
        final int serviceId;
        final ExpandableRingBuffer pendingMessages;

        PendingServiceMessageTrackerStateExport(long nextServiceSessionId, long logServiceSessionId, int capacity, int serviceId, ExpandableRingBuffer pendingMessages) {
            this.nextServiceSessionId = nextServiceSessionId;
            this.logServiceSessionId = logServiceSessionId;
            this.capacity = capacity;
            this.serviceId = serviceId;
            this.pendingMessages = pendingMessages;
        }
    }

    static class ClusterSessionStateExport {
        final long id;
        final long correlationId;
        final long openedLogPosition;
        final long timeOfLastActivityNs;
        final int responseStreamId;
        final String responseChannel;
        final CloseReason closeReason;

        ClusterSessionStateExport(long id, long correlationId, long openedLogPosition, long timeOfLastActivityNs, int responseStreamId, String responseChannel, CloseReason closeReason) {
            this.id = id;
            this.correlationId = correlationId;
            this.openedLogPosition = openedLogPosition;
            this.timeOfLastActivityNs = timeOfLastActivityNs;
            this.responseStreamId = responseStreamId;
            this.responseChannel = responseChannel;
            this.closeReason = closeReason;
        }
    }

    static class TimerStateExport {
        final long correlationId;
        final long deadline;

        TimerStateExport(long correlationId, long deadline) {
            this.correlationId = correlationId;
            this.deadline = deadline;
        }
    }
}

