/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.node;

import io.aeron.cluster.codecs.node.CandidateTermDecoder;
import io.aeron.cluster.codecs.node.MessageHeaderEncoder;
import io.aeron.cluster.codecs.node.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class CandidateTermEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 301;
    public static final int SCHEMA_ID = 112;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CandidateTermEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 301;
    }

    public int sbeSchemaId() {
        return 112;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public CandidateTermEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public CandidateTermEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(24).templateId(301).schemaId(112).version(10);
        return this.wrap(buffer, offset + 16);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int candidateTermIdId() {
        return 1;
    }

    public static int candidateTermIdSinceVersion() {
        return 0;
    }

    public static int candidateTermIdEncodingOffset() {
        return 0;
    }

    public static int candidateTermIdEncodingLength() {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long candidateTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long candidateTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public CandidateTermEncoder candidateTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int timestampId() {
        return 2;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 8;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public CandidateTermEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int logPositionId() {
        return 3;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 16;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public CandidateTermEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        CandidateTermDecoder decoder = new CandidateTermDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 24, 10);
        return decoder.appendTo(builder);
    }
}

