/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.cluster.codecs.ClusterTimeUnit;
import java.util.concurrent.TimeUnit;

@FunctionalInterface
public interface ClusterClock {
    default public TimeUnit timeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public long time();

    default public long timeMillis() {
        return this.timeUnit().toMillis(this.time());
    }

    default public long timeMicros() {
        return this.timeUnit().toMicros(this.time());
    }

    default public long timeNanos() {
        return this.timeUnit().toNanos(this.time());
    }

    default public long convertToNanos(long time) {
        return this.timeUnit().toNanos(time);
    }

    public static ClusterTimeUnit map(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLISECONDS: {
                return ClusterTimeUnit.MILLIS;
            }
            case MICROSECONDS: {
                return ClusterTimeUnit.MICROS;
            }
            case NANOSECONDS: {
                return ClusterTimeUnit.NANOS;
            }
        }
        throw new IllegalArgumentException("unsupported time unit: " + timeUnit);
    }

    public static TimeUnit map(ClusterTimeUnit clusterTimeUnit) {
        switch (clusterTimeUnit) {
            case NULL_VAL: 
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalArgumentException("unsupported time unit: " + clusterTimeUnit);
    }
}

