/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;

public final class ClusterToolCommand {
    private final Action action;
    private final String description;

    public static Action ignoreFailures(Action actual) {
        return (clusterDir, out, args) -> {
            actual.act(clusterDir, out, args);
            return 0;
        };
    }

    public static Action action(ToIntBiFunction<File, PrintStream> actual) {
        return (clusterDir, out, args) -> actual.applyAsInt(clusterDir, out);
    }

    public static void printHelp(Map<String, ClusterToolCommand> commands, String prefix) {
        System.out.format("%s%n", prefix);
        int indentValue = Collections.max(commands.keySet().stream().map(String::length).toList()) + 1;
        String indentSpaces = new String(new char[indentValue + 2]).replace('\u0000', ' ');
        for (Map.Entry<String, ClusterToolCommand> command : commands.entrySet()) {
            int indent = indentValue - command.getKey().length();
            String description = command.getValue().describe().replaceAll("%n", "%n" + indentSpaces);
            System.out.printf("%" + indent + "s", " ");
            System.out.printf("%s: %s%n", command.getKey(), description);
        }
        System.out.flush();
    }

    public ClusterToolCommand(Action action, String description) {
        this.action = action;
        this.description = description;
    }

    public static Action action(ToIntFunction<File> actual) {
        return (clusterDir, out, args) -> actual.applyAsInt(clusterDir);
    }

    public String describe() {
        return this.description;
    }

    public Action action() {
        return this.action;
    }

    @FunctionalInterface
    public static interface Action {
        public int act(File var1, PrintStream var2, String[] var3);
    }
}

