/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class RequestVoteDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 51;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RequestVoteDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 51;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 13;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RequestVoteDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RequestVoteDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (51 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RequestVoteDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int logLeadershipTermIdId() {
        return 1;
    }

    public static int logLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logLeadershipTermId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int candidateTermIdId() {
        return 3;
    }

    public static int candidateTermIdSinceVersion() {
        return 0;
    }

    public static int candidateTermIdEncodingOffset() {
        return 16;
    }

    public static int candidateTermIdEncodingLength() {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long candidateTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long candidateTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long candidateTermId() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int candidateMemberIdId() {
        return 4;
    }

    public static int candidateMemberIdSinceVersion() {
        return 0;
    }

    public static int candidateMemberIdEncodingOffset() {
        return 24;
    }

    public static int candidateMemberIdEncodingLength() {
        return 4;
    }

    public static String candidateMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int candidateMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int candidateMemberIdMinValue() {
        return -2147483647;
    }

    public static int candidateMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int candidateMemberId() {
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public static int protocolVersionId() {
        return 5;
    }

    public static int protocolVersionSinceVersion() {
        return 9;
    }

    public static int protocolVersionEncodingOffset() {
        return 28;
    }

    public static int protocolVersionEncodingLength() {
        return 4;
    }

    public static String protocolVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int protocolVersionNullValue() {
        return 0;
    }

    public static int protocolVersionMinValue() {
        return 1;
    }

    public static int protocolVersionMaxValue() {
        return 0xFFFFFF;
    }

    public int protocolVersion() {
        if (this.parentMessage.actingVersion < 9) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 28, BYTE_ORDER);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RequestVoteDecoder decoder = new RequestVoteDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[RequestVote](sbeTemplateId=");
        builder.append(51);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 13) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(13);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("logLeadershipTermId=");
        builder.append(this.logLeadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("candidateTermId=");
        builder.append(this.candidateTermId());
        builder.append('|');
        builder.append("candidateMemberId=");
        builder.append(this.candidateMemberId());
        builder.append('|');
        builder.append("protocolVersion=");
        builder.append(this.protocolVersion());
        this.limit(originalLimit);
        return builder;
    }

    public RequestVoteDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

