/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.ClusterTimeUnit;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.SnapshotMark;
import io.aeron.cluster.codecs.SnapshotMarkerDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class SnapshotMarkerEncoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 100;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotMarkerEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 100;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 13;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotMarkerEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 40);
        return this;
    }

    public SnapshotMarkerEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(40).templateId(100).schemaId(111).version(13);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int typeIdId() {
        return 1;
    }

    public static int typeIdSinceVersion() {
        return 0;
    }

    public static int typeIdEncodingOffset() {
        return 0;
    }

    public static int typeIdEncodingLength() {
        return 8;
    }

    public static String typeIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long typeIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long typeIdMinValue() {
        return -9223372036854775807L;
    }

    public static long typeIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SnapshotMarkerEncoder typeId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public SnapshotMarkerEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int leadershipTermIdId() {
        return 3;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SnapshotMarkerEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int indexId() {
        return 4;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 24;
    }

    public static int indexEncodingLength() {
        return 4;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int indexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int indexMinValue() {
        return -2147483647;
    }

    public static int indexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public SnapshotMarkerEncoder index(int value) {
        this.buffer.putInt(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public static int markId() {
        return 5;
    }

    public static int markSinceVersion() {
        return 0;
    }

    public static int markEncodingOffset() {
        return 28;
    }

    public static int markEncodingLength() {
        return 4;
    }

    public static String markMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public SnapshotMarkerEncoder mark(SnapshotMark value) {
        this.buffer.putInt(this.offset + 28, value.value(), BYTE_ORDER);
        return this;
    }

    public static int timeUnitId() {
        return 6;
    }

    public static int timeUnitSinceVersion() {
        return 4;
    }

    public static int timeUnitEncodingOffset() {
        return 32;
    }

    public static int timeUnitEncodingLength() {
        return 4;
    }

    public static String timeUnitMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public SnapshotMarkerEncoder timeUnit(ClusterTimeUnit value) {
        this.buffer.putInt(this.offset + 32, value.value(), BYTE_ORDER);
        return this;
    }

    public static int appVersionId() {
        return 7;
    }

    public static int appVersionSinceVersion() {
        return 4;
    }

    public static int appVersionEncodingOffset() {
        return 36;
    }

    public static int appVersionEncodingLength() {
        return 4;
    }

    public static String appVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int appVersionNullValue() {
        return 0;
    }

    public static int appVersionMinValue() {
        return 1;
    }

    public static int appVersionMaxValue() {
        return 0xFFFFFF;
    }

    public SnapshotMarkerEncoder appVersion(int value) {
        this.buffer.putInt(this.offset + 36, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        SnapshotMarkerDecoder decoder = new SnapshotMarkerDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 40, 13);
        return decoder.appendTo(builder);
    }
}

