/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PendingSetupMessageFromSource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.cmd.ReceiverCmd;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public class Receiver
implements Agent,
Consumer<ReceiverCmd> {
    private final long statusMessageTimeout;
    private final DataTransportPoller dataTransportPoller;
    private final OneToOneConcurrentArrayQueue<ReceiverCmd> commandQueue;
    private final AtomicCounter totalBytesReceived;
    private final NanoClock clock;
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = new ArrayList();

    public Receiver(MediaDriver.Context ctx) {
        this.statusMessageTimeout = ctx.statusMessageTimeout();
        this.dataTransportPoller = ctx.dataTransportPoller();
        this.commandQueue = ctx.receiverCommandQueue();
        this.totalBytesReceived = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_RECEIVED);
        this.clock = ctx.nanoClock();
    }

    public String roleName() {
        return "receiver";
    }

    public int doWork() throws Exception {
        int workCount = this.commandQueue.drain((Consumer)this);
        int bytesReceived = this.dataTransportPoller.pollTransports();
        long now = this.clock.nanoTime();
        for (int i = this.publicationImages.size() - 1; i >= 0; --i) {
            PublicationImage image = this.publicationImages.get(i);
            if (!image.checkForActivity(now)) {
                image.removeFromDispatcher();
                this.publicationImages.remove(i);
                continue;
            }
            workCount += image.sendPendingStatusMessage(now, this.statusMessageTimeout);
            workCount += image.sendPendingNak();
        }
        this.timeoutPendingSetupMessages(now);
        this.totalBytesReceived.addOrdered((long)bytesReceived);
        return workCount + bytesReceived;
    }

    public void addPendingSetupMessage(int sessionId, int streamId, ReceiveChannelEndpoint channelEndpoint) {
        PendingSetupMessageFromSource cmd = new PendingSetupMessageFromSource(sessionId, streamId, channelEndpoint);
        cmd.timeOfStatusMessage(this.clock.nanoTime());
        this.pendingSetupMessages.add(cmd);
    }

    public void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.addSubscription(streamId);
    }

    public void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.removeSubscription(streamId);
    }

    public void onNewPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        this.publicationImages.add(image);
        channelEndpoint.addPublicationImage(image);
    }

    public void onRegisterReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        channelEndpoint.openChannel();
        channelEndpoint.registerForRead(this.dataTransportPoller);
        channelEndpoint.indicateActive();
    }

    public void onCloseReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        channelEndpoint.close();
    }

    public void onRemoveCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        channelEndpoint.removeCoolDown(sessionId, streamId);
    }

    @Override
    public void accept(ReceiverCmd cmd) {
        cmd.execute(this);
    }

    private void timeoutPendingSetupMessages(long now) {
        for (int i = this.pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource cmd = this.pendingSetupMessages.get(i);
            if (now <= cmd.timeOfStatusMessage() + Configuration.PENDING_SETUPS_TIMEOUT_NS) continue;
            this.pendingSetupMessages.remove(i);
            cmd.removeFromDataPacketDispatcher();
        }
    }
}

