/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DirectPublication;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import java.util.IdentityHashMap;
import java.util.Map;
import org.agrona.concurrent.status.ReadablePosition;

public class SubscriptionLink
implements DriverManagedResource {
    private final long registrationId;
    private final int streamId;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final AeronClient aeronClient;
    private final Map<PublicationImage, ReadablePosition> positionByImageMap = new IdentityHashMap<PublicationImage, ReadablePosition>();
    private final DirectPublication directPublication;
    private final ReadablePosition directPublicationSubscriberPosition;
    private final UdpChannel spiedChannel;
    private final long clientLivenessTimeoutNs;
    private NetworkPublication spiedPublication = null;
    private ReadablePosition spiedPosition = null;
    private boolean reachedEndOfLife = false;

    public SubscriptionLink(long registrationId, ReceiveChannelEndpoint channelEndpoint, int streamId, AeronClient aeronClient, long clientLivenessTimeoutNs) {
        this.registrationId = registrationId;
        this.channelEndpoint = channelEndpoint;
        this.streamId = streamId;
        this.aeronClient = aeronClient;
        this.directPublication = null;
        this.directPublicationSubscriberPosition = null;
        this.spiedChannel = null;
        this.clientLivenessTimeoutNs = clientLivenessTimeoutNs;
    }

    public SubscriptionLink(long registrationId, int streamId, DirectPublication directPublication, ReadablePosition subscriberPosition, AeronClient aeronClient, long clientLivenessTimeoutNs) {
        this.registrationId = registrationId;
        this.channelEndpoint = null;
        this.streamId = streamId;
        this.aeronClient = aeronClient;
        this.directPublication = directPublication;
        directPublication.incRef();
        this.directPublicationSubscriberPosition = subscriberPosition;
        this.spiedChannel = null;
        this.clientLivenessTimeoutNs = clientLivenessTimeoutNs;
    }

    public SubscriptionLink(long registrationId, UdpChannel spiedChannel, int streamId, AeronClient aeronClient, long clientLivenessTimeoutNs) {
        this.registrationId = registrationId;
        this.channelEndpoint = null;
        this.streamId = streamId;
        this.aeronClient = aeronClient;
        this.directPublication = null;
        this.directPublicationSubscriberPosition = null;
        this.spiedChannel = spiedChannel;
        this.clientLivenessTimeoutNs = clientLivenessTimeoutNs;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    public int streamId() {
        return this.streamId;
    }

    public UdpChannel spiedChannel() {
        return this.spiedChannel;
    }

    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        return channelEndpoint == this.channelEndpoint && streamId == this.streamId;
    }

    public boolean matches(SendChannelEndpoint channelEndpoint, int streamId) {
        boolean result = false;
        if (null != this.spiedChannel) {
            result = channelEndpoint.udpChannel().canonicalForm().equals(this.spiedChannel.canonicalForm()) && streamId == this.streamId();
        }
        return result;
    }

    public void addImage(PublicationImage image, ReadablePosition position) {
        this.positionByImageMap.put(image, position);
    }

    public void removeImage(PublicationImage image) {
        this.positionByImageMap.remove(image);
    }

    public void addSpiedPublication(NetworkPublication publication, ReadablePosition position) {
        this.spiedPublication = publication;
        this.spiedPosition = position;
    }

    public void removeSpiedPublication() {
        this.spiedPublication = null;
        this.spiedPosition = null;
    }

    public void close() {
        this.positionByImageMap.forEach(PublicationImage::removeSubscriber);
        if (null != this.directPublication) {
            this.directPublication.removeSubscription(this.directPublicationSubscriberPosition);
            this.directPublication.decRef();
        } else if (null != this.spiedPublication) {
            this.spiedPublication.removeSpyPosition(this.spiedPosition);
        }
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        if (time > this.aeronClient.timeOfLastKeepalive() + this.clientLivenessTimeoutNs) {
            this.reachedEndOfLife = true;
            conductor.cleanupSubscriptionLink(this);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
    }

    public long timeOfLastStateChange() {
        return this.aeronClient.timeOfLastKeepalive();
    }

    public void delete() {
        this.close();
    }
}

